<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'groupformation', language 'fr', version '4.1'.
 *
 * @package     groupformation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity'] = 'Activité';
$string['activity_end'] = 'Arrêter l\'activité';
$string['activity_start'] = 'Commencer l\'activité';
$string['activity_visible'] = 'l\'activité n\'es pas visible pour vous';
$string['add_line'] = 'Ajouter une ligne';
$string['adopt_groups_task'] = 'Tâche d\'adoption de groupe';
$string['allanswersrequired'] = 'Il faut répondre à toutes les questions afin de compléter l\'activité.';
$string['allanswersrequired_description'] = 'Il faut répondre à toutes les questions afin de compléter l\'activité.';
$string['alreadySubmitted'] = 'Déjà soumis';
$string['analyse'] = 'Analyse';
$string['answers_for_eval_text'] = 'Vous pouvez maintenant commencer la formation du groupe. Si vous avez répondu à toutes les questions, vous pouvez recevoir un feedback dans l\'onglet évaluation. Si vos réponses sont incomplètes, l\'évaluation n\'est pas possible en raison de réponses manquantes.';
$string['archive_activity_task'] = 'Tâche d\'archivage';
$string['archived_activity_admin'] = 'L\'activité a été archivée . Il n\' y a rien d\'autre de plus à faire.';
$string['archived_activity_answers'] = 'L\'activité a été archivée. Vos réponses ne sont plus archivées et il n\'y a rien à faire ici.';
$string['are'] = 'Il y a';
$string['are_now'] = 'Maintenant il y a';
$string['availability_nochangespossible'] = 'Le questionnaire a déjà été complété. Vous ne pouvez plus modifier la disponibilité.';
$string['bad'] = 'mauvais';
$string['build_groups_task'] = 'Tâche de formation de groupe';
$string['cannotloadxml'] = 'Impossible de charger le fichier XML';
$string['category_catfreetext'] = 'Texte libre';
$string['category_catmultiselect'] = 'Sélection multiple';
$string['category_catnumber'] = 'Nombre';
$string['category_character'] = 'Personnalité';
$string['category_demographic'] = 'Démographique';
$string['category_general'] = 'Général';
$string['category_grade'] = 'Buts';
$string['category_honesty'] = 'Honneteté';
$string['category_knowledge'] = 'Connaissance';
$string['category_learning'] = 'Apprentissage';
$string['category_motivation'] = 'Motivation';
$string['category_points'] = 'Buts';
$string['category_self'] = 'Auto-évaluation';
$string['category_sellmo'] = 'Motivation pour  l\'apprentissage et  la réussite';
$string['category_skills'] = 'Expérience';
$string['category_srl'] = 'Apprentissage autocontrolé';
$string['category_team'] = 'Equipe';
$string['category_times'] = 'Disponibilité';
$string['category_topic'] = 'Sujets';
$string['choose_evaluationmethod'] = 'Choisissez la méthode';
$string['choose_number'] = 'Choisissez un nombre';
$string['choose_scenario'] = 'Choisissez un scénario';
$string['cohort_index'] = 'Indice de performance des cohortes :';
$string['cohort_index_info'] = 'L\'indice de performance des cohortes (KPI) représente la qualité des groupes construits et se situe entre 0 et 1. Plus la valeur est élevée, plus les groupes construits sont performants.';
$string['committed_not_completed'] = 'des questionnaires déjà commencés ne sont pas complets.';
$string['completeTheForm'] = 'Complétez le questionnaire';
$string['completed_questionnaire'] = 'questionnaires complètement répondus .';
$string['consent_agree'] = 'J\'accepte les conditions';
$string['consent_alert_message'] = 'Vous devez donner votre consentement avant d\'accéder au questionnaire. Faites défiler vers le bas et acceptez les conditions avant de cliquer sur " Suivant ".';
$string['consent_header'] = 'Je veux participer au plugin de formation de groupes et j\'accepte de soumettre des réponses au questionnaire. La participation ou la non-participation n\'a aucun impact sur le processus de notation (ou les points de crédit).';
$string['consent_header_import'] = 'En important vos réponses, vous acceptez de participer au plugin  formation de groupes  et vous acceptez de soumettre des réponses au questionnaire. La participation ou la non-participation n\'a aucun impact sur le processus de notation (ou les points de crédit)';
$string['consent_message'] = 'ul><li>
Le professeur n\'a pas accès directement à mes réponses pour la formation du groupe (je peux seulement accéder à l\'évaluation sur ma personnalité ainsi qu\'à la moyenne du groupe).
</li><li>
Mes données personnelles seront effacées à la fin du cours - au plus tard après 360 jours.</li></ul>';
$string['consent_opt_in'] = 'Consentement (choisir de participer )';
$string['contact_members'] = 'Pour contacter les membres de votre équipe, vous pouvez cliquer sur leur nom d\'utilisateur.';
$string['continueTheForm'] = 'Continuez';
$string['cron_job_not_running'] = 'Afin de gérer les travaux en attente, un programme(cron) travaille en arrière-plan. Malheureusement, il ne répond pas ou ne fonctionne pas du tout. Si ce message continue à apparaître après 24 h, veuillez contacter l\'administrateur système.';
$string['drop_selection'] = 'Désélectionner tout';
$string['edit_param'] = 'Editer';
$string['editparam'] = 'Editer les paramètres';
$string['emailnotifications'] = '<i style="color:red ;">La notification automatique lorsque la formation de groupes est terminée est actuellement indisponible.</i>';
$string['emailnotifications_description'] = '<i style="color:red ;">La notification automatique lorsque la formation de groupe est terminée est actuellement indisponible.</i>';
$string['emailnotifications_info'] = 'Vous serez averti par message lorsqu\'il sera terminé';
$string['endtime'] = 'Heure de fin';
$string['eval_caption_course'] = 'Cours';
$string['eval_caption_group'] = 'Groupe';
$string['eval_caption_user'] = 'Utilisateur';
$string['eval_cutoff_caption_agreeableness'] = 'Agréabilité sociale';
$string['eval_cutoff_caption_challenge'] = 'Défi';
$string['eval_cutoff_caption_conscientiousness'] = 'Conscience';
$string['eval_cutoff_caption_extraversion'] = 'Extraversion';
$string['eval_cutoff_caption_interest'] = 'Intérêt';
$string['eval_cutoff_caption_lackofconfidence'] = 'Attente d\'échec';
$string['eval_cutoff_caption_neuroticism'] = 'neuroticisme';
$string['eval_cutoff_caption_openness'] = 'Ouverture à l\'expérience';
$string['eval_cutoff_caption_successprobability'] = 'Probabilité de succès';
$string['eval_final_text'] = 'La comparaison est basée sur {$a->pourcent}% des réponses des utilisateurs ({$a->complété} des utilisateurs de {$a->coursesize} ont déjà répondu)';
$string['eval_first_page_text'] = 'Vous recevez ainsi un feedback personnalisé sur vos réponses au questionnaire. Pour ce faire, les questions relatives au même sujet ont été regroupées et des valeurs moyennes ont été calculées et comparées avec l\'échantillon d\'un élève. Les rangs centiles ont été calculés, non pas dans le but de juger si une certaine valeur obtenue était bonne ou mauvaise, mais pour déterminer la fréquence de ces valeurs au sein de l\'échantillon d\'un élève. Un rang centile de 10 % signifie que 10 % de l\'échantillon de comparaison avait une valeur égale ou inférieure. D\'autre part, un rang centile de 90 % signifie que 90 % de l\'échantillon de comparaison a obtenu une valeur égale ou inférieure.\\n\\n
Tout d\'abord, vous recevez un feedback sur cinq caractéristiques de la personnalité, qui peuvent être comprises comme relativement stables, c\'est-à-dire indépendantes de situations spécifiques : l\'extraversion, le névrotisme, la conscience, l\'amabilité sociale et l\'ouverture à l\'expérience. Ensuite, vous recevrez un feedback sur quatre dimensions de la motivation, qui se rapportent au cours ou à l\'exercice académique en cours et peuvent donc varier d\'une situation à l\'autre : intérêt, défi, probabilité de succès et attente d\'échec.';
$string['eval_first_page_title'] = 'Information Générale';
$string['eval_max_caption_agreeableness'] = 'agréable';
$string['eval_max_caption_challenge'] = 'Défi';
$string['eval_max_caption_conscientiousness'] = 'consciencieux';
$string['eval_max_caption_extraversion'] = 'extraverti';
$string['eval_max_caption_interest'] = 'Intérêt';
$string['eval_max_caption_lackofconfidence'] = 'Attente d\'échec';
$string['eval_max_caption_neuroticism'] = 'stable émotionnellement';
$string['eval_max_caption_openness'] = 'ouvert';
$string['eval_max_caption_successprobability'] = 'Probabilité de succès';
$string['eval_max_text_agreeableness'] = 'L\'agréabilité sociale fait référence au comportement envers les autres personnes';
$string['eval_max_text_challenge'] = 'Le défi est une dimension de la motivation, qui exprime dans quelle mesure le cours ou l\'exercice actuel est interprété comme étant lié à la performance, c\'est-à-dire dans quelle mesure vous avez envie d\'exercer vos propres compétences et vos capacités.';
$string['eval_max_text_conscientiousness'] = 'Le facteur " Conscience " décrit principalement le degré de maîtrise de soi, de précision et de détermination';
$string['eval_max_text_extraversion'] = 'L\'introversion et l\'extraversion sont deux pôles d\'un trait de personnalité qui se caractérise par l\'interaction avec l\'environnement. L\'introversion dénote une attitude tournée vers l\'intérieur alors que l\'extraversion dénote une attitude tournée vers l\'extérieur.';
$string['eval_max_text_interest'] = 'L\'intérêt est une dimension de la motivation, qui découle de l\'appréciation du contenu d\'une tâche. L\'intérêt s\'exprime, entre autres, par le fait que les tâches sont exécutées avec plaisir et volontairement. L\'intérêt contribue grandement au succès de l\'apprentissage, surtout lorsque les tâches sont exécutées de manière autonome et que l\'on vise une compréhension approfondie.';
$string['eval_max_text_lackofconfidence'] = 'L\'attente d\'un échec est une forme de motivation, qui naît de la peur de ne pas réussir dans la tâche, combinée à l\'idée qu\'en raison de la pression de la situation, on ne pourra pas étudier de manière optimale.';
$string['eval_max_text_neuroticism'] = 'Le facteur de personnalité "Neuroticisme" reflète les différences individuelles dans l\'expérience des émotions négatives et est également connu sous le nom de labilité émotionnelle. Le pôle opposé est également appelé stabilité émotionnelle.';
$string['eval_max_text_openness'] = 'Le facteur "Ouverture à l\'expérience" décrit l\'intérêt et le degré d\'engagement dans de nouvelles expériences et impressions.';
$string['eval_max_text_successprobability'] = 'La probabilité de réussite comprend des hypothèses sur le degré de confiance que l\'on a dans l\'obtention d\'une bonne évaluation dans le cours ou l\'exercice en cours. Une forte probabilité de succès peut découler de l\'estimation d\'être suffisamment capable ou de trouver la tâche  facile.';
$string['eval_min_caption_agreeableness'] = 'compétitif';
$string['eval_min_caption_challenge'] = 'Défi';
$string['eval_min_caption_conscientiousness'] = 'négligent';
$string['eval_min_caption_extraversion'] = 'introverti';
$string['eval_min_caption_interest'] = 'Intérêt';
$string['eval_min_caption_lackofconfidence'] = 'Attente  d\'un échec';
$string['eval_min_caption_neuroticism'] = 'émotionnellement instable';
$string['eval_min_caption_openness'] = 'conservateur';
$string['eval_min_caption_successprobability'] = 'Probabilité de succès';
$string['eval_min_text_agreeableness'] = 'L\'agréabilité sociale fait référence au comportement envers les autres personnes.';
$string['eval_min_text_challenge'] = 'Le défi est une dimension de la motivation, qui exprime dans quelle mesure le cours ou l\'exercice actuel est interprété comme étant lié à la performance, c\'est-à-dire dans quelle mesure vous avez envie d\'exercer vos propres compétences et vos capacités';
$string['eval_min_text_conscientiousness'] = 'Le facteur " Conscience " décrit principalement le degré de maîtrise de soi, de précision et de détermination.';
$string['eval_min_text_extraversion'] = 'L\'introversion et l\'extraversion sont deux pôles d\'un trait de personnalité qui se caractérise par l\'interaction avec l\'environnement. L\'introversion dénote une attitude tournée vers l\'intérieur alors que l\'extraversion dénote une attitude tournée vers l\'extérieur.';
$string['eval_min_text_interest'] = 'L\'intérêt est une dimension de la motivation, qui découle de l\'appréciation du contenu d\'une tâche. L\'intérêt s\'exprime, entre autres, par le fait que les tâches sont exécutées avec plaisir et volontairement. L\'intérêt contribue grandement au succès de l\'apprentissage, surtout lorsque les tâches sont exécutées de manière autonome et que l\'on vise une compréhension approfondie.';
$string['eval_min_text_lackofconfidence'] = 'L\'attente d\'un échec est une forme de motivation, qui naît de la peur de ne pas réussir dans la tâche, combinée à l\'idée qu\'en raison de la pression de la situation, on ne pourra pas étudier de manière optimale.';
$string['eval_min_text_neuroticism'] = 'Le facteur de personnalité "Neuroticisme " reflète les différences individuelles dans l\'expérience des émotions négatives et est également connu sous le nom de labilité émotionnelle. Le pôle opposé est également appelé stabilité émotionnelle.';
$string['eval_min_text_openness'] = 'Le facteur "Ouverture à l\'expérience" décrit l\'intérêt et le degré d\'engagement dans de nouvelles expériences et de nouvelles perceptions.';
$string['eval_min_text_successprobability'] = 'La probabilité de réussite comprend des hypothèses sur le degré de confiance que l\'on a dans l\'obtention d\'une bonne évaluation dans le cours ou l\'exercice en cours. Une forte probabilité de succès peut découler de l\'estimation d\'être suffisamment capable ou de trouver la tâche aussi facile.';
$string['eval_name_big5'] = 'Personnalité';
$string['eval_name_fam'] = 'Motivation';
$string['eval_text_big5_agreeableness_1'] = 'Vos faibles scores en matière d\'agréabilité indiquent que vous êtes fondamentalement plutôt argumentatif, égocentrique et méfiant des intentions des autres. Vous vous comportez de façon plus compétitive que coopérative, vous avez la capacité de vous battre pour vos propres intérêts et vous êtes moins conciliant.';
$string['eval_text_big5_agreeableness_2'] = 'Vos notes moyennes en matière d\'agréabilité indiquent que vous n\'êtes pas prédisposé à être ni fortement égocentrique ni altruiste. On ne vous qualifierait ni de particulièrement méfiant, ni de particulièrement rapide à faire confiance, ni d\'extrêmement docile, ni d\'extrêmement têtu.';
$string['eval_text_big5_agreeableness_3'] = 'Vos scores élevés en matière d\'agréabilité indiquent qu\'en général vous êtes plus altruiste. Vous traitez les autres avec compréhension, gentillesse et empathie, et vous essayez d\'aider les autres et supposez que les autres agiront aussi de manière utile. Vous avez tendance à faire preuve de confiance, de coopération et de conformité.';
$string['eval_text_big5_conscientiousness_1'] = 'Vous semblez avoir un score plutôt bas en matière de conscience. En conséquence, on peut conclure que vous avez tendance à être spontané et que vous agissez plutôt négligemment et de manière inexacte.';
$string['eval_text_big5_conscientiousness_2'] = 'Vous semblez avoir un score moyen en matière de conscience. En conséquence, on peut supposer que vous avez une relation équilibrée entre la conscience et le relâchement et que vous n\'êtes ni très strictement organisé ni désorganisé.';
$string['eval_text_big5_conscientiousness_3'] = 'Vous semblez avoir un score élevé en matière de conscience. On peut donc supposer que vous êtes organisé, que vous planifiez soigneusement, que vous êtes efficace, responsable et fiable, et que vous agissez de façon sensée.';
$string['eval_text_big5_extraversion_1'] = 'Vos réponses indiquent un faible score en matière d\'extraversion. Par conséquent, vous avez probablement tendance à vous comporter de façon introvertie et discrète dans les interactions sociales et vous êtes heureux seul et en solitaire. Les personnes introverties sont souvent décrites comme étant calmes, tranquilles et réservées.';
$string['eval_text_big5_extraversion_2'] = 'Vos réponses suggèrent un score moyen sur l\'extraversion. En conséquence, vous êtes probablement enthousiaste dans une mesure assez modérée et vous n\'êtes pas particulièrement dominant ou bavard.';
$string['eval_text_big5_extraversion_3'] = 'Vos réponses indiquent un score élevé en matière d\'extraversion. Par conséquent, vous avez probablement tendance à socialiser, à exprimer un comportement actif et bavard, à être optimiste et chaleureux, et vous réagissez probablement avec une plus grande susceptibilité aux stimuli et aux excitations.';
$string['eval_text_big5_neuroticism_1'] = 'Vous semblez avoir un faible score de Neuroticisme. En conséquence, vous êtes plutôt calme, satisfait, stable, détendu et vous vous sentez en sécurité et vous êtes souvent capable de mieux gérer les situations stressantes.';
$string['eval_text_big5_neuroticism_2'] = 'Vous semblez avoir un score moyen sur le neuroticisme. Par conséquent, vous n\'éprouvez ni particulièrement souvent ni rarement de l\'anxiété, de la nervosité, de la tension, de la tristesse, de l\'incertitude et de la gêne. Dans les situations de stress, vous n\'êtes ni particulièrement sensible aux problèmes ni particulièrement robuste face à ceux-ci.';
$string['eval_text_big5_neuroticism_3'] = 'Vous semblez avoir un score assez élevé en matière de neuroticisme. Par conséquent, vous éprouvez fréquemment de l\'anxiété, de la nervosité, de la tension, de la tristesse, de l\'incertitude et de l\'embarras. De plus, ces sentiments vous accompagnent plus longtemps et se déclenchent plus facilement. Vous avez tendance à être plus inquiet pour votre santé, à développer des idées irréalistes et vous avez de la difficulté à réagir aux situations stressantes.';
$string['eval_text_big5_openness_1'] = 'Vous avez obtenu des scores en matière d\'ouverture plutôt faibles. Cela suggère que vous êtes plus enclin à un comportement conventionnel et à des attitudes conservatrices. Vous préférez les choses établies et approuvées aux choses nouvelles et vous percevez vos réactions émotionnelles plutôt atténuées. Vous agissez de façon pragmatique ici et maintenant.';
$string['eval_text_big5_openness_2'] = 'Vous avez obtenu des valeurs en matière d\'ouverture moyennes. Cela indique que vous n\'avez pas tendance à avoir des attitudes et des comportements très conventionnels ni  très peu conventionnels. Pour vous, la disposition visionnaire et imaginative est en équilibre avec une vie pragmatique ici et maintenant.';
$string['eval_text_big5_openness_3'] = 'Vous avez obtenu des scores assez élevés en matière d\'ouverture. Cela suggère que vous avez une vie fantaisiste active et que vous vous intéressez à de nombreux domaines privés et publics. Ces personnes sont souvent décrites comme étant intellectuelles, expérimentales et ayant un intérêt artistique, elles se comportent souvent de manière non conventionnelle et préfèrent la variété.';
$string['eval_text_fam_challenge_1'] = 'Le cours ou l\'exercice actuel a été considéré par vous comme  peu difficile. Cela peut être positif pour des tâches externes , mais peut avoir des effets négatifs lorsque l\'exercice est réalisé pour soi même.';
$string['eval_text_fam_challenge_2'] = 'Le cours ou l\'exercice actuel a été considéré par vous comme n\'étant ni particulièrement difficile ni très simple.';
$string['eval_text_fam_challenge_3'] = 'Le cours ou l\'exercice actuel a été considéré par vous comme particulièrement difficile. Cela peut être négatif dans le cas où l\'exercice est soumis en externe. Au contraire, il peut avoir des effets très positifs si l\'exercice est réalisé pour soi-même.';
$string['eval_text_fam_interest_1'] = 'Vous semblez peu intéressé par le contenu du cours ou de l\'exercice en cours, ce qui peut être mauvais pour votre propre apprentissage, dans le cas où le processus lui-même se déroule de manière plus autonome.';
$string['eval_text_fam_interest_2'] = 'Vous semblez avoir un intérêt modéré pour le contenu du cours ou de l\'exercice en cours.';
$string['eval_text_fam_interest_3'] = 'Vous semblez avoir un grand intérêt pour le contenu du cours ou de l\'exercice en cours, ce qui devrait être bon pour votre propre apprentissage, au cas où le processus lui-même se déroulerait de manière plus auto-dirigée.';
$string['eval_text_fam_lackofconfidence_1'] = 'Votre score suggère l\'hypothèse que votre attente d\'échec est peu prononcée chez vous. Cela pourrait être dû à une peur de l\'échec généralement inexistante ou à l\'anxiété liée au test, mais pourrait aussi être lié à des facteurs plus spécifiques et situationnels du cours ou de l\'exercice en cours. On croit généralement que l\'absence d\'attente d\'échec a un effet positif sur l\'apprentissage.';
$string['eval_text_fam_lackofconfidence_2'] = 'Votre score suggère l\'hypothèse que votre attente d\'échec est modérée. Cela pourrait être dû à une peur générale de l\'échec ou à l\'anxiété liée au test, mais pourrait aussi être lié à des facteurs plus spécifiques et situationnels du cours ou de l\'exercice en cours. En général, on croit que les attentes d\'échec ont un impact négatif sur les études.';
$string['eval_text_fam_lackofconfidence_3'] = 'Votre score suggère l\'hypothèse que l\'attente d\'un échec est très prononcée chez vous. Cela pourrait être dû à une peur générale de l\'échec ou à l\'anxiété liée au test, mais pourrait aussi être lié à des facteurs plus spécifiques et situationnels du cours ou de l\'exercice en cours. En général, on croit que l\'attente d\'un échec a un impact négatif sur les études.';
$string['eval_text_fam_successprobability_1'] = 'Vous avez considéré que vous avez de faibles probabilités de réussite dans le cours ou l\'exercice en cours. Habituellement, cela a un effet négatif sur le processus d\'apprentissage.';
$string['eval_text_fam_successprobability_2'] = 'Vous avez considéré que vous obtiendrez des résultats modérés dans le cours ou l\'exercice en cours. Cela ne devrait pas avoir une influence particulièrement bonne ou mauvaise sur votre processus d\'apprentissage.';
$string['eval_text_fam_successprobability_3'] = 'Vous avez considéré que vous réussirez très probablement le cours ou l\'exercice en cours. De façon générale, cela devrait faciliter le processus d\'apprentissage.';
$string['evaluation'] = 'Evaluation';
$string['evaluation_point_info'] = 'indiquer le maximum de points disponibles';
$string['evaluationmethod_description'] = 'Comment évaluez-vous le travail ?';
$string['evaluationmethod_error'] = 'Veuillez choisir une méthode d\'évaluation.';
$string['excellent'] = 'excellent';
$string['export'] = 'Exporter';
$string['export_all'] = 'Exporter toutes les données personnelles';
$string['export_all_data_check'] = 'Inclure les données personnelles de toutes les formations de groupe dans l\'ensemble du système Moodle (conformément au Règlement Général de l\'UE sur la Protection des Données RGPD)';
$string['export_all_description'] = 'Vous pouvez exporter ici toutes vos données personnelles enregistrées par cette activité :';
$string['export_answers'] = 'Vous pouvez télécharger toutes les réponses avec des identifiants anonymes ici :';
$string['export_description_no'] = 'Vous ne pouvez pas exporter vos réponses puisque vous n\'avez répondu à aucune question dans les catégories exportables.';
$string['export_description_yes'] = 'Vous pouvez exporter vos réponses en cliquant sur le bouton ci-dessous.';
$string['export_group_users'] = 'Vous pouvez télécharger tous les groupes avec des identifiants d\'utilisateur anonymes ici :';
$string['export_groups'] = 'Vous pouvez télécharger tous les groupes avec des identifiants d\'utilisateur anonymes ici :';
$string['export_logging'] = 'Vous pouvez télécharger toutes les relations groupe-utilisateurs avec des identifiants anonymes ici :';
$string['export_users'] = 'Vous pouvez télécharger ici toutes les données relatives aux utilisateurs avec des identifiants anonymes :';
$string['failed_import'] = 'L\'importation a échoué en raison d\'un format non valide. Veuillez télécharger un fichier avec un format de réponse exportable';
$string['file_error'] = 'Vous devez télécharger un fichier *.xml.';
$string['freetext_noanswer'] = 'Pas de réponse';
$string['generategroups'] = 'Générer des groupes';
$string['go_to_group_view'] = 'vers la vue de groupe de Moodle';
$string['grades'] = 'Notes';
$string['groupSettingsInfo'] = 'Vous avez choisi de définir des thèmes. Le nombre de groupes et leur taille seront calculés, comme vous pouvez le voir ci-dessous.';
$string['group_building'] = 'Construction de groupe';
$string['group_overview'] = 'Aperçu des groupes construits';
$string['groupformation'] = 'Formation de groupe';
$string['groupformation:addinstance'] = 'Ajouter formation de groupe';
$string['groupformation:editsettings'] = 'Editer formation de groupe';
$string['groupformation:onlymanager'] = 'Formation de groupes : seulement manager';
$string['groupformation:onlyread'] = 'Formation de groupes : seulement lire';
$string['groupformation:onlystudent'] = 'Formation de groupes : seulement étudiant';
$string['groupformation:readsettings'] = 'Formation de groupes : lecture des paramètres';
$string['groupformation:submit'] = 'Formation de groupes : envoyer';
$string['groupformation:view'] = 'Formation de groupes : vues';
$string['groupformation_message'] = 'La formation de groupes est terminée. Vous pouvez maintenant visualiser le résultat.';
$string['groupformation_message_contexturlname'] = 'résultats';
$string['groupformation_subject'] = 'Formation de groupes terminé';
$string['groupformationfieldset'] = 'Exemple de jeu de champs personnalisé';
$string['groupformationname'] = 'Formation de groupes';
$string['groupformationname_help'] = 'Conseils pour la formation de groupes';
$string['groupformationsettings'] = 'Paramètres de Formation de groupes';
$string['groupingNotReady'] = 'La formation de groupes n\'est pas encore terminée';
$string['grouping_abort'] = 'Annuler les groupes de génération';
$string['grouping_adopt'] = 'Adopter des groupes';
$string['grouping_delete'] = 'Supprimer des groupes';
$string['grouping_delete_moodle_groups'] = 'Supprimer des groupes Moodle';
$string['grouping_edit'] = 'Editer des groupes';
$string['grouping_start'] = 'débuter la formation de groupes';
$string['grouping_status_0'] = 'Vous devez fermer le questionnaire pour débuter la formation de groupes';
$string['grouping_status_1'] = 'Vous pouvez débuter maintenant  la formation de groupes';
$string['grouping_status_2'] = 'La formation du groupe est en cours. Ce processus peut durer de 2 à 5 minutes. Veuillez recharger la page de temps en temps pour voir le résultat.';
$string['grouping_status_3'] = 'La fin de la formation de groupe est en cours';
$string['grouping_status_4'] = 'La formation du groupe est terminée. Vous pouvez reprendre les groupes dans Moodle ou générer un nouveau résultat par algorithme.';
$string['grouping_status_5'] = 'Les groupes générés sont adoptés par Moodle. Vous pouvez les ajuster manuellement.';
$string['grouping_status_6'] = 'Les groupes générés vont être adoptés par Moodle. Ce processus peut prendre de 2 à 5 minutes. Veuillez recharger la page de temps en temps pour voir le résultat.';
$string['groupname'] = 'Nom du groupement';
$string['groupname_error'] = 'Veuillez choisir un nom de moins de 100 caractères.';
$string['groupname_help'] = 'Le nom du groupe choisi sera un préfixe pour les groupes générés. Le schéma est [nom du groupe]_XXX, où XXX est le numéro du groupe.';
$string['groupnameexists'] = 'Ce groupe existe déjà.';
$string['groupoption_allanswersrequired'] = 'Avant de passer à la page suivante du questionnaire, il faut répondre à toutes les questions.';
$string['groupoption_description'] = 'Description des paramètres du groupe';
$string['groupoption_help'] = 'Ce paramètre peut être optimisé après la soumission des questionnaires.';
$string['groupoption_onlyactivestudents'] = 'Les élèves sans réponses ne seront pas affectés à un groupe.';
$string['groupoptions'] = 'Paramètres de groupe';
$string['groupsize'] = 'Taille des groupes :';
$string['import'] = 'Importer';
$string['import_description_no'] = 'Vous ne pouvez pas importer vos réponses car vous avez déjà soumis vos réponses ou le questionnaire n\'est pas disponible.';
$string['import_description_yes'] = 'Vous pouvez importer vos réponses en cliquant sur le bouton ci-dessous et en téléchargeant un fichier au format de réponse exportable.';
$string['import_form_description'] = 'Vous pouvez importer vos réponses des questionnaires précédents en soumettant un fichier "answers.xml" ci-dessous.';
$string['inactive_members_are'] = 'Les utilisateurs qui ont quitté le groupe ou le cours :';
$string['info_header_student'] = 'A quoi sert la "formation de groupes" ?';
$string['info_header_teacher_analysis'] = 'Comment fonctionne l\'activité de formation de groupe ?';
$string['info_header_teacher_settings'] = 'Comment fonctionne l\'activité de formation de groupe ?';
$string['info_text_student'] = 'Dans ce cours Moodle, la "formation de groupe" est utilisée pour construire une coopération réussie {$a->nom_du_scénario}.
        Après avoir rempli et soumis le questionnaire, vos partenaires d\'apprentissage appropriés seront déterminés.
        Tous les détails sont gardés confidentiels.
        <br>Une fois le questionnaire expiré, les groupes seront générés en tenant compte de vos données et de vos préférences.
        <br><br>
        Des questions, des problèmes ou des suggestions ?
        Vous pouvez trouver le développeur du plugin et le scientifique sous<br>
        https://github.com/moodlepeers <br>
        (créé et développé avec des moyens pour l\'amélioration de la qualité de l\'enseignement à l\'Université technique de Darmstadt)';
$string['info_text_teacher_analysis'] = 'Avec ce plugin, vous avez la possibilité d\'optimiser la formation de groupe de vos élèves. Les trois étapes requises sont:<br>
        1.) Ajoutez l\'activité "groupformation" à votre cours.
        Dans les paramètres, vous pouvez choisir le scénario qui correspond le mieux à vos besoins (en cas de doute, choisissez des équipes de projet).
        Les autres paramètres vous permettent de spécifier la taille du groupe et/ou les connaissances préalables des étudiants. Si les connaissances préalables des étudiants doivent se compléter,
        vous pouvez le spécifier dans les paramètres.
        2.) Les étudiants reçoivent le questionnaire qui est basé sur vos paramètres. Vous pouvez définir la période pendant laquelle le questionnaire est disponible (voir étape 1).
        Un aperçu du questonnaire peut être trouvé plus tard en ouvrant l\'activité comme un docent.<br>
        3.) Les statistiques des réponses peuvent être trouvées en ouvrant l\'activité. Si vous êtes satisfait de la réponse, vous pouvez lancer la formation de groupe manuellement (cela ne se fait jamais automatiquement).
        Il faudra un certain temps avant que les groupes soient formés. Vous pouvez voir les groupes générés avant de les adopter à Moodle.<br>
        <br>
        Terminé. Maintenant, les élèves peuvent aussi voir leurs camarades de groupe. En tant que document, vous pouvez ajuster manuellement les groupes à tout moment dans Moodle (par exemple avec des retardataires).';
$string['info_text_teacher_settings'] = 'Avec ce plugin, vous avez la possibilité d\'optimiser la formation de groupe de vos élèves. Les trois étapes requises sont:<br>
        1.) Ajoutez l\'activité "groupformation" à votre cours.
        Dans les paramètres, vous pouvez choisir le scénario qui correspond le mieux à vos besoins (en cas de doute, choisissez des équipes de projet).
        Les autres paramètres vous permettent de spécifier la taille du groupe et/ou les connaissances préalables des étudiants. Si les connaissances préalables des étudiants doivent se compléter,
        vous pouvez le spécifier dans les paramètres.
        2.) Les étudiants reçoivent le questionnaire qui est basé sur vos paramètres. Vous pouvez définir la période pendant laquelle le questionnaire est disponible (voir étape 1).
        Un aperçu du questonnaire peut être trouvé plus tard en ouvrant l\'activité comme un docent.<br>
        3.) Les statistiques des réponses peuvent être trouvées en ouvrant l\'activité. Si vous êtes satisfait de la réponse, vous pouvez lancer la formation de groupe manuellement (cela ne se fait jamais automatiquement).
        Il faudra un certain temps avant que les groupes soient formés. Vous pouvez voir les groupes générés avant de les adopter à Moodle.<br>
        <br>
        Terminé. Maintenant, les élèves peuvent aussi voir leurs camarades de groupe. En tant que document, vous pouvez ajuster manuellement les groupes à tout moment dans Moodle (par exemple avec des retardataires).';
$string['input'] = 'Entrée :';
$string['invalid'] = 'Statut invalide';
$string['jobget_name'] = 'Formation de groupes et nettoyage';
$string['justpass'] = 'Il suffit de passer';
$string['knowledge'] = 'Connaissance';
$string['knowledgeChoice'] = 'Connaissance';
$string['knowledge_description'] = 'Je veux inclure les questions de connaissance';
$string['knowledge_description_extended'] = 'Veuillez énumérer les domaines de connaissances dans lesquels les étudiants doivent s\'évaluer.
    Jetez un coup d\'œil à l\'aperçu sur le côté droit.';
$string['knowledge_dummy'] = 'Exemple';
$string['knowledge_help'] = 'Si les thèmes (option ci-dessous) sont activés, cette option est automatiquement désactivée et désactivée.';
$string['knowledge_info_homework'] = 'Veuillez énumérer les domaines de connaissances dans lesquels les étudiants doivent s\'évaluer.
    Jetez un coup d\'œil à l\'aperçu sur le côté droit.
    En fonction de votre sélection, les connaissances préalables des "groupes de devoirs" seront variées au sein de chaque groupe';
$string['knowledge_info_presentation'] = 'Veuillez énumérer les domaines de connaissances dans lesquels les étudiants doivent s\'évaluer.
    Jetez un coup d\'œil à l\'aperçu sur le côté droit.
    En fonction de votre sélection, les connaissances préalables des "groupes de devoirs" seront variées au sein de chaque groupe';
$string['knowledge_info_project'] = 'Veuillez énumérer les domaines de connaissances dans lesquels les étudiants doivent s\'évaluer.
    Jetez un coup d\'œil à l\'aperçu sur le côté droit.
    Selon votre sélection, les "groupes de présentation", les connaissances préalables seront variées au sein de chaque groupe (ignorées lorsque les thèmes sont fixés)';
$string['knowledge_question'] = 'Que savez-vous sur les sujets suivants ?';
$string['knowledge_scale'] = '0 = aucune connaissance, 100 = grande connaissance';
$string['max_group_size'] = 'Taille maximale du groupe :';
$string['max_group_size_not_reached'] = 'La taille maximale des groupes n\'a pas été atteinte par les groupes suivants :';
$string['maxgroups'] = 'Nombre max. de groupes';
$string['maxgroups_error'] = 'Veuillez choisir un nombre supérieur à 0';
$string['maxmembers'] = 'Nombre max. de membres du groupe';
$string['maxmembers_error'] = 'Veuillez choisir un nombre supérieur à 0';
$string['maxpoints'] = 'Points max.';
$string['maxpoints_error'] = 'Veuillez choisir un nombre entre 1 et 100';
$string['members_are'] = 'Les membres de votre groupe sont :';
$string['messageprovider:submission'] = 'Avertissez-moi si l\'algorithme de formation de groupe est terminé';
$string['modulename'] = 'Formation de groupes';
$string['modulename_help'] = 'Le plugin formation de groupes  génère des groupes de participants sur la base des réponses à un questionnaire.';
$string['modulenameplural'] = 'Formation de groupes';
$string['name_by_group'] = 'Nom :';
$string['namingschema'] = 'Système de nommage';
$string['noGroup'] = 'Aucun groupe ne vous a été attribué parce que vous n\'avez pas répondu au questionnaire.';
$string['noUser'] = 'L\'utilisateur n\'existe pas';
$string['no_data_to_display'] = 'Pas de données à afficher';
$string['no_evaluation_ready'] = 'Votre évaluation n\'est pas disponible .L\'évaluation de vos réponses est réalisée lorsque  vous avez répondu à tout et avez soumis vos réponses.';
$string['no_evaluation_text'] = 'Il n\'y a pas d\'évaluation pour cette activité de formation de groupe.';
$string['no_time'] = 'Aucune heure fixée';
$string['nochangespossible'] = 'Le questionnaire a déjà été complété.
Vous ne pouvez modifier que le nombre maximum de membres ou le nombre maximum de groupes. Les modifications ultérieures ne seront pas enregistrées.';
$string['noevaluation'] = 'Pas d\'évaluation';
$string['nogroupformation'] = 'Pas de formation de groupe';
$string['none'] = 'aucun';
$string['notOpen'] = 'La soumission est close.';
$string['notamember'] = '(Groupe de gauche ou cours';
$string['number_member'] = 'Nombre de membres :';
$string['number_of_groups'] = 'Nombre de groupes construits :';
$string['oneManGroup'] = 'Vous êtes un groupe d\'un seul homme.';
$string['onlyactivestudents'] = 'Seuls les étudiants ayant soumis au moins une réponse doivent être pris en considération pour la constitution de groupes.';
$string['onlyactivestudents_description'] = 'Seuls les étudiants ayant soumis au moins une réponse doivent être pris en considération pour la constitution de groupes.';
$string['onlyactivestudents_info'] = 'Seuls les étudiants ayant soumis au moins une réponse seront pris en compte pour la formation du groupe. Ceci peut être configuré dans le {$a->url}.';
$string['options'] = 'Options';
$string['overview'] = 'Aperçu';
$string['page_title_analysis'] = 'Activité';
$string['page_title_evaluation'] = 'Evaluation';
$string['page_title_export'] = 'Export';
$string['page_title_group'] = 'Affectation des groupes';
$string['page_title_grouping'] = 'Formation de groupe';
$string['page_title_grouping_edit'] = 'Formation de groupe -Mode édition';
$string['page_title_import_export'] = 'Importation et exportation';
$string['page_title_overview'] = 'Aperçu';
$string['participant_code_alert_message'] = 'Vous devez entrer un code de participant valide avant d\'accéder au questionnaire. Faites défiler vers le bas et entrez votre code de participant';
$string['participant_code_footer'] = 'Votre code personnel de participant est';
$string['participant_code_title'] = 'Code du participant';
$string['password_wrong'] = 'mauvais mot de passe';
$string['pluginadministration'] = 'Administration : Formation de groupes';
$string['pluginname'] = 'Formation de groupe';
$string['points'] = 'Points';
$string['preview'] = 'Prévisualisation :';
$string['quality'] = 'Qualité du groupe';
$string['quality_info'] = 'Le Group-Performance-Index (GPI) représente la qualité du groupe construit et se situe entre 0 et 1. Plus la valeur est élevée, plus le groupe est performant. Si aucune valeur n\'est mentionnée, le groupe n\'est pas construit de manière algorithmique, mais aléatoire.';
$string['questionnaire_answer_stats'] = 'État actuel du questionnaire :';
$string['questionnaire_availability_info_future'] = 'Le questionnaire sera disponible dans le période de {$a->début} à {$a->fin}';
$string['questionnaire_availability_info_now'] = 'Le questionnaire est disponible jusqu\'au {$a->fin}.';
$string['questionnaire_available'] = 'Le questionnaire est prêt à être traité.';
$string['questionnaire_available_end'] = 'Le questionnaire est disponible jusqu\'au {$a->fin}.';
$string['questionnaire_committed'] = 'Vos réponses sont soumises. Vous ne pouvez pas les modifier dans le cadre de cette activité.';
$string['questionnaire_delete'] = 'Supprimer le consentement';
$string['questionnaire_go_to_start'] = 'Aller au début';
$string['questionnaire_no_more_questions'] = 'Il n\'y a plus de questions auxquelles il faut répondre.';
$string['questionnaire_not_available'] = 'Le questionnaire n\'est pas disponible pour le moment.';
$string['questionnaire_not_available_begin'] = 'Le questionnaire est disponible à partir de {$a->début}.';
$string['questionnaire_not_available_begin_end'] = 'The questionnaire is available from {$a->Début } to {$a->Fin}.';
$string['questionnaire_not_available_end'] = 'Le questionnaire n\'est plus disponible.';
$string['questionnaire_not_started'] = 'Le questionnaire est prêt.';
$string['questionnaire_not_submitted'] = 'Vos réponses ne sont pas encore soumises.';
$string['questionnaire_outdated'] = 'Cette activité est trop ancienne. La fonctionnalité correcte ne peut être assurée. Veuillez créer une nouvelle activité pour profiter de toutes les fonctionnalités.';
$string['questionnaire_press_beginning_submit'] = 'Cliquez sur "aller au début " pour revenir à la page d\'accueil. Vous pouvez y soumettre vos réponses actuelles.';
$string['questionnaire_press_continue_submit'] = 'Cliquez sur "Modifier" pour continuer le questionnaire ou sur "Soumettre" pour soumettre vos réponses actuelles.
Vous pouvez également retirer votre consentement, qui supprime également toutes les réponses données, en cliquant sur "Supprimer le consentement".';
$string['questionnaire_press_preview'] = 'Cliquez sur "Aperçu" pour consulter le questionnaire';
$string['questionnaire_press_revert'] = 'Cliquez sur "Revenir" pour revenir sur votre décision de soumettre le questionnaire. Vous pouvez également retirer votre consentement, qui supprime également toutes les réponses données, en cliquant sur "Retirer le consentement".';
$string['questionnaire_press_to_begin'] = 'Donnez votre consentement et cliquez sur "Suivant" pour commencer.';
$string['questionnaire_press_to_begin_participant_code'] = 'Entrez votre code de participant et donnez votre accord. Cliquez sur "Suivant" pour commencer.';
$string['questionnaire_preview'] = 'Ceci est un aperçu du questionnaire.';
$string['questionnaire_submit'] = 'Soumettre des réponses';
$string['questionnaire_submit_disabled_teacher'] = 'La soumission est désactivée car il ne s\'agit que d\'un aperçu.';
$string['questionnaire_submitted'] = 'Vous avez soumis vos réponses. Annulez votre soumission ou retirez votre consentement pour recommencer.';
$string['remove_line'] = 'Supprimer la ligne';
$string['sampleGroupName'] = 'Le nom de votre groupe est';
$string['scenario'] = 'Scénario';
$string['scenarioInfo'] = 'Les trois scénarios diffèrent dans la manière dont les éléments du questionnaire influencent la formation du groupe.
            Pour les équipes de projet, il prend en compte les connaissances préalables et les traits des membres du groupe pour s\'amender mutuellement, tandis que la motivation (niveau) et les objectifs personnels doivent être aussi similaires que possible.
            Pour les groupes de devoirs, il optimise chaque groupe afin d\'avoir les meilleures conditions préalables possibles pour l\'apprentissage collaboratif.
            Pour les groupes de présentation, l\'aspect principal est un intérêt mutuel pour le même sujet de travail choisi (et assigné au groupe).';
$string['scenario_description'] = 'Veuillez choisir le scénario le plus approprié pour la formation du groupe.';
$string['scenario_error'] = 'Veuillez choisir un scénario';
$string['scenario_homeworkgroups'] = 'Groupes de devoirs';
$string['scenario_homeworkgroups_description'] = 'Les groupes réalisent des plus petits  devoirs à intervalles réguliers (souvent hebdomadaires) afin de  préparer les examens. Même si les tâches assignées (souvent appelées exercices, pratique, questions de contrôle ou devoirs) sont  partageables entre les membres du groupe, ce n\'est pas le cas  lors de l\'examen final, chaque membre sera noté individuellement et doit être capable de résoudre toutes les tâches seul. Par conséquent, la formation de groupe en utilisant  les diverses connaissances préalables et les different styles d\'apprentissage profite aux uns et aux autres.';
$string['scenario_homeworkgroups_short'] = 'Les domaines de connaissance et les objectifs visés sont hétérogènes ; l\'orientation de l\'équipe est homogène.';
$string['scenario_presentationgroups'] = 'Groupes de présentation';
$string['scenario_presentationgroups_description'] = 'Les groupes de présentation travaillent ensemble pendant une période relativement courte pour terminer une présentation (qui se déroule généralement en classe). Souvent, au début, une sous-tâche spécifique est attribuée à (ou sélectionnée par) chaque étudiant, travaillée individuellement et finalement réassemblée en une présentation complète. La notation est généralement effectuée pour la performance de l\'ensemble du groupe. Par conséquent, la formation de groupe vise principalement à susciter un intérêt mutuel pour le même sujet.';
$string['scenario_presentationgroups_short'] = 'Permet exclusivement de commander une liste de sujets par Drag&Drop. La procédure du "premier arrivé, premier servi" est évitée pour permettre une répartition plus équitable des sujets.';
$string['scenario_projectteams'] = 'Équipes de projet';
$string['scenario_projectteams_description'] = 'Les équipes de projet travaillent intensivement ensemble pour mener à bien un projet (par exemple, réalisation d\'une étude, remise d\'un rapport, etc.) ). Souvent, les tâches et les devoirs peuvent être répartis entre les membres de l\'équipe. Par conséquent, il est avantageux d\'avoir un mélange de compétences d\'amendement dans l\'équipe. Habituellement, le résultat d\'un tel travail collectif est noté avec une note de groupe égale pour tous les membres. Ainsi, la formation de groupe vise une motivation et des objectifs similaires (outre les conditions préalables).';
$string['scenario_projectteams_short'] = 'Les domaines de connaissance et la motivation sont hétérogènes ; le niveau de connaissance, les objectifs visés et l\'orientation de l\'équipe sont homogènes ; les traits de caractère sont partiellement homogènes, partiellement hétérogènes.';
$string['scenario_usage_header'] = 'Questionnaire-Utilisation';
$string['scenario_usage_header_presentation'] = 'Les étudiants définissent leurs préférences';
$string['select_info'] = 'Sélectionner les membres du groupe pour les déplacer vers un autre groupe';
$string['settings_archiving_time'] = 'Temps d\'archivage';
$string['settings_archiving_time_description'] = 'Après x jours, l\'activité sera archivée.';
$string['settings_description'] = 'Paramètres d\'archivage et fonctionnalités supplémentaires.';
$string['settings_header'] = 'Général';
$string['settings_import_export'] = 'Importation/exportation des réponses';
$string['settings_import_export_description'] = 'Si cette option est activée, les élèves peuvent exporter leurs réponses et importer des réponses dans un autre cas.';
$string['settings_participant_code'] = 'Code du participant';
$string['settings_participant_code_description'] = 'Les étudiants doivent entrer un code de participant (tel qu\'il est utilisé dans les tests psychologiques).';
$string['starttime'] = 'Heure de début';
$string['statistic'] = 'Statistiques du questionnaire';
$string['stats_all'] = 'Vous avez répondu à toutes les questions de la catégorie "{$a->catégorie}".';
$string['stats_none'] = 'Vous n\'avez répondu à aucune question dans la catégorie "{$a->catégorie}".';
$string['stats_partly'] = 'Vous avez répondu {$a->réponse} à l\'une des questions {$a->questions} de la catégorie "{$a->catégorie}".';
$string['students_answered_multiple'] = 'les étudiants ont répondu au questionnaire.';
$string['students_answered_single'] = 'l\'étudiant a répondu au questionnaire.';
$string['students_available_multiple'] = 'les étudiants inscrits qui peuvent remplir le questionnaire.';
$string['students_available_single'] = 'étudiant inscrit qui peut remplir le questionnaire.';
$string['students_committed_multiple'] = 'Les étudiants ont également déjà donné leurs réponses.';
$string['students_committed_single'] = 'L étudiants a également déjà donné ses réponses.';
$string['students_enrolled_info'] = 'Les étudiants sont inscrits à ce cours';
$string['students_grouping_multiple'] = 'des étudiants pour la constitution de groupes';
$string['students_grouping_single'] = 'étudiant pour la constitution de groupes.';
$string['students_selected'] = 'étudiants sélectionnés';
$string['submit-modal-text'] = 'À des fins scientifiques et pour le processus de formation de groupes, il est important que vous répondiez à toutes les questions de manière sincère et correcte. Nous serions reconnaissants de votre participation.

Cliquez sur "Annuler" si vous souhaitez modifier vos réponses avant de les soumettre.';
$string['submit-modal-title'] = 'Soumettez vos réponses';
$string['successful_import'] = 'L\'importation a été un succès. Vous pouvez revoir vos réponses dans le questionnaire.';
$string['tab_analysis'] = 'Analyse';
$string['tab_evaluation'] = 'Evaluation';
$string['tab_group'] = 'Affectation des groupes';
$string['tab_grouping'] = 'Formation de groupes';
$string['tab_overview'] = 'Aperçu';
$string['tab_preview'] = 'Questionnaire (aperçu)';
$string['tab_questionnaire'] = 'Questionnaire';
$string['tabletitle_catfreetext'] = 'Texte libre';
$string['tabletitle_catmultiselect'] = 'Multisélection';
$string['tabletitle_catnumber'] = 'Nombre';
$string['tabletitle_character'] = 'personnalité';
$string['tabletitle_demographic'] = 'Demographie';
$string['tabletitle_general'] = 'Général';
$string['tabletitle_grade'] = 'Buts';
$string['tabletitle_honesty'] = 'Honneteté';
$string['tabletitle_knowledge'] = 'Que savez-vous sur les sujets suivants ?';
$string['tabletitle_learning'] = 'Apprentissage';
$string['tabletitle_motivation'] = 'Motivation';
$string['tabletitle_points'] = 'Buts';
$string['tabletitle_self'] = 'Auto-évaluation';
$string['tabletitle_sellmo'] = 'Motivation de l\'apprentissage et de la réussite';
$string['tabletitle_skills'] = 'Expérience';
$string['tabletitle_srl'] = 'Apprentissage autonome';
$string['tabletitle_team'] = 'Equipe';
$string['tabletitle_times'] = 'Disponibilité';
$string['tabletitle_topic'] = 'Sujets';
$string['time'] = 'Temps';
$string['topic'] = 'Sujet';
$string['topic_group_info'] = 'Votre sujet est';
$string['topicchoice'] = 'Sélection du sujet';
$string['topics'] = 'Sujets';
$string['topics_description'] = 'Je veux définir des sujets';
$string['topics_description_extended'] = 'Veuillez énumérer les sujets proposés au choix des étudiants  <strong>La formation des groupes est alors optimisée en utilisant exclusivement les préférences de sélection des sujets.</forte> Toutes les autres parties du questionnaire seront ignorées.';
$string['topics_dummy'] = 'Sujet';
$string['topics_help'] = 'Si l\'on utilise les sujets alors les questions de connaissance sont désactivées et le nombre de groupes est fixé par le nombre de sujets.';
$string['topics_question'] = 'Veuillez classer les sujets suivants en fonction de vos intérêts personnels et commencez par votre sujet préféré. Faites un tri par glisser-déposer.';
$string['topics_statistics'] = 'Statistiques des sujets proposés';
$string['topics_statistics_description'] = 'Les notes suivantes indiquent les sujets préférés par les étudiants, c\'est-à-dire qu\'une note proche de 1 indique que le sujet est plus apprécié que les sujets ayant une note proche de 0.';
$string['topics_statistics_score'] = 'Note  [0-1]';
$string['unselect_all'] = 'Désélectionner tout';
$string['useOneLineForEachKnowledge'] = 'Utilisez une ligne pour chaque sujet';
$string['useOneLineForEachTopic'] = 'Utilisez une ligne pour chaque sujet';
$string['userpergroup'] = 'Combien d\'utilisateurs dans un groupe ?';
$string['your_group'] = 'Le nom de votre groupe est :';
