<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dyslexic', language 'fr', version '4.1'.
 *
 * @package     block_dyslexic
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['defaut_font'] = 'Police par défaut';
$string['dyslexic:addinstance'] = 'Ajouter un bloc Mode dyslexique';
$string['dyslexic:myaddinstance'] = 'Ajouter un bloc Mode dyslexique au tableau de bord';
$string['howto_description'] = 'Le bloc Mode dyslexique utilise la technologie Javascript pour modifier l\'affichage du site à l\'aide de CSS.</br> Le choix de l\'utilisateur est stocké dans les cookies.';
$string['howto_title'] = 'En cours';
$string['info'] = 'Qu\'est-ce que la dyslexie ?';
$string['intro'] = 'La police OpenDyslexic améliore la lisibilité pour les dyslexiques.</br> Quelle police souhaitiez-vous utiliser ?';
$string['link'] = 'En savoir plus sur la police OpenDyslexic';
$string['moving_description'] = 'Certains dyslexiques ont cette impression : ils peuvent lire, mais ont besoin de mobiliser une grande concentration parce que les lettres semblent bouger. Cette page permet d\'échanger ses impressions';
$string['moving_title'] = 'Pourquoi tout bouge ?';
$string['opendyslexic_font'] = 'Police OpenDyslexic';
$string['pluginname'] = 'Module Dyslexique';
$string['readmore'] = 'En savoir plus…';
$string['script_info'] = 'Script pour l\'animation de la page à partir de :';
$string['script_off'] = 'Arrêter l\'animation !';
$string['script_on'] = 'Relire l\'animation';
$string['wikipedia_description'] = 'La dyslexie est un trouble de la lecture et de l’écriture spécifique et durable qui apparaît chez l\'enfant et l\'adolescent (certains auteurs l\'appellent aussi dyslexie développementale). La dyslexie est reconnue comme un trouble spécifique de l\'apprentissage (abrégé TSA) et trouble en dys-.</br>
La dyslexie est un trouble dont les causes ne sont pas suffisamment éclaircies et qui fait l\'objet de nombreuses études et débats. Dans ce contexte, définir et diagnostiquer précisément la dyslexie reste un sujet de controverse. La dyslexie est définie à la fois par des résultats à des tests de lecture comparés aux normes (points de vue psychométrique et cognitif) et par des critères médicaux (diagnostic), comme un trouble spécifique qui exclut les causes d\'origine uniquement sensorielle (problème de vue ou d\'audition), uniquement contextuelle (sociale) ou uniquement psychologique (affective). Des études en neurosciences font l\'hypothèse d\'un trouble neurologique spécifique, dont l\'origine génétique est discutée.</br>
Le diagnostic, d\'ordre médical, se fait selon les critères précis des classements de référence que sont la classification internationale des maladies (CIM) et le manuel diagnostique et statistique des troubles mentaux (DSM).</br>
La compréhension des mécanismes en cause dans la, ou les, dyslexie(s), a beaucoup évolué grâce à l\'imagerie cérébrale qui a mis en évidence des corrélations avec l\'utilisation de différentes aires cérébrales à la lecture, notamment moindres que celles impliquées dans le langage, mais aussi accrue d\'autres aires.</br>
Enfin, la prise en charge peut prendre différents aspects en fonction de la spécificité de chaque cas qui doit être évalué par un bilan pluridisciplinaire. Les solutions ensuite proposées à ces troubles de l\'apprentissage de la lecture doivent être adaptées à chaque cas particulier, donc la prise en charge ne se limite pas à la définition exclusive d\'« une organisation cérébrale différente » comme elle est établie par l’association dyslexie suisse romande qui précise « qui existe donc « dès la naissance » ».';
$string['wikipedia_title'] = 'Article de Wikipédia';
$string['wikipedia_url'] = 'https://fr.wikipedia.org/wiki/Dyslexie';
