<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'de', version '4.1'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['addedandupdatedpp'] = '{$a->%new} neue H5P-Bibliotheken hinzugefügt und {$a->%old} vorhandene aktualisiert.';
$string['addedandupdatedps'] = '{$a->%new} neue H5P-Bibliotheken hinzugefügt und {$a->%old} vorhandene aktualisiert.';
$string['addedandupdatedsp'] = '{$a->%new} neue H5P-Bibliothek hinzugefügt und {$a->%old} vorhandene aktualisiert.';
$string['addedandupdatedss'] = '{$a->%new} neue H5P-Bibliothek hinzugefügt und  {$a->%old} vorhandene aktualisiert.';
$string['addednewlibraries'] = '{$a->%new} neue H5P-Bibliotheken hinzugefügt.';
$string['addednewlibrary'] = '{$a->%new} neue H5P-Bibliothek hinzugefügt.';
$string['additionalinfo'] = 'Weitere Informationen';
$string['additionallicenseinfo'] = 'Zusätzliche Informationen zur Lizenz';
$string['addlibraries'] = 'Bibliotheken hinzufügen';
$string['ajaxfailed'] = 'Fehler beim Laden der Daten';
$string['anunexpectedsave'] = 'Fehler: Dieser Inhalt wurde nicht gespeichert.';
$string['attribution'] = 'Namensnennung 4.0';
$string['attributionnc'] = 'Namensnennung - nicht kommerziell 4.0';
$string['attributionncnd'] = 'Namensnennung - nicht kommerziell - keine Bearbeitung 4.0';
$string['attributionncsa'] = 'Namensnennung - nicht kommerziell - Weitergabe unter gleichen Bedingungen 4.0';
$string['attributionnd'] = 'Namensnennung - keine Bearbeitung 4.0';
$string['attributionsa'] = 'Namensnennung - Weitergabe unter gleichen Bedingungen 4.0';
$string['author'] = 'Autor/in';
$string['authorcomments'] = 'Anmerkungen des Autors';
$string['authorcommentsdescription'] = 'Hier können Kommentare für weitere Bearbeiter hinterlassen werden. (Dieser Text wird nicht als Teil der Urheberrechtsangaben angezeigt.)';
$string['authorname'] = 'Name des Autors';
$string['authorrole'] = 'Rolle des Autors';
$string['by'] = 'von';
$string['cancellabel'] = 'Abbrechen';
$string['ccattribution'] = 'Namensnennung (CC BY)';
$string['ccattributionnc'] = 'Namensnennung-Nicht kommerziell (CC BY-NC)';
$string['ccattributionncnd'] = 'Namensnennung - Nicht-kommerziell - Keine Bearbeitung (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Namensnennung-Keine Bearbeitung (CC BY-ND)';
$string['ccattributionsa'] = 'Namensnennung - Weitergabe unter gleichen Bedingungen (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['ccpdm'] = 'Public Domain Mark (gemeinfrei, PDM)';
$string['changedby'] = 'Geändert von';
$string['changedescription'] = 'Beschreibung der Änderung';
$string['changelog'] = 'Änderungsprotokoll';
$string['changeplaceholder'] = 'Bild beschnitten, Text verändert usw.';
$string['close'] = 'Schließen';
$string['confirmdialogbody'] = 'Fortfahren? Dieser Vorgang kann nicht rückgängig gemacht werden.';
$string['confirmdialogheader'] = 'Aktion bestätigen';
$string['confirmlabel'] = 'Bestätigen';
$string['connectionlost'] = 'Verbindung abgebrochen. Die Ergebnisse werden zwischengespeichert und übermittelt, sobald die Verbindung wiederhergestellt wurde.';
$string['connectionreestablished'] = 'Verbindung wiederhergestellt';
$string['contentchanged'] = 'Dieser Inhalt wurde seit Ihrer letzten Nutzung geändert.';
$string['contentcopied'] = 'Inhalt in die Zwischenablage kopiert';
$string['contentstatefrequency'] = 'Inhalte regelmäßig speichern';
$string['contentstatefrequency_help'] = 'Sekunden. Wie häufig soll der Arbeitsfortschritt automatisch gesichert werden? Erhöhen Sie die Zahl, wenn Sie Vorgänge mit vielen Ajax-Anfragen haben.';
$string['contenttype'] = 'Inhaltstyp';
$string['contenttypecacheheader'] = 'Inhaltstypen-Cache';
$string['copyright'] = 'Nutzungsbedingungen';
$string['copyrightinfo'] = 'Informationen zum Copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Informationen zum Urheberrecht für diesen Inhalt anzeigen';
$string['couldnotcopy'] = 'Die Datei konnte nicht kopiert werden.';
$string['couldnotparsejsonfromzip'] = 'Eine JSON-Datei im Paket liegt im falschen Format vor: %fileName';
$string['couldnotparsepostdata'] = 'Die POST-Daten der Anfrage sind im falschen Format.';
$string['couldnotreadfilefromzip'] = 'Eine Datei im Paket konnte nicht gelesen werden: %fileName';
$string['couldnotsave'] = 'Die Datei konnte nicht gespeichert werden.';
$string['create'] = 'Anlegen';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Inhaltstypen-Cache aktualisieren';
$string['ctcacheconnectionfailed'] = 'Mit dem H5P Hub kommunizieren fehlgeschlagen. Bitte versuchen Sie es später noch einmal.';
$string['ctcachedescription'] = 'Sicherzustellen, dass der Inhaltstyp-Cache aktualisiert ist, wird garantieren, dass Sie die neuesten Bibliotheken ansehen, herunterladen und verwenden können. Dies unterscheidet sich von der Aktualisierung der Bibliotheken selbst.';
$string['ctcachelastupdatelabel'] = 'Letzte Aktualisierung';
$string['ctcacheneverupdated'] = 'Nie';
$string['ctcachenolibraries'] = 'Keine Inhaltstypen wurden vom H5P Hub empfangen. Versuchen Sie es später noch einmal.';
$string['ctcachesuccess'] = 'Der Cache der Bibliotheken wurde erfolgreich aktualisiert!';
$string['ctcachetaskname'] = 'Inhaltstypen-Cache aktualisieren';
$string['currentpage'] = 'Seite $current von $total';
$string['dataviewreportlabel'] = 'Antworten ansehen';
$string['date'] = 'Datum';
$string['disablefileextensioncheck'] = 'Prüfung für Dateiendungen deaktivieren';
$string['disablefileextensioncheckwarning'] = 'Achtung! Sobald die Prüfung für Dateiendungen deaktiviert ist, könnte dies ein Sicherheitsproblem darstellen, weil damit z.B. das Hochladen von PHP-Dateien erlaubt wird. Auf diese Weise könnte Ihre Website mit bösartigem Code angegriffen werden. Stellen Sie sicher, dass Sie genau wissen, was Sie hochladen.';
$string['disablefullscreen'] = 'Vollbildschirm deaktivieren';
$string['disablehubconfirmationmsg'] = 'Möchten Sie den Hub wirklich aktivieren?';
$string['disablehubdescription'] = 'Es wird dringend empfohlen, diese Option zu aktivieren. Der H5P Hub bietet eine einfache Schnittstelle für neue Inhaltstypen und hält bestehende Inhaltstypen auf dem neuesten Stand. In Zukunft wird es auch einfacher sein, Inhalte zu teilen und wiederzuverwenden. Wenn diese Option deaktiviert ist, müssen Sie die Inhaltstypen über Datei-Upload-Formulare installieren und aktualisieren.';
$string['displayoptionalwaysshow'] = 'Immer anzeigen';
$string['displayoptionauthoroff'] = 'Gesteuert durch Autor/in, standardmäßig aus';
$string['displayoptionauthoron'] = 'Gesteuert durch Autor/in, standardmäßig an';
$string['displayoptiondownloadalways'] = 'Immer';
$string['displayoptiondownloadnever'] = 'Nie';
$string['displayoptiondownloadpermission'] = 'Nur wenn die Person die Berechtigung zum Export von H5P besitzt';
$string['displayoptionnevershow'] = 'Nie anzeigen';
$string['displayoptionpermissions'] = 'Nur anzeigen, wenn Nutzer/in das Recht zum H5P-Export hat.';
$string['displayoptionpermissionsembed'] = 'Nur anzeigen, wenn Nutzer/in das Recht zum Einbetten von H5P-Inhalten hat.';
$string['displayoptions'] = 'Anzeigeeinstellungen';
$string['download'] = 'Herunterladen';
$string['downloadfailed'] = 'Herunterladen der angeforderten Bibliothek fehlgeschlagen.';
$string['downloadtitle'] = 'Diesen Inhalt als H5P-Datei herunterladen.';
$string['editor'] = 'Editor';
$string['emailconfirmbody'] = 'Guten Tag {$a->username},

vielen Dank, dass Sie Ihree Antworten zu \'{$a->hvpname}\' im Kurs  \'{$a->coursename}\' übermittelt haben!

Diese Nachricht bestätigt, dass die Antworten gespeichert wurden.

Die H5P-Aktivität kann unter {$a->hvpurl} aufgerufen werden.';
$string['emailconfirmsmall'] = 'Danke, dass Sie Ihre Antworten zu \'{$a->hvpname}\' übermittelt haben!';
$string['emailconfirmsubject'] = 'Übermittlungsbestätigung: {$a->hvpname}';
$string['emailnotifybody'] = 'Guten Tag {$a->username},

{$a->studentname} hat die Aktivität \'{$a->hvpname}\' ({$a->hvpurl}) im Kurs \'{$a->coursename}\' abgeschlossen.
Sie können den Versuch unter {$a->hvpreporturl} ansehen.';
$string['emailnotifysmall'] = '{$a->studentname} hat {$a->hvpname} abgeschlossen. Mehr unter {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} hat {$a->hvpname} abgeschlossen';
$string['embed'] = 'Einbetten';
$string['embedloginfailed'] = 'Sie haben keine Berechechtigung um auf diesen Inhalt zuzugreifen. Loggen Sie sich mit einem berechtigten Account ein.';
$string['embedtitle'] = 'Einbett-Code für diesen Inhalt anzeigen';
$string['empty'] = 'Keine Ergebnisse verfügbar';
$string['enableabout'] = 'Taste \'Über H5P\'';
$string['enablecopyright'] = 'Taste Copyright';
$string['enabledlrscontenttypes'] = 'LRS-abhängige Inhaltstypen aktivieren';
$string['enabledlrscontenttypes_help'] = 'Diese Option legt fest, dass auch Inhaltstypen verwendet werden können, die von einem Learning Record Store (LRS) abhängig sind, um richtig zu funktionieren, wie z.B. der Inhaltstyp \'Questionnaire\'.';
$string['enabledownload'] = 'Taste Herunterladen';
$string['enableembed'] = 'Taste Einbetten';
$string['enableframe'] = 'Aktionsleiste und Rahmen anzeigen';
$string['enablehublabel'] = 'H5P Hub verwenden';
$string['enablejavascript'] = 'Sie müssen Javascript im Browser aktivieren!';
$string['enablesavecontentstate'] = 'Inhaltsstatus speichern';
$string['enablesavecontentstate_help'] = 'Der jeweilige Status für die interaktiven Inhalte wird für alle Nutzer/innen automatisch gesichert, so dass alle genau dort weitermachen können, wo sie aufgehört haben.';
$string['failedtodownloadh5p'] = 'Fehler beim Herunterladen des angeforderten H5P.';
$string['fileexceedsmaxsize'] = 'Eine der Dateien im Paket überschreitet die maximale Dateigröße. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Datei nicht auf dem Server gefunden. Überprüfen Sie die Datei-Upload-Einstellungen.';
$string['filenotimage'] = 'Die Datei ist kein Bild.';
$string['filetypenotallowed'] = 'Der Dateityp ist nicht erlaubt.';
$string['finished'] = 'Beendet';
$string['fullscreen'] = 'Vollbildschirm';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'H5P-Datei';
$string['h5ptitle'] = 'Besuchen Sie H5P.org, um weitere coole Möglichkeiten kennenzulernen.';
$string['hide'] = 'Verbergen';
$string['hideadvanced'] = 'Erweiterungen verbergen';
$string['hubcommunicationdisabled'] = 'Die H5P-Hub-Kommunikation wurde deaktiviert, weil eine oder mehrere H5P-Anforderungen fehlgeschlagen sind.';
$string['hubisdisabled'] = 'Der Hub ist deaktiviert. Sie können ihn in den H5P-Einstellungen wieder aktivieren.';
$string['hubisdisableduploadlibraries'] = 'Der H5P Hub wurde deaktiviert, bis dieses Problem behoben werden kann. Sie können immer noch Bibliotheken über die Seite "H5P-Bibliotheken" hochladen.';
$string['hubsettingsheader'] = 'Inhaltstypen';
$string['hvp:addinstance'] = 'Neue H5P-Aktivität hinzufügen';
$string['hvp:emailconfirmsubmission'] = 'Beim Absenden von Antworten eine Bestätigungsnachricht anzeigen';
$string['hvp:emailnotifysubmission'] = 'Eine Benachrichtigung erhalten, wenn eine Versuch abgesendet wird';
$string['hvp:getcachedassets'] = 'Notwendig zum Anzeigen von H5P-Aktivitäten';
$string['hvp:getembedcode'] = 'H5P-Code zum Einbetten anzeigen, wenn die Berechtigung freigegeben ist';
$string['hvp:getexport'] = 'H5P-Datei herunterladen, wenn die Berechtigung freigegeben ist';
$string['hvp:installrecommendedh5plibraries'] = 'Empfohlene H5P-Bibliotheken installieren';
$string['hvp:manage'] = 'Vorhandene H5P-Aktivititäten bearbeiten.';
$string['hvp:restrictlibraries'] = 'H5P-Bibliothek beschränken';
$string['hvp:savecontentuserdata'] = 'H5P-Nutzerdaten speichern';
$string['hvp:saveresults'] = 'H5P-Ergebnis speichern';
$string['hvp:updatelibraries'] = 'H5P-Bibliothek aktualisieren';
$string['hvp:userestrictedlibraries'] = 'Beschränkte H5P-Bibliotheken verwenden';
$string['hvp:view'] = 'H5P-Aktivitäten anzeigen und verwenden';
$string['hvp:viewallresults'] = 'Alle Ergebnisse für abgeschlossene H5P-Aktivitäten anzeigen';
$string['hvp:viewresults'] = 'Eigene Ergebnisse für abgeschlossene H5P-Aktivitäten anzeigen';
$string['installdenied'] = 'Sie haben keine Berechtigung, H5P-Inhaltstypen zu installieren. Wenden Sie sich an den Administrator.';
$string['installedlibraries'] = 'Installierte Bibliotheken';
$string['intro'] = 'Beschreibung';
$string['invalidaudioformat'] = 'Ungültiges Audioformate. Nur mp3 und wav sind erlaubt.';
$string['invalidcontentfolder'] = 'Ungültiges Verzeichnis';
$string['invalidcontenttype'] = 'Der gewählte Inhaltstyp ist ungültig';
$string['invalidfieldtype'] = 'Ungültiger Feldtyp';
$string['invalidfile'] = 'Die Datei \'{$a->%filename}\' ist nicht erlaubt. Nur Dateien mit den folgenden Dateiendungen sind möglich: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'H5P konnte nicht gepostet werden.';
$string['invalidimageformat'] = 'Ungültiges Bildformat (nur jpg, png oder gif)';
$string['invalidlanguagefile'] = 'Ungültige Sprachdatei {$a->%file} in der Bibliothek {$a->%library}';
$string['invalidlanguagefile2'] = 'Ungültige Sprachdatei {$a->%file} wurde in die Bibliothek {$a->%library} einbezogen.';
$string['invalidlibrary'] = 'Ungültige Bibliothek';
$string['invalidlibrarydata'] = 'Ungültige Daten für {$a->%property} in {$a->%library} bereitgestellt';
$string['invalidlibrarydataboolean'] = 'Ungültige Daten für {$a->%property} in {$a->%library} bereitgestellt. Wahrheitswert erwartet.';
$string['invalidlibraryname'] = 'Ungültiger Bibliotheksname: {$a->%name}';
$string['invalidlibrarynamed'] = 'Die H5P-Bibliothek \'{$a->%library}\', die für den Inhalt verwendet wird, ist ungültig.';
$string['invalidlibraryoption'] = 'Illegale Option {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Die Eigenschaft {$a->%property} in {$a->%library} kann nicht gelesen werden.';
$string['invalidmainjson'] = 'Eine gültige Hauptdatei h5p.json fehlt.';
$string['invalidmultiselectoption'] = 'Ungültige Auswahloption in der Mehrfachauswahl';
$string['invalidparameters'] = 'Ungültige Parameter';
$string['invalidselectoption'] = 'Ungültige Auswahloption in der Auswahl';
$string['invalidsemanticsjson'] = 'Ungültige Datei semantics.json wurde in die Bibliothek {$a->%name} einbezogen.';
$string['invalidsemanticstype'] = 'Interner H5P-Fehler: unbekannter Inhaltstyp \'{$a->@type}\' in der Semantik. Der Inhalt wird entfernt!';
$string['invalidstring'] = 'Bereitgestellter Text ist passt nicht zu regexp in der Semantik. (value: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Ungültiges Sicherheitstoken';
$string['invalidvideoformat'] = 'Ungültiges Videoformat (nur mp4 oder webm)';
$string['invalidxapiresult'] = 'Es wurden keine xAPI-Ergebnisse für die angegebene Inhalts- und Benutzer-ID-Kombination gefunden.';
$string['javascriptloading'] = 'Auf Javascript warten ...';
$string['libraries'] = 'H5P-Bibliotheken';
$string['librarydirectoryerror'] = 'Der Name des Bibliotheksverzeichnisses muss machineName oder machineName-majorVersion.minorVersion (von library.json) lauten. (Verzeichnis: {$a->%directoryName}, machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Aktionen';
$string['librarylistinstancedependencies'] = 'Instanzabhängigkeiten';
$string['librarylistinstances'] = 'Instanzen';
$string['librarylistlibrarydependencies'] = 'Bibliotheksabhängigkeiten';
$string['librarylistrestricted'] = 'Eingeschränkt';
$string['librarylisttitle'] = 'Name';
$string['librarynotselected'] = 'Sie müssen einen Inhaltstyp auswählen.';
$string['license'] = 'Lizenz';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licensee'] = 'Lizenzinhaber';
$string['licenseextras'] = 'Zusätzliche Lizenzangaben';
$string['licenseversion'] = 'License Version';
$string['loadingdata'] = 'Daten laden';
$string['lookforupdates'] = 'H5P-Aktualisierungen suchen';
$string['maximumgrade'] = 'Höchstbewertung';
$string['maximumgradeerror'] = 'Geben Sie eine gültige positive Ganzzahl als Höchstpunktzahl für die Aktivität an.';
$string['maxpostsizetoosmall'] = 'Ihr PHP max post size ist ziemlich klein. Mit Ihrem aktuellen Setup können Sie keine Dateien hochladen, die größer als {$a->%number} MB sind. Dies könnte ein Problem sein, wenn man versucht, H5Ps, Bilder und Videos hochzuladen. Bitte ziehen Sie es in Betracht, es auf mehr als 5MB zu erhöhen.';
$string['maxscore'] = 'Höchstwertung';
$string['maxuploadsizetoosmall'] = 'Ihr PHP max upload size ist ziemlich klein. Mit Ihrem aktuellen Setup können Sie keine Dateien hochladen, die größer als {$a->%number} MB sind. Dies könnte ein Problem sein, wenn man versucht, H5Ps, Bilder und Videos hochzuladen. Bitte ziehen Sie es in Betracht, es auf mehr als 5MB zu erhöhen.';
$string['messageprovider:confirmation'] = 'Bestätigung zu eigenen H5P-Abgaben';
$string['messageprovider:submission'] = 'Systemnachricht zu H5P-Abgaben';
$string['missingcontentfolder'] = 'Ein gültiges Verzeichnis fehlt';
$string['missingcontentuserdata'] = 'Fehler: Der Inhalt der Nutzerdaten konnte nicht gefunden werden';
$string['missingcoreversion'] = 'Das System kann die Komponente \'{$a->%component}\' nicht aus dem Paket installieren, weil dafür eine neuere Version des H5P-Plugins notwendig ist. Die Website arbeitet momentan mit der Version {$a->%current}, notwendig ist die Version {$a->%required} oder höher. Sie sollten es nach einer Aktuallisierung noch einmal versuchen.';
$string['missingdependency'] = 'Fehlende Abhängigkeit {$a->@dep} wird von {$a->@lib} benötigt.';
$string['missinglibrary'] = 'Benötigte Bibliothek {$a->@library} fehlt';
$string['missinglibraryfile'] = 'Die Datei \'{$a->%file}\' fehlt in der Bibliothek: \'{$a->%name}\'';
$string['missinglibraryjson'] = 'Die Datei library.json mit gültigem json-Format für die Bibliothek {$a->%name} konnte nicht gefunden werden';
$string['missinglibraryproperty'] = 'Die benötigte Eigenschaft {$a->%property} fehlt in {$a->%library}';
$string['missingmbstring'] = 'Die PHP Extension \'mbstring\' ist nicht geladen. Deswegen funktioniert H5P nicht richtig.';
$string['missingparameters'] = 'Fehlende Parameter';
$string['missinguploadpermissions'] = 'Hinweis: Die Bibliotheken mögen in der hochgeladenen Datei enthalten sein, aber Sie haben nicht die nötigen Rechte, um neue Bibliotheken hochzuladen. Bitte kontaktieren Sie dazu den Administrator.';
$string['modulename'] = 'Interaktiver Inhalt';
$string['modulename_help'] = 'Die H5P-Aktivität ermöglicht das Erstellen von interaktiven Inhalten wie interaktiven Videos, Fragebögen, Drag-and-Drop-Fragen, Multiple-Choice-Fragen, Präsentationen und vielem mehr.

Zusätzlich zu den Funktionen als Autorentool für Rich Content, ermöglicht H5P es, H5P-Dateien zu importieren und exportieren, um Inhalte effektiv zu teilen und wiederzuverwenden.

Nutzerinteraktionen und Punktzahlen werden mittels der xAPI verfolgt und sind über die Moodle-Bewertungen verfügbar.

Sie fügen interaktive H5P-Inhalte hinzu, indem Sie Inhalte mit dem integrierten Authoring-Tool erstellen oder H5P-Dateien hochladen, die auf anderen H5P-aktivierten Websites gefunden wurden.';
$string['modulenameplural'] = 'Interaktive Inhalte';
$string['nextpage'] = 'Nächste Seite';
$string['noanswersubmitted'] = 'Diese Person hat noch keine Antwort zur H5P-Aktivität gesendet.';
$string['nocontent'] = 'Die Datei content.json konnte nicht gefunden oder gelesen werden';
$string['nocontenttype'] = 'Es wurde kein Inhaltstyp festgelegt.';
$string['nocopyright'] = 'Für diesen Inhalt sind keine Informationen zum Urheberrecht verfügbar.';
$string['nodata'] = 'Es sind keine Daten vorhanden, die Ihren Kriterien entsprechen.';
$string['noextension'] = 'Die hochgeladene Datei ist kein gültiges H5P-Paket (keine Dateiendung h5p).';
$string['noh5ps'] = 'Für diesen Kurs ist kein interaktiver Inhalt verfügbar.';
$string['nojson'] = 'Die Hauptdatei h5p.json ist nicht gültig.';
$string['nombstringexteension'] = 'Die PHP-Erweiterung mbstring ist nicht geladen. Sie wird von H5P benötigt, damit es korrekt funktioniert.';
$string['noparameters'] = 'Keine Parameter';
$string['noparse'] = 'Die Hauptdatei h5p.json konnte nicht gelesen werden.';
$string['nopermissiontogettranslations'] = 'Sie haben keine Berechtigung zum Abrufen von Übersetzungen';
$string['nopermissiontorestrict'] = 'Sie haben nicht das Recht, Bibliotheken zu beschränken.';
$string['nopermissiontosavecontentuserdata'] = 'Sie haben nicht das Recht, Nutzerdaten für diesen Inhalt zu speichern.';
$string['nopermissiontosaveresult'] = 'Sie haben nicht das Recht, Ergebnisse für diesen Inhalt zu speichern.';
$string['nopermissiontoupgrade'] = 'Sie haben nicht das Recht, Bibliotheken zu aktualisieren.';
$string['nopermissiontouploadcontent'] = 'Sie sind nicht berechtigt, hier Inhalte hochzuladen.';
$string['nopermissiontouploadfiles'] = 'Sie sind nicht berechtigt, hier Dateien hochzuladen.';
$string['nopermissiontoviewcontenttypes'] = 'Sie sind nicht berechtigt, die Inhaltstypen anzuzeigen.';
$string['nopermissiontoviewresult'] = 'Sie haben nicht das Recht, Ergebnisse für diesen Inhalt anzuzeigen.';
$string['nosuchlibrary'] = 'Keine solche Bibliothek';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'Die hochgeladene Datei ist kein gültiges HTML5-Paket (die Datei kann nicht entpackt werden)';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution-NonCommercial';
$string['noversionattributionncnd'] = 'Attribution-NonCommercial-NoDerivs';
$string['noversionattributionncsa'] = 'Attribution-NonCommercial-ShareAlike';
$string['noversionattributionnd'] = 'Attribution-NoDerivs';
$string['noversionattributionsa'] = 'Attribution-ShareAlike';
$string['nowriteaccess'] = 'Ein Problem mit dem Server-Schreibzugriff wurde erkannt. Bitte stellen Sie sicher, dass Ihr Server in Ihren Datenordner schreiben kann.';
$string['noziparchive'] = 'Ihre PHP-Version unterstützt nicht ZipArchive.';
$string['offlinedialogbody'] = 'Es konnten keine Informationen über den Aufgabenfortschritt übermittelt werden. Bitte überprüfen Sie Ihre Internetverbindung!';
$string['offlinedialogheader'] = 'Die Verbindung zum Server wurde unterbrochen';
$string['offlinedialogretrybuttonlabel'] = 'Jetzt erneut versuchen';
$string['offlinedialogretrymessage'] = 'Neuer Versuch in :num...';
$string['offlinesuccessfulsubmit'] = 'Ergebnisse erfolgreich übermittelt';
$string['oldphpversion'] = 'Ihre PHP-Version ist veraltet. H5P verlangt Version 5.2 um korrekt zu funktionieren. Version 5.6 oder höher wird empfohlen.';
$string['olduploadoldcontent'] = 'Sie versuchen, den Inhalt einer älteren Version von H5P hochzuladen. Aktualisieren Sie den Inhalt auf dem Server, von dem er stammt, und versuchen Sie ihn erneut hochzuladen oder aktivieren Sie auf dem H5P Hub die automatische Serveraktualisierung.';
$string['onlyupdate'] = 'Nur vorhandene Bibliotheken aktualisieren';
$string['options'] = 'Optionen';
$string['originator'] = 'Urheber';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Eine Post-Nachricht ist erforderlich, um auf den angegebenen Endpunkt zuzugreifen';
$string['previouspage'] = 'Vorherige Seite';
$string['privacy:metadata:core_files'] = 'Die H5P-Aktivität speichert Dateien, die als Teil des H5P-Inhalts hochgeladen wurden.';
$string['privacy:metadata:core_grades'] = 'Die H5P Aktivität speichert Bewertungen von Personen, die den H5P-Inhalt beantwortet haben.';
$string['privacy:metadata:hvp_content_user_data'] = 'Der aktuelle Status eines Inhalts für eine Person. Dies wird verwendet, um Inhalt auf einen vorherigen Stand zurückzusetzen.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Nutzerdaten, die gespeichert wurden.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Datentyp-Identifikator.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Marker, der anzeigt, ob Daten gelöscht werden sollten, wenn sich der Inhalt ändert.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'Die ID des H5P-Inhalts, zu dem die Daten gehören.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'Die ID der Beziehung Inhalt <-> Nutzerdaten.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Marker, der anzeigt, ob Daten in den Inhalt vor-geladen werden sollten.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Unter-Inhalt von H5P, 0 wenn dies kein Unter-Inhalt ist.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'Die ID der Person, zu der die Daten gehören.';
$string['privacy:metadata:hvp_events'] = 'Verfolgt protokollierte H5P-Ereignisse.';
$string['privacy:metadata:hvp_events:content_id'] = 'Die Inhalts-ID, für die die Aktion ausgeführt wurde, 0, wenn neu oder kein Inhalt.';
$string['privacy:metadata:hvp_events:content_title'] = 'Titel des Inhalts.';
$string['privacy:metadata:hvp_events:created_at'] = 'Der Zeitpunkt, an dem das Ereignis erzeugt wurde.';
$string['privacy:metadata:hvp_events:id'] = 'Die eindeutige ID des Ereignisses.';
$string['privacy:metadata:hvp_events:library_name'] = 'Die Bibliothek, auf die sich das Ereignis ausgewirkt hat.';
$string['privacy:metadata:hvp_events:library_version'] = 'Die Version der Bibliothek, auf die sich das Ereignis ausgewirkt hat.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Der Untertyp des Ereignisses oder die Aktion des Ereignisses.';
$string['privacy:metadata:hvp_events:type'] = 'Der Ereignistyp.';
$string['privacy:metadata:hvp_events:user_id'] = 'Die ID der Person, die die Aktion durchgeführt hat.';
$string['privacy:metadata:hvp_xapi_results'] = 'Speichert xAPI-Ereignisse im H5P-Inhalt.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Zusätzliche Information, die von der H5P-Aktivität gesendet werden kann.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'Die ID des Inhalts zu dem das Ereignis ausgeführt wurde.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Das richtige Antwortmuster.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Die Beschreibung, Aufgabe oder Frage des Inhalts, zu dem die Aktion ausgeführt wurde.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Die eindeutige ID des xAPI-Ereignisses.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Der Typ der Interaktion.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Maximal mögliche Punktzahl für das Ereignis.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'Die ID des übergeordneten Elements des Inhalts, für den dieses Ereignis ausgeführt wurde. Null, wenn es kein übergeordnetes Element gibt.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Erzielte Punktzahl für das Ereignis.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Die Antwort, die die Person eingeschickt hat.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'Die ID der Person, die die Aktion durchgeführt hat.';
$string['question'] = 'Frage';
$string['removeoldlogentries'] = 'Alte H5P-Logdaten löschen';
$string['removeoldmobileauthentries'] = 'Alte H5P-Mobil-Auth-Einträge löschen';
$string['removetmpfiles'] = 'Alte H5P-Temporärdateien löschen';
$string['reportingquestionsremaininglabel'] = 'noch zu bewertende Fragen';
$string['reportingscaledscoredelimiter'] = ';';
$string['reportingscaledscorelabel'] = 'Notenbewertung:';
$string['reportingscoredelimiter'] = 'von';
$string['reportingscorelabel'] = 'Stand:';
$string['reportnotsupported'] = 'Nicht unterstützt';
$string['reportsubmitgradelabel'] = 'Bewertung absenden';
$string['resizescript'] = 'Fügen Sie dieses Skript auf Ihrer Webseite ein, wenn Sie eine dynamische Größe von dem eingebetteten Inhalt möchten:';
$string['resubmitscores'] = 'Versuche, gespeicherte Ergebnisse zu übermitteln.';
$string['reuse'] = 'Wiederverwenden';
$string['reusecontent'] = 'Inhalt wiederverwenden';
$string['reusedescription'] = 'Diesen Inhalt an einer anderen Stelle verwenden.';
$string['reveal'] = 'Aufdecken';
$string['reviseserversetupandretry'] = 'Wenn Sie Ihr Server-Setup überarbeitet haben, können Sie die H5P-Hub-Kommunikation in den H5P-Einstellungen wieder aktivieren.';
$string['score'] = 'Wertung';
$string['search'] = 'Suchen';
$string['sendusagestatistics'] = 'Nutzungsstatistik teilen';
$string['sendusagestatistics_help'] = 'Nutzungsstatistiken werden automatisch geteilt, um den Entwicklern die Verwendung von H5P zu zeigen und um mögliche Verbesserung zu erkennen. <a {$a}>Weitere Informationen</a>.';
$string['settings'] = 'H5P-Einstellungen';
$string['showadvanced'] = 'Erweitert anzeigen';
$string['showless'] = 'Weniger';
$string['showmore'] = 'Mehr';
$string['sitecouldnotberegistered'] = 'Site konnte nicht mit dem Hub registriert werden. Bitte wenden Sie sich an Ihren Administrator.';
$string['sitekey'] = 'Site-Schlüssel';
$string['sitekeydescription'] = 'Der Site-Schlüssel ist ein geheimer Schlüssel, der diese Seite mit dem Hub eindeutig identifiziert.';
$string['sitekeyregistered'] = 'Sie haben einen einzigartigen Schlüssel zur Verfügung gestellt, der Sie mit dem Hub identifiziert, wenn Sie neue Updates erhalten. Der Schlüssel steht für die Anzeige auf der Seite "H5P Einstellungen" zur Verfügung.';
$string['size'] = 'Größe';
$string['source'] = 'Quelle';
$string['sslnotenabled'] = 'Ihr Server hat SSL nicht aktiviert. SSL sollte aktiviert werden, um eine sichere Verbindung mit dem H5P-Hub zu gewährleisten.';
$string['startingover'] = 'Sie werden weitergeleitet.';
$string['sublevel'] = 'Unterlevel';
$string['successfullyregisteredwithhub'] = 'Ihre Seite wurde erfolgreich beim H5P Hub registriert.';
$string['thumbnail'] = 'Vorschaubild';
$string['title'] = 'Name';
$string['unabletocreatedir'] = 'Verzeichnis konnte nicht angelegt werden.';
$string['unabletogetfieldtype'] = 'Feldtyp konnte nicht ermittelt werden.';
$string['undisclosed'] = 'Unbestimmt';
$string['unpackedfilesexceedsmaxsize'] = 'Die Gesamtgröße der entpackten Dateien überschreitet die Maximalgröße (%used > %max)';
$string['updatedlibraries'] = '{$a->%old} H5P-Bibliotheken aktualisiert.';
$string['updatedlibrary'] = '{$a->%old} H5P-Bibliothek aktualisiert.';
$string['updatelibraries'] = 'Alle Bibliotheken aktualisieren';
$string['upgrade'] = 'H5P aktualisieren';
$string['upgradebuttonlabel'] = 'Aktualisieren';
$string['upgradedone'] = 'Sie haben erfolgreich {$a} Inhaltsinstanz(en) aktualisiert.';
$string['upgradeerror'] = 'Fehler bei der Parameterverarbeitung:';
$string['upgradeerrorcontent'] = 'Inhalt %id konnte nicht aktualisiert werden.';
$string['upgradeerrordata'] = 'Daten für die Bibliothek %lib konten nicht geladen werden.';
$string['upgradeerrormissinglibrary'] = 'Benötigte Bibliothek %lib fehlt.';
$string['upgradeerrornotsupported'] = 'Parameter enthalten %used, was nicht unterstützt wird.';
$string['upgradeerrorparamsbroken'] = 'Parameter sind beschädigt.';
$string['upgradeerrorscript'] = 'Aktualisierungsscript für %lib konnte nicht geladen werden.';
$string['upgradeerrortoohighversion'] = 'Parameter enthalten %used, obwohl nur %supported oder früher unterstützt werden.';
$string['upgradeheading'] = '{$a} Inhalt aktualiseren';
$string['upgradeinprogress'] = 'Aktualisierung auf %ver ...';
$string['upgradeinvalidtoken'] = 'Fehler: Ungültiges Sicherheitstoken!';
$string['upgradelibrarycontent'] = 'Bibliotheksinhalt aktualisieren';
$string['upgradelibrarymissing'] = 'Fehler: Ihre Bibliothek fehlt!';
$string['upgrademessage'] = 'Sie sind dabei, {$a} Inhaltsinstanz(en) zu aktualisieren. Wählen Sie eine Aktualisierungsversion.';
$string['upgradenoavailableupgrades'] = 'Keine Aktualisierung für diese Bibliothek verfügbar.';
$string['upgradenothingtodo'] = 'Keine Inhaltsinstanz zum Aktualisieren';
$string['upgradereturn'] = 'Zurück';
$string['upload'] = 'Hochladen';
$string['uploadlibraries'] = 'Bibliotheken hochladen';
$string['uploadsizelargerthanpostsize'] = 'Ihr PHP max upload size ist größer als Ihr max post size. Dies ist bekannt, Probleme in einigen Installationen verursachen.';
$string['user'] = 'Nutzer/in';
$string['validatingh5pfailed'] = 'Die Validierung des H5P-Pakets ist fehlgeschlagen.';
$string['validationfailed'] = 'Das angeforderte H5P war nicht gültig';
$string['viewreportlabel'] = 'Bericht';
$string['welcomecommunity'] = 'Wir hoffen, dass Sie H5P mögen und die wachsende Community unterstützen, indem Sie unsere <a href={$a->forums}>Foren</a> besuchen.';
$string['welcomecontactus'] = 'Falls Sie ein Feedback geben möchten, nehmen Sie <a {$a}>Kontakt mit uns</a> auf. Wir nehmen jedes Feedback sehr ernst und arbeiten daran, H5P jeden Tag besser zu machen!';
$string['welcomegettingstarted'] = 'Um mit H5P und Moodle einfach anzufangen, schauen Sie sich unser <a {$a->moodle_tutorial}>Tutorial</a> an schauen Sie sich <a {$a->example_content}>Beispielinhalte</a> als Anregungen auf H5P.org an.';
$string['welcomeheader'] = 'Willkommen in der Welt von H5P!';
$string['wrongversion'] = 'Die für diesen Inhalt verwendete Version der H5P-Bibliothek {$a->%machineName} ist ungültig. Der Inhalt benutzt {$a->%contentLibrary}, aber es sollte {$a->%semanticsLibrary} sein.';
$string['year'] = 'Jahr';
$string['years'] = 'Jahr(e)';
$string['yearsfrom'] = 'Jahre (von)';
$string['yearsto'] = 'Jahre (bis)';
