<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'de', version '4.1'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'Icon-Farbe für Administration';
$string['activityiconcoloradministrationsetting_desc'] = 'Die Icon-Hintergrundsfarbe für Aktivitäten vom Typ Administration';
$string['activityiconcolorassessmentsetting'] = 'Icon-Farbe für Beurteilung';
$string['activityiconcolorassessmentsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Beurteilung';
$string['activityiconcolorcollaborationsetting'] = 'Icon-Farbe für Kollaboration';
$string['activityiconcolorcollaborationsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Kollaboration';
$string['activityiconcolorcommunicationsetting'] = 'Icon-Farbe für Kommunikation';
$string['activityiconcolorcommunicationsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Kommunikation';
$string['activityiconcolorcontentsetting'] = 'Icon-Farbe für Inhalt';
$string['activityiconcolorcontentsetting_desc'] = 'Icon-Hintergrundsfarbe für Materialien vom Typ Inhalt';
$string['activityiconcolorinterfacesetting'] = 'Icon-Farbe für Interface';
$string['activityiconcolorinterfacesetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Interface';
$string['activityiconcolorsheading'] = 'Icon-Farben für Aktivitäten';
$string['activitynavigation'] = 'Aktivitätsnavigation';
$string['activitynavigationsetting'] = 'Elemente der Aktivitätsnavigation';
$string['activitynavigationsetting_desc'] = 'Mit dieser Option werden die Elemente zum Springen zur vorherigen und nächsten Aktivität oder Ressource sowie das Pulldown-Menü zum Springen zu einer bestimmten Aktivität oder Ressource angezeigt. UI-Elemente wie diese gab es bei Boost in Moodle Core bis 3.11, aber sie wurden in 4.0 entfernt. Mit Boost Union können Sie sie zurückholen.';
$string['additionalresourcesfileurlpersistent'] = 'URL (gleichbleibend)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (überarbeitet)';
$string['additionalresourcesheading'] = 'Zusätzliche Ressourcen';
$string['additionalresourceslistsetting'] = 'Liste von zusätzlichen Ressourcen';
$string['additionalresourceslistsetting_desc'] = 'Liste der Dateien, die in den Dateibereich "Zusätzliche Ressourcen" hochgeladen wurden. Die angegebenen URLs können Sie verwenden, um die Dateien in zusätzlichem HTML, in nutzerdefiniertem CSS oder in der Fußnote zu verlinken. Dies hilft überall dort, wo Sie Dateien verwenden möchten, aber keine Dateien hochladen können.';
$string['additionalresourcessetting'] = 'Zusätzliche Ressourcen';
$string['additionalresourcessetting_desc'] = 'Mit dieser Option können Sie zusätzliche Ressourcen zum Design hochladen. Der Vorteil der Dateien in diesem Dateibereich besteht darin, dass diese Dateien ausgeliefert werden, ohne dass jemand angemeldet ist. An dieser Stelle sollten Sie nur unkritische Dateien hinzufügen, auf die jeder ohne Anmeldung zugreifen darf. Sobald Sie mindestens eine Datei in diesen Dateibereich hochgeladen und die Einstellungen gespeichert haben, sehen Sie eine Liste mit URLs, die auf die jeweiligen Dateien verweisen.';
$string['backgroundimagesheading'] = 'Hintergrundbilder';
$string['backtotop'] = 'Nach oben';
$string['backtotopbuttonsetting'] = 'Taste "Nach oben"';
$string['backtotopbuttonsetting_desc'] = 'Mit dieser Option erscheint eine Taste "Nach oben" in der unteren rechten Ecke der Seite, sobald Nutzer/innen die Seite nach unten scrollen. Eine solche Taste gab es bereits für das Design Boost im Moodle-Core bis Moodle 3.11, sie wurde aber in 4.0 entfernt. Im Design Boost Union können Sie diese Taste zurückholen.';
$string['blocksgeneralheading'] = 'Allgemeine Blöcke';
$string['blockstab'] = 'Blöcke';
$string['boost_union:configure'] = 'Nicht-Administrator/innen können das Design konfigurieren.';
$string['boost_union:viewhintcourseselfenrol'] = 'Hinweis zur uneingeschränkten Selbsteinschreibung in einem sichtbaren Kurs anzeigen';
$string['boost_union:viewhintinhiddencourse'] = 'Hinweis in einem verborgenen Kurs anzeigen';
$string['bootstrapcolordangersetting'] = 'Bootstrap-Farbe für Gefahr';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap-Farbe für Gefahr';
$string['bootstrapcolorinfosetting'] = 'Bootstrap-Farbe für Info';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap-Farbe für Info';
$string['bootstrapcolorsheading'] = 'Bootstrap-Farben';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap-Farbe für Erfolg';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap-Farbe für Erfolg';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap-Farbe für Warnung';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap-Farbe für Warnung';
$string['bootstrapdangercolor'] = 'Farbe Gefahr';
$string['bootstrapdarkcolor'] = 'Farbe dunkel';
$string['bootstrapinfocolor'] = 'Farbe Info';
$string['bootstraplightcolor'] = 'Farbe hell';
$string['bootstrapnone'] = 'Keine Bootstrap-Farbe';
$string['bootstrapprimarycolor'] = 'Farbe Primär';
$string['bootstrapsecondarycolor'] = 'Farbe Sekundär';
$string['bootstrapsuccesscolor'] = 'Farbe Erfolg';
$string['bootstrapwarningcolor'] = 'Farbe Warnung';
$string['brandcolorsheading'] = 'Markenfarben';
$string['brandingtab'] = 'Markenmerkmale';
$string['cachedef_fontawesome'] = 'FontAwesome-Dateien (die in den Boost Union-Einstellungen hochgeladen werden)';
$string['choosereadme'] = 'Das Design "Boost Union" ist eine Erweiterung für das Design "Boost" und wird von  Moodle an Hochschulen e.V. bereitgestellt.';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Inhalt';
$string['configtitlefeel'] = 'Eindruck';
$string['configtitlefunctionality'] = 'Funktionalität';
$string['configtitlelook'] = 'Aussehen';
$string['coursecontentmaxwidthsetting'] = 'Maximale Breite der Kursinhalte';
$string['coursecontentmaxwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Inhaltsbreite von Moodle ohne manuelle SCSS-Änderungen überschreiben. Standardmäßig verwendet Moodle eine maximale Breite bei Kursinhalten von 830px. Sie können andere pixelbasierte Werte wie 1200px eingeben, aber Sie können auch einen prozentualen Wert wie 100% oder einen Wert für die Breite des Darstellungsbereichs wie 90vw eingeben.';
$string['courserelatedhintsheading'] = 'Kursbezogene Hinweise';
$string['coursestab'] = 'Kurse';
$string['customfontsfileurlpersistent'] = 'URL (gleichbleibend)';
$string['customfontsfileurlrevisioned'] = 'URL (überarbeitet)';
$string['customfontsheading'] = 'Nutzerdefinierte Schriftarten';
$string['customfontslistsetting'] = 'Liste von nutzerdefinierten Schriftarten';
$string['customfontslistsetting_desc'] = 'Liste der Schriftarten, die Sie in den Dateibereich "Nutzerdefinierte Schriftarten" hochgeladen haben. Die anzeigten CSS-Snippets können verwendet werden, um die Schriftarten zum nutzerdefinierten SCSS hinzuzufügen. Beachten Sie bitte, dass Sie sich um alle Parameter (font-format, font-family, font-style, font-weight) selber kümmern müssen. Boost Union ist noch nicht in der Lage ist, die Schriftdateien zu analysieren.';
$string['customfontssetting'] = 'Nutzerdefinierte Schriftarten';
$string['customfontssetting_desc'] = 'Mit dieser Option können Sie nutzerdefinierte Schriftarten zum Design hochladen. Der Vorteil von Schriftarten in diesem Dateibereich besteht darin, dass diese Schriftarten überall auf der Website verwendet werden können, ohne dass jemand angemeldet ist. Sobald Sie mindestens eine Schriftart in diesen Dateibereich hochgeladen und die Einstellungen gespeichert haben, wird eine Liste mit CSS-Snippets gezeigt, um die jeweilige Schriftart im nutzerdefinierten SCSS einzubinden.';
$string['emailbrandinghtmldemobody'] = '<p>E-Mail-Text beginnt hier.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu nicht sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>E-Mail-Text endet hier.</p>';
$string['emailbrandinghtmlheading'] = 'HTML-E-Mail-Vorschau';
$string['emailbrandinghtmlintro'] = 'Dies ist eine Vorschau einer HTML-E-Mail basierend auf den Branding-Präfixen und -Suffixen, die derzeit im Sprachpaket festgelegt sind.';
$string['emailbrandinghtmlnopreview'] = 'Bisher wurden die HTML-E-Mails innerhalb dieser Funktion nicht angepasst. E-Mails werden normal erstellt und versendet.';
$string['emailbrandinginstruction'] = 'Wie geht das?';
$string['emailbrandinginstruction0'] = 'Mit dieser Boost Union-Funktion können Sie das Branding auf alle E-Mails anwenden, die Moodle versendet.';
$string['emailbrandinginstructionli1'] = 'Gehen Sie zur <a href="{$a->url}" target="_blank">Seite mit den Sprachanpassungen</a>, um das Sprachpaket <em>{$a->lang}</em> zur Bearbeitung zu öffnen.';
$string['emailbrandinginstructionli2'] = 'Suchen und ändern Sie diese Zeichenfolgen im Paket <code>theme_boost_union language</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Dieses Snippet wird <em>am Anfang / vor dem Text</em> aller <em>HTML-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Dieses Snippet wird <em>am Ende / nach dem Body</em> aller <em>HTML-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Dieses Snippet wird <em>am Anfang / vor dem Hauptteil</em> aller <em>Klartext-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Dieses Snippet wird <em>am Ende / nach dem Hauptteil</em> aller <em>Klartext-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli3'] = 'Speichern Sie die Änderungen am Sprachpaket.';
$string['emailbrandinginstructionli4'] = 'Kommen Sie auf diese Seite zurück und sehen Sie sich die E-Mail-Vorschau unten an.';
$string['emailbrandingintroheading'] = 'Einführung';
$string['emailbrandingintronote'] = 'Beachten Sie bitte, dass diese erweiterte Funktion einige Workarounds verwendet, um E-Mail-Branding-Optionen bereitzustellen. Befolgen Sie die Anweisungen genau.';
$string['emailbrandingpitfalls'] = 'Tücken';
$string['emailbrandingpitfalls0'] = 'Bei der Verwendung dieser Funktion gibt es einige Tücken, die Sie beachten sollten:';
$string['emailbrandingpitfallsli1'] = 'Es ist zwingend erforderlich, dass Sie die Sprachpaketzeichenfolgen der <em>aktuellen Standardsprache</em> dieser Website ändern. Auch wenn Sie mehrere Sprachpakete installiert haben, wirken sich nur Änderungen in der Standardsprache aus.';
$string['emailbrandingpitfallsli2'] = 'Es ist nicht möglich, die Sprache des Empfängers zu respektieren. Daher sollten Sie in Ihren E-Mail-Branding-Snippets sprachunabhängige Begriffe verwenden.';
$string['emailbrandingpitfallsli3'] = 'Wenn Sie in Zukunft jemals die Standardsprache der Website ändern, müssen Sie die geänderten Sprachpaketzeichenfolgen in das neue Standardsprachpaket migrieren.';
$string['emailbrandingpitfallsli4'] = 'In Klartext-E-Mails wird nach dem Präfix automatisch ein Zeilenumbruch und eine Leerzeile und vor dem Suffix-Snippet automatisch eine Leerzeile eingefügt. Damit soll sichergestellt werden, dass Suffix und Präfix nicht direkt am E-Mail-Text hängen.';
$string['emailbrandingpitfallsli5'] = 'In HTML-E-Mails werden das Präfix und das Suffix direkt vor und über dem E-Mail-Body hinzugefügt. Dies soll sicherstellen, dass Sie problemlos mit HTML-Tags arbeiten können, Sie müssen jedoch alle Abstände um den Text herum selbst handhaben.';
$string['emailbrandingpitfallsli6'] = 'In HTML-E-Mails können Sie problemlos ein HTML-Tag im Präfix-Snippet öffnen und das Tag im Suffix-Snippet schließen. Denken Sie nur daran, gültiges HTML in der resultierenden E-Mail zu erstellen.';
$string['emailbrandingtab'] = 'E-Mail-Branding';
$string['emailbrandingtextdemobody'] = 'Der E-Mail-Text beginnt hier.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Der E-Mail-Text endet hier.';
$string['emailbrandingtextheading'] = 'Klartext-E-Mail-Vorschau';
$string['emailbrandingtextintro'] = 'Dies ist eine Vorschau auf eine Klartext-E-Mail, basierend auf den Branding-Präfixen und -Suffixen, die derzeit im Sprachpaket festgelegt sind.';
$string['emailbrandingtextnopreview'] = 'Bisher wurden die Klartext-E-Mails in diesem Feature nicht angepasst. E-Mails werden normal erstellt und versendet.';
$string['enableimprintsetting'] = 'Impressum aktivieren';
$string['error:infobannerdismissnonotdismissible'] = 'Das angegebene Infobanner ist nicht ausblendbar.';
$string['error:infobannerdismissnonotvalid'] = 'Die angegebene Infobanner-Nummer ist ungültig.';
$string['faviconheading'] = 'Favicon';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Hier können Sie ein nutzerdefiniertes Bild (im Format .ico- oder .png) hochladen, welches im Browser als Favicon Ihrer Moodle-Website angezeigt wird. Wenn kein nutzerdefiniertes Favicon hochgeladen ist, wird das standardmäßige Moodle-Favicon angezeigt.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'Neuere FontAwesome-Versionen werden verwendet, um ältere Symbolkennungen neueren zuzuordnen oder sogar einige Symbole zu entfernen. Wenn Sie auf der linken Seite ein solides Kartensymbol sehen, zeigt Ihre FontAwesome 6-Version die neu zugeordneten Symbole von FontAwesome 4 korrekt an.';
$string['fontawesomecheck-fa6free-fallback-title'] = 'FontAwesome 4 Fallback';
$string['fontawesomecheck-fa6free-filter-description'] = 'Da Sie das FontAwesome-Filter-Plugin installiert haben, sollten Sie sicher sein, dass der Filter auch die neuen FontAwesome 6-Symbole korrekt verarbeitet. Wenn Sie auf der linken Seite ein Benutzersymbol sehen, funktioniert der Filter ordnungsgemäß mit den Symbolen der FontAwesome 6-Version.';
$string['fontawesomecheck-fa6free-filter-title'] = 'FontAwesome-Filter';
$string['fontawesomecheck-fa6free-general-description'] = 'Wenn Sie auf der linken Seite ein Häkchen-Symbol sehen, funktioniert FontAwesome im Allgemeinen auf Ihrer Website.';
$string['fontawesomecheck-fa6free-general-title'] = 'Allgemeine Funktionalität';
$string['fontawesomecheck-fa6free-newstuff-description'] = 'Neuere FontAwesome-Versionen werden im Vergleich zum Iconset von FontAwesome 4 mit zusätzlichen Symbolen ausgeliefert. Wenn Sie auf der linken Seite ein Virensymbol sehen, zeigt Ihre FontAwesome 6-Version ordnungsgemäß neue Symbole an, die neu in FontAwesome 6 sind.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'FontAwesome 6 Symbole';
$string['fontawesomecheckssetting'] = 'FontAwesome-Prüfungen';
$string['fontawesomecheckssetting_desc'] = 'Hier können Sie visuell überprüfen, ob die FontAwesome-Dateien hochgeladen und ordnungsgemäß zur Moodle-Seite hinzugefügt wurden. Wenn eine der Prüfungen fehlschlägt, kontrollieren Sie bitte, ob alle obligatorischen Dateien korrekt hochgeladen wurden.';
$string['fontawesomefilessetting'] = 'FontAwesome-Dateien';
$string['fontawesomefilessetting_desc'] = 'Mit dieser Einstellung können Sie neuere FontAwesome-Dateien in Moodle hochladen. Sie müssen die FontAwesome-Dateien aufgrund von Lizenzbeschränkungen selbst hochladen. Gehen Sie einfach zu <a href="https://fontawesome.com"> fontawesome.com </a>, laden Sie das FontAwesome-Paket herunter und laden Sie die Dateien hier wieder hoch.';
$string['fontawesomefilesstructurenote'] = 'Beachten Sie bitte, dass die Dateien mit der richtigen Ordnerstruktur und mit den richtigen Dateinamen hochgeladen werden müssen. Erstellen Sie zuerst das Verzeichnisse <em>css</em> und <em>webfonts</em> in der Dateiauswahl, laden Sie dann die  Datei <em>fa-solid-900.woff2 </em> in das Verzeichnis <em>webfonts</em> und speichern Sie "Einstellungen". Danach wird eine Dateiliste angezeigt, in der Sie die richtigen Dateien identifizieren und in diese Verzeichnisse hochladen können.';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Dies ist eine zusätzliche CSS-Datei, die die Schriftart für FontAwesome-Branding-Symbole zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Dies ist die Haupt-CSS -Datei, die alle verfügbaren FontAwesome-Glyphen zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Dies ist eine zusätzliche CSS-Datei, die die Schriftart für reguläre Symbole zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Dies ist eine zusätzliche CSS-Datei, die die Schriftart für FontAwesome solide Symbole zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Dies ist die CSS-Datei, mit der sichergestellt wird, dass die Fontawesome-4-Symbole in Moodle weiterhin korrekt angezeigt werden.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Dies ist die Schriftart für FontAwesome-Branding-Symbole (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Dies ist die Schriftart für FontAwesome-Branding-Symbole (im WOFF2-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Dies ist die Schriftart für reguläre FontAwesome-Symbole (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Dies ist die Schriftart für reguläre FontAwesome-Symbole (im WOFF2-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Dies ist die Schriftart für solide FontAwesome-Symbole (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Dies ist die Schriftart für solide FontAwesome-Symbole (im WOFF2-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Dies ist die Schriftart für die FontAwesome-4-Kompatibilität (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Dies ist die Schriftart für die FontAwesome-4-Kompatibilität (im WOFF2-Format).';
$string['fontawesomelistmandatorymissing'] = 'Dies ist eine obligatorische Datei für FontAwesome, aber sie wurde nicht richtig hochgeladen. Korrigieren Sie bitte den Fehler.';
$string['fontawesomelistmandatoryuploaded'] = 'Dies ist eine obligatorische Datei für FontaWesome, um arbeitsfähig zu sein, und sie wurde ordnungsgemäß hochgeladen.';
$string['fontawesomelistnote'] = 'Beachten Sie bitte, dass beim Hochladen alle obligatorischen Dateien hochgeladen werden müssen. Andernfalls können die FontAwesome-Symbole auf der Moodle-Seite als beschädigt angezeigt werden. Um dies zu beheben, müssen Sie alle obligatorischen Dateien hochladen oder alle Dateien wieder entfernen.';
$string['fontawesomelistoptionalmissing'] = 'Dies ist eine optionale Datei, um den FontAwesome-Symbolsatz zu verbessern, aber sie wurde nicht hochgeladen. Das geht gut, solange sie nicht gebraucht wird.';
$string['fontawesomelistoptionaluploaded'] = 'Dies ist eine optionale Datei, um den FontAwesome-Symbolsatz zu verbessern. Die Datei wurde ordnungsgemäß hochgeladen.';
$string['fontawesomelistsetting'] = 'FontAwesome-Dateiliste';
$string['fontawesomelistsetting_desc'] = 'Dies ist die Liste der FontAwesome-Dateien, die Sie oben in FontAwesome-Dateibereich hochgeladen haben. Es sind alle FontAwesome-Dateien aufgeführt, die für die konfigurierte FontAwesome-Version gültig sind. Weitere Dateien werden ignoriert, Wenn sie hochgeladen wurden, ohne benötigt zu werden. Die FontAwesome-Dateien werden automatisch zu den Moodle-Seiten hinzugefügt und haben einen direkten Effekt, sobald Sie diese Einstellung speichern.';
$string['fontawesomeversionfa6free'] = 'Auf FontAwesome 6 Free aktualisieren';
$string['fontawesomeversionnone'] = 'FontAwesome 4 behalten (wie im Moodle Core bereitgestellt)';
$string['fontawesomeversionsetting'] = 'FontAwesome-Version';
$string['fontawesomeversionsetting_desc'] = 'Der Moodle Core stellt FontAwesome-4-Symbole bereit, aber FontAwesome hat sich weiterentwickelt. Wenn Sie neuere FontAwesome-Symbole verwenden möchten, können Sie dies hier einstellen. Wenn Sie eine andere Version als FontAwesome 4 auswählen, werden zusätzliche Optionen angezeigt, wo Sie neuere FontAwesome-Versionen hochladen können.';
$string['footertab'] = 'Fußbereich';
$string['footnoteheading'] = 'Fußbereich';
$string['footnotesetting'] = 'Fußzeile';
$string['footnotesetting_desc'] = 'Alles, was Sie in diesem Textbereich hinzufügen, wird in der Fußzeile am Ende einer Seite angezeigt. Dieser Text steht in der Fußzeile (nicht in der schwebenden Fußzeile) auf jeder Seite, die die Layouts "drawers", "columns2" oder "login" verwendet. Inhalte können das Urheberrecht, die Nutzungsbedingungen oder der Name Ihrer Organisation sein. <br/>Um die Fußnote wieder zu entfernen, leeren Sie einfach diesen Textbereich.';
$string['imprintcontentsetting'] = 'Impressum Inhalt';
$string['imprintcontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf der Impressumsseite angezeigt werden.';
$string['imprintdisabled'] = 'Das Impressum ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['imprintheading'] = 'Impressum';
$string['imprintlinkpositionboth'] = 'Fügen Sie der Fußnote und dem Fußzeilensymbol (Fragezeichen) einen Link zum Impressum hinzu';
$string['imprintlinkpositionfooter'] = 'Fügen Sie dem Fußzeilensymbol (Fragezeichen) einen Link zum Impressum hinzu';
$string['imprintlinkpositionfootnote'] = 'Fügen Sie der Fußnote einen Link zum Impressum hinzu';
$string['imprintlinkpositionnone'] = 'Link zur Impressum nicht automatisch anzeigen';
$string['imprintlinkpositionsetting'] = 'Impressum Linkposition';
$string['imprintlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie festlegen, ob der Moodle-Seite automatisch ein Link zum Impressum hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie von überall in Moodle manuell einen Link zu {$a->url} hinzufügen.';
$string['imprintpagetitledefault'] = 'Impressum';
$string['imprintpagetitlesetting'] = 'Impressum Überschrift';
$string['imprintpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Impressumsseite festlegen. Dieser Text wird auch als Linktext zur Impressumsseite verwendet, wenn Sie die "Impressum Linkposition" entsprechend konfigurieren.';
$string['infobannerbsclasssetting'] = 'Infobanner Nr. {$a->no} Bootstrap Class';
$string['infobannerbsclasssetting_desc'] = 'Mit dieser Einstellung können Sie den Bootstrap-Stil auswählen, mit dem Infobanner Nr. {$a->no} angezeigt werden soll. Wenn Sie die Option „Keine Bootstrap-Farbe“ wählen, wird das Infobanner ohne eine bestimmte Bootstrap-Farbe ausgegeben, was Ihnen die Freiheit gibt, das Banner im Texteditor selbst zu gestalten.';
$string['infobannerclose'] = 'Schließen';
$string['infobannercontentsetting'] = 'Infobanner Nr. {$a->no} Inhalt';
$string['infobannercontentsetting_desc'] = 'Tragen Sie hier die Informationen ein, die innerhalb des Infobanners Nr. {$a->no} angezeigt werden sollen.';
$string['infobannerdismissconfirm'] = 'Möchten Sie wirklich die Sichtbarkeit des Infobanners Nr. {$a->no} zurücksetzen und möchten Sie es allen Personen erneut anzeigen?';
$string['infobannerdismissfail'] = 'Das Zurücksetzen der Sichtbarkeit des Infobanners Nr. {$a->no} ist für mindestens eine Person fehlgeschlagen.';
$string['infobannerdismissiblesetting'] = 'Infobanner Nr. {$a->no} ausblendbar';
$string['infobannerdismissiblesetting_desc'] = 'Mit dieser Einstellung können Sie das Infobanner Nr. {$a->no} ausblendbar machen. Klickt eine Person auf die Taste X im Infobanner, wird das Banner für diese Person dauerhaft ausgeblendet. Die Sichtbarkeit wird nicht automatisch zurückgesetzt, auch wenn Sie den Inhalt des Infobanners ändern. Wenn Sie die Sichtbarkeit des Infobanners zurücksetzen möchten, klicken Sie unten auf die Taste "Sichtbarkeit zurücksetzen".';
$string['infobannerdismissreset'] = 'Sichtbarkeit für ausgeblendetes Infobanners zurücksetzen';
$string['infobannerdismissresetbutton'] = 'Sichtbarkeit für Infobanner Nr. {$a->no} zurücksetzen';
$string['infobannerdismisssuccess'] = 'Die Sichtbarkeit für Infobanner Nr. {$a->no} wurde zurückgesetzt.';
$string['infobannerenabledsetting'] = 'Infobanner Nr. {$a->no} aktivieren';
$string['infobannerenabledsetting_desc'] = 'Mit dieser Einstellung können Sie das Infobanner Nr. {$a->no} aktivieren.';
$string['infobannerendsetting'] = 'Infobanner Nr. {$a->no} Endzeit';
$string['infobannerendsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, bis wann Infobanner Nr. {$a->no} angezeigt werden soll. Die konfigurierte Zeit wird als Serverzeit interpretiert, nicht als Nutzerzeit.';
$string['infobannerheading'] = 'Infobanner Nr. {$a->no}';
$string['infobannermodeperpetual'] = 'Dauerhaft';
$string['infobannermodesetting'] = 'Infobanner Nr. {$a->no} Anzeigemodus';
$string['infobannermodesetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, ob Infobanner Nr. {$a->no} ein dauerhaft angezeigtes Banner oder ein zeitgesteuertes Banner soll. Für die Zeitsteuerung muss das Zeitintervall konfiguriert werden.';
$string['infobannermodetimebased'] = 'Zeitgesteuert';
$string['infobannerordersetting'] = 'Infobanner Nr. {$a->no} Reihenfolge';
$string['infobannerordersetting_desc'] = 'Mit dieser Einstellung legen Sie die Position für das Infobanner Nr. {$a->no} fest. Standardmäßig sind die Infobanner von oben nach unten angeordnet, wie Sie sie auf dieser Einstellungsseite hier sehen. Mit dieser Einstellung können Sie die Reihenfolge ändern. Wenn Sie mehreren Infobannern dieselbe Position zuweisen, werden diese erneut gemäß der Reihenfolge auf dieser Einstellungsseite geordnet.';
$string['infobannerpageloginpage'] = 'Anmeldeseite';
$string['infobannerpagessetting'] = 'Seitenlayouts zur Anzeige von Infobanner Nr. {$a->no} auf';
$string['infobannerpagessetting_desc'] = 'Mit dieser Einstellung können Sie die Seitenlayouts auswählen, auf denen Infobanner Nr. {$a->no} angezeigt werden soll.';
$string['infobannerstartsetting'] = 'Infobanner Nr. {$a->no} Startzeit';
$string['infobannerstartsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, ab wann Infobanner Nr. {$a->no} angezeigt werden soll. Die konfigurierte Zeit wird als Serverzeit interpretiert, nicht als Nutzerzeit.';
$string['infobannertab'] = 'Infobanner';
$string['javascriptdisabledhint'] = 'Hinweis zu JavaScript';
$string['javascriptdisabledhint_desc'] = 'Mit dieser Einstellung erscheint oben in Moodle ein Hinweis, wenn JavaScript nicht aktiviert ist. Dies ist besonders hilfreich, da einige Moodle-Funktionen ohne JavaScript nicht funktionieren.';
$string['javascriptdisabledhinttext'] = 'JavaScript ist in Ihrem Browser deaktiviert.<br />Viele Funktionen in Moodle können nicht verwendet werden oder scheinen fehlerhaft zu sein.<br />Aktivieren Sie bitte JavaScript, um Moodle in vollem Umfang nutzen zu können.';
$string['javascriptheading'] = 'JavaScript';
$string['layoutheading'] = 'Layout';
$string['loginbackgroundimage'] = 'Hintergrundbilder für die Anmeldeseite';
$string['loginbackgroundimage_desc'] = 'Bilder, die als Hintergrund auf der Anmeldeseite gezeigt werden. Jeweils eins der Bilder wird zufällig ausgewählt und als Hintergrund angezeigt, wenn Nutzer/innen die Anmeldeseite besuchen.';
$string['loginbackgroundimagesheading'] = 'Hintergrundbilder für die Anmeldeseite';
$string['loginbackgroundimagetextsetting'] = 'Text für Hintergrundbilder anzeigen';
$string['loginbackgroundimagetextsetting_desc'] = 'Mit dieser Option können Sie Text hinzufügen, z.B. einen Urheberrechtshinweis zum jeweils verwendeten Hintergrundbild. Dieser Text erscheint oben in der Fußzeile auf der Anmeldeseite. Aus Platzgründen wird der Text jedoch nur auf größeren Bildschirmen angezeigt.<br />
Jede Zeile besteht aus der Dateikennung (das ist der Dateiname), dem anzuzeigenden Text und der Textfarbe, getrennt durch ein Pipe-Zeichen |. Jede Deklaration muss in eine neue Zeile geschrieben werden. <br />
Beispiel:<br />
background-image-1.jpg|Copyright: CC0|dunkel<br />
Als Textfarbe können Sie die Werte "dunkel" oder "hell" verwenden.<br />
Sie können Texte für beliebig viele hochgeladene Hintergrundbilder deklarieren. Die Texte werden nur zum jeweiligen Bild hinzugefügt, dessen Dateiname mit der angegebenen Dateikennung übereinstimmt.';
$string['misctab'] = 'Verschiedenes';
$string['navigationheading'] = 'Navigation';
$string['navigationtab'] = 'Navigation';
$string['pagetab'] = 'Seite';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Designvorlagen';
$string['privacy:metadata'] = 'Das Design "Boost Union" speichert keine personenbezogenen Daten.';
$string['resourcescachecontrolnote'] = 'Beachten Sie bitte, dass die Dateien mit dem "Cache-Control-Header" an den Browser geliefert und dort im Cache gespeichert werden. Wenn Sie sicher sind, dass sich die Dateien nicht ändern, können Sie die gleichbleibenden URLs verwenden. Wenn Sie jedoch eine oder mehrere Dateien ändern und die Dateinamen beibehalten, sollten Sie lieber die überarbeiteten URLs verwenden. Zwar wird so jede Datei immer neu ausgeliefert, aber Sie verhindern veraltete Versionen im Browsercache.';
$string['resourcestab'] = 'Ressourcen';
$string['scrollspy'] = 'Scroll-Spion';
$string['scrollspysetting'] = 'Scroll-Spion';
$string['scrollspysetting_desc'] = 'Mit dieser Einstellung wird beim Ein- und Ausschalten des Bearbeitungsmodus die Bildlaufposition beibehalten, an der sich die Person beim Ausführen des Umschaltens befand.';
$string['scssheading'] = 'Raw SCSS';
$string['showhintcourseguestaccessgeneral'] = 'Sie betrachten diesen Kurs gerade als <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Um vollen Zugriff auf diesen Kurs zu erhalten, können Sie sich <a href="{$a->url}">selbst in diesen Kurs einschreiben</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis im Kopfbereich aktiviert, wenn Nutzer/innen einen Kurs über den Gastzugang betreten. Wenn der Kurs eine aktive Selbsteinschreibung anbietet, wird dem Gast außerdem ein Link zu dieser Einschreibemöglichkeit angezeigt.';
$string['showhintcoursehiddengeneral'] = 'Dieser Kurs ist zur Zeit <strong>verborgen</strong>. Solange der Kurs weiter verborgen ist, können ausschließlich eingeschriebene Trainer/innen darauf zugreifen.';
$string['showhintcoursehiddensetting'] = 'Hinweis in verborgenen Kursen anzeigen';
$string['showhintcoursehiddensetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis im Kursheader angezeigt, solange der Kurs verborgen ist. Dies erlaubt die Erkennung des Sichtbarkeitsstatuses eines Kurses auf einen Blick, ohne die Kurseinstellungen öffnen zu müssen.';
$string['showhintcoursehiddensettingslink'] = 'Sie können die Sichtbarkeit in den <a href="{$a->url}">Kurseinstellungen</a> ändern.';
$string['showhintcourseselfenrolfrom'] = 'Die Einschreibungsinstanz <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung ab {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'Die Einschreibungsinstanz <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung ab {$a->from} bis {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Wenn Sie nicht möchten, dass sich alle Nutzer/innen in diesen Kurs ungehindert einschreiben können, dann beschränken Sie bitte den Zugang in den Einstellungen zur Selbsteinschreibung.';
$string['showhintcourseselfenrolsetting'] = 'Hinweis wegen Selbsteinschreibung ohne Einschreibeschlüssel anzeigen';
$string['showhintcourseselfenrolsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, dass ein Hinweis im Kurskopf erscheint, wenn ein Kurs sichtbar ist und eine Selbsteinschreibung ohne Einschreibeschlüssel aktuell möglich ist.';
$string['showhintcourseselfenrolsince'] = 'Die Einschreibungsinstanz <strong>{$a->name}</strong> erlaubt aktuell eine unbeschränkte Selbsteinschreibung.';
$string['showhintcourseselfenrolsinceuntil'] = 'Die Einschreibungsinstanz <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung bis {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Dieser Kurs ist momentan sichtbar und eine <strong>Selbsteinschreibung ohne Einschreibeschlüssel</strong> ist aktuell möglich.';
$string['showhintcourseselfenrolstartfuture'] = 'Dieser Kurs ist momentan sichtbar und eine <strong>Selbsteinschreibung ohne Einschreibeschlüssel</strong> ist mit Startdatum konfiguriert.';
$string['showhintcourseselfenrolunlimited'] = 'Die Einschreibungsinstanz <strong>{$a->name}</strong> erlaubt auf Dauer eine unbeschränkte Selbsteinschreibung.';
$string['showhintcourseselfenroluntil'] = 'Die Einschreibungsinstanz <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung bis {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Hinweis bei Gastzugang anzeigen';
$string['showswitchedroleincoursesetting'] = 'Hinweis bei Rollenwechsel anzeigen';
$string['showswitchedroleincoursesetting_desc'] = 'Mit dieser Einstellung erscheint ein Hinweis in der Kurskopfzeile, wenn die Person die Rolle im Kurs gewechselt hat. Standardmäßig werden diese Informationen nur direkt neben dem Avatar im Benutzermenü angezeigt. Wenn Sie diese Option aktivieren, können Sie diese Informationen - zusammen mit einem Link zum Zurückschalten - auch innerhalb der Kursseite anzeigen.';
$string['staticpagestab'] = 'Statische Seiten';
$string['switchedroleto'] = 'Sie sehen den Kurs in der Rolle: <strong>{$a->role}</strong>.';
