<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'de', version '4.1'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'As-Dur';
$string['abminor'] = 'as-Moll';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Alt';
$string['altoclef'] = 'Alt-Schlüssel';
$string['anmajor'] = 'A-Dur';
$string['anminor'] = 'a-Moll';
$string['answerlbl'] = 'Antwort';
$string['asharpminor'] = 'Ais-Moll';
$string['aug10'] = 'übermäßige Dezim(e)';
$string['aug11'] = 'übermäßige Undezim(e)';
$string['aug12'] = 'übermäßige Duodezim(e)';
$string['aug13'] = 'übermäßige Tredezim(e)';
$string['aug2'] = 'übermäßige Sekund(e)';
$string['aug3'] = 'übermäßige Terz';
$string['aug4'] = 'übermäßige Quart(e)';
$string['aug5'] = 'übermäßige Quint(e)';
$string['aug6'] = 'übermäßige Sexte';
$string['aug6thgr'] = 'Übermäßiger Quintsextakkord';
$string['aug7'] = 'übermäßige Septim(e)';
$string['aug8'] = 'übermäßige Oktav(e)';
$string['aug9'] = 'übermäßige Non(e)';
$string['augmented'] = 'übermäßig';
$string['bass'] = 'Bass';
$string['bassclef'] = 'Bass-Schlüssel';
$string['bbmajor'] = 'B-Dur';
$string['bbminor'] = 'b-Moll';
$string['bnmajor'] = 'H-Dur';
$string['bnminor'] = 'h-Moll';
$string['cbmajor'] = 'Ces-Dur';
$string['chordquality'] = 'Akkordtyp';
$string['chordquality-random'] = 'Mögliche Akkordtypen';
$string['chordquality_write_questionastext'] = 'Eingabe: Akkordtyp';
$string['chordquality_write_questionastext_help'] = '<p>Geben Sie eine kommagetrennte Liste von Noten OHNE Leerzeichen ein. Verwenden Sie dafür folgende Schreibweise: </p><p>[Großbuchstabe][Vorzeichen
  ("n" = ohne Vorzeichen, "#" = Kreuz, "b" = b-Vorzeichen, "x" = Doppelkreuz, "bb" = Doppel-b-Vorzeichen)]4, ... </p>
 <p>Beispiel: <b>Antwort=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Eingabe: harmonische Funktion';
$string['chordquality_write_questionasui_help'] = '<p>Für die Noteneingabe auf das Notensystem klicken, nachdem rechts in der Toolbar ein Vorzeichen ausgewählt wurde. Um eine Note zu löschen, einfach noch einmal auf die Note klicken.</p>';
$string['chordroot'] = 'Grundton';
$string['clef'] = 'Notenschlüssel';
$string['clef-random'] = 'Mögliche Notenschlüssel';
$string['cnmajor'] = 'C-Dur';
$string['cnminor'] = 'c-Moll';
$string['considerregister'] = 'Stimmlage einbeziehen';
$string['considerregister_help'] = 'Gibt an, ob die Stimmlage der Note in die Abfrage einbezogen werden soll.';
$string['correctansweris'] = 'Die richtige Antwort lautet:';
$string['correctansweris_morethanone'] = 'Eine mögliche Antwort lautet:';
$string['csharpmajor'] = 'Cis-Dur';
$string['csharpminor'] = 'cis-Moll';
$string['dbmajor'] = 'Des-Dur';
$string['dim10'] = 'verminderte Dezim(e)';
$string['dim11'] = 'verminderte Undezim(e)';
$string['dim12'] = 'verminderte Duodezim(e)';
$string['dim13'] = 'verminderte Tredezim(e)';
$string['dim2'] = 'verminderte Sekund(e)';
$string['dim3'] = 'verminderte Terz';
$string['dim4'] = 'verminderte Quart(e)';
$string['dim5'] = 'verminderte Quint(e)';
$string['dim6'] = 'verminderte Sext(e)';
$string['dim7'] = 'verminderte Sept(ime)';
$string['dim8'] = 'verminderte Oktav(e)';
$string['dim9'] = 'verminderte Non(e)';
$string['diminished'] = 'vermindert';
$string['dirasc'] = 'Oberhalb der vorgegebenen Note';
$string['dirdesc'] = 'Unterhalb der vorgegebenen Note';
$string['direction'] = 'Richtung';
$string['displaykeysignature'] = 'Tonart anzeigen';
$string['dnmajor'] = 'D-Dur';
$string['dnminor'] = 'd-Moll';
$string['dsharpminor'] = 'dis-Moll';
$string['ebmajor'] = 'Es-Dur';
$string['ebminor'] = 'es-Moll';
$string['emptykeysignature'] = 'leere Tonartanzeige';
$string['enmajor'] = 'E-Dur';
$string['enminor'] = 'e-Moll';
$string['fnmajor'] = 'F-Dur';
$string['fnminor'] = 'f-Moll';
$string['fsharpmajor'] = 'Fis-Dur';
$string['fsharpminor'] = 'fis-Moll';
$string['gbmajor'] = 'Ges-Dur';
$string['givennoteelementgroup'] = 'vorgegebene Note';
$string['gnmajor'] = 'G-Dur';
$string['gnminor'] = 'g-Moll';
$string['grandstaff'] = 'Akkolade (Klavier)';
$string['gsharpminor'] = 'gis-Moll';
$string['harmonicfunction_write_questionastext'] = 'Eingabe: harmonische Funktion';
$string['harmonicfunction_write_questionastext_help'] = '<p>Geben Sie eine kommagetrennte Liste von Noten OHNE Leerzeichen ein. Verwenden Sie dafür folgende Schreibweise: </p><p>[Großbuchstabe][Vorzeichen
  ("n" = ohne Vorzeichen, "#" = Kreuz, "b" = b-Vorzeichen, "x" = Doppelkreuz, "bb" = Doppel-b-Vorzeichen)]4, ... </p>
 <p>Beispiel: <b>Antwort=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Eingabe: harmonische Funktion';
$string['harmonicfunction_write_questionasui_help'] = '<p>Für die Noteneingabe auf das Notensystem klicken, nachdem rechts in der Toolbar ein Vorzeichen ausgewählt wurde . Um eine Note zu löschen, einfach noch einmal auf die Note klicken.</p>';
$string['harmonicfunctiontype-random'] = 'mögliche harmonische Funktionen';
$string['hfidentifyresponsetypes'] = 'mögliche harmonische Funktionen als Folge';
$string['hftype_aug6th'] = 'übermäßige Sext(e)';
$string['hftype_diatonictriad'] = 'leitereigener Dreiklang';
$string['hftype_dom7th'] = 'Dominantseptakkord';
$string['hftype_extendeddom'] = 'Akkorderweiterungen (9, 11 oder 13)';
$string['hftype_leadingtone7thfullydim'] = 'Verminderter Septakkord';
$string['hftype_leadingtone7thhalfdim'] = 'Halbverminderter Septakkord';
$string['hftype_neapolitan'] = 'Neapolitaner';
$string['hftype_nondom7th'] = 'Septakkord (nicht-dominant)';
$string['hftype_secdom7th'] = 'Zwischendominante (Septakkord)';
$string['hftype_secdomtriad'] = 'Zwischendominante (Dreiklang)';
$string['includealterations'] = 'Vorzeichen einbeziehen';
$string['includealterations_help'] = 'Zeigt, ob Vorzeichen Teil der Frage sein müssen.';
$string['includestaticnote'] = 'Beinhaltet die vorgegebene Note';
$string['interval_write_questionastext'] = 'Eingabe: Intervall';
$string['interval_write_questionastext_help'] = '<p>Geben Sie folgende Note OHNE Leerzeichen ein. Verwenden Sie dafür folgende Schreibweise: </p><p>[Großbuchstabe][Vorzeichen
  ("n" = ohne Vorzeichen, "#" = Kreuz, "b" = b-Vorzeichen, "x" = Doppelkreuz, "bb" = Doppel-b-Vorzeichen)][Oktavraum (eine Zahl zwischen 1 und 6, nach dem Vorbild der der scientific pitch notation)]</p>
 <p>Beispiel: </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Eingabe: Intervall';
$string['interval_write_questionasui_help'] = '<p>Für die Noteneingabe auf das Notensystem klicken, nachdem rechts in der Toolbar ein Vorzeichen ausgewählt wurde . Um eine Note zu löschen, einfach noch einmal auf die Note klicken.</p>';
$string['javascriptrequired'] = 'Dieser Text soll durch eine grafische Bedienoberfläche ersetzt werden. Dazu muss im Browser Javascript zugelassen sein.';
$string['keyboard_input_questionasui'] = 'Eintrag über das Keyboard';
$string['keyboard_input_questionasui_help'] = '<p>Noteneingabe über die Klaviatur. Um eine Note zu löschen, einfach noch einmal auf die Note klicken.</p>';
$string['keymode'] = 'Taste';
$string['keysignature_write_questionastext'] = 'Eingabe: Tonart';
$string['keysignature_write_questionastext_help'] = '<p>Geben Sie eine kommagetrennte Liste von Vorzeichen (zwischen 1 und 7), OHNE Leerzeichen ein. Verwenden Sie dafür folgende Schreibweise: </p><p>[Großbuchstabe][Vorzeichen
  ("n" = ohne Vorzeichen, "#" = Kreuz, "b" = b-Vorzeichen, "x" = Doppelkreuz, "bb" = Doppel-b-Vorzeichen)][Oktavraum (eine Zahl zwischen 2 und 5, nach dem Vorbild der der scientific pitch notation)]</p>
 <p>Beispiel: <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Eingabe: Tonart';
$string['keysignature_write_questionasui_help'] = '<p>Für die Eingabe von Vorzeichen auf das Notensystem klicken, nachdem rechts in der Toolbar ein Vorzeichen ausgewählt wurde. Um ein Vorzeichen zu löschen einfach, noch einmal auf das Vorzeichen klicken.</p>';
$string['lbl_harmonicfunction'] = 'Harmonische Funktion';
$string['maj10'] = 'große Dezim(e)';
$string['maj13'] = 'große Tredezim(e)';
$string['maj2'] = 'große Sekund(e)';
$string['maj3'] = 'große Terz';
$string['maj6'] = 'große Sext(e)';
$string['maj7'] = 'große Sept(im)';
$string['maj9'] = 'große Non(e)';
$string['major'] = 'Dur';
$string['min10'] = 'kleine Dezim(e)';
$string['min13'] = 'kleine Tredezim(e)';
$string['min2'] = 'kleine Sekund(e)';
$string['min3'] = 'kleine Terz';
$string['min6'] = 'kleine Sext(e)';
$string['min7'] = 'kleine Sept(im)';
$string['min9'] = 'kleine Non(e)';
$string['minor'] = 'Moll';
$string['mode-random'] = 'mögliche Modi';
$string['musicqtype'] = 'Fragetyp Musiktheorie';
$string['musictheory_gradingstrategy'] = 'Bewertungsstrategie';
$string['musictheory_gradingstrategy_help'] = '<p>Die Bewertungsstrategie definiert wie die Frage bewertet wird.</p>
<p><b>Alles oder nichts</b>: Die Beantwortung wird mit der korrekten Antwort verglichen. Ist die Beantwortung richtig, erhält man die volle Punktezahl. Ist die Beantwortung falsch, erhält man 0 Punkte.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Bewertungsstrategie';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>Die Bewertungsstrategie definiert wie die Frage bewertet wird.</p>
<p><b>Alles oder nichts</b>: Die Beantwortung wird mit der korrekten Antwort verglichen. Ist die Beantwortung richtig, erhält man die volle Punktezahl. Ist die Beantwortung falsch, erhält man 0 Punkte.</p>
<p><b>Teilpunkte für jede richtige Note</b>: Eine Bewertungsstrategie, bei der die Punktezahl gleichmäßig auf die Töne aufgeteilt wird, die die Teilnehmer/innen eingeben müssen. Die Teilnehmer/innen erhalten so für jede korrekte Note eine Teilpunktezahl.';
$string['musictheory_intervalelementgroup'] = 'Intervall';
$string['musictheory_intervalelementgroup_help'] = 'Zeigt die Art des Intervalls';
$string['musictheory_intervalelementgroup_random'] = 'Mögliche Intervalle';
$string['nosectonic'] = '[Keine Sekundärtonika]';
$string['note_write_questionastext'] = 'Eingabe: Note/Ton';
$string['note_write_questionastext_help'] = '<p>Geben Sie folgende Note OHNE Leerzeichen ein. Verwenden Sie dafür folgende Schreibweise:</p>
<p>[Notenname, als Großbuchstabe][Versetzungszeichen
  ("n" = ohne Vorzeichen, "#" = Kreuz, "b" = b-Vorzeichen, "x" = Doppelkreuz, "bb" = Doppel-b-Vorzeichen)][Stimmlage (eine Zahl zwischen 1 und 6, nach dem Vorbild der musiktheoretischen Notationsweise)]</p>
 <p>Beispiele: </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Eingabe: Note/Ton';
$string['note_write_questionasui_help'] = '<p>Für die Noteneingabe auf das Notensystem klicken, nachdem rechts in der Toolbar ein Vorzeichen ausgewählt wurde . Um eine Note zu löschen einfach noch einmal auf die Note klicken.</p>';
$string['notea'] = 'A';
$string['noteb'] = 'H';
$string['notec'] = 'C';
$string['noted'] = 'D';
$string['notee'] = 'E';
$string['notef'] = 'F';
$string['noteg'] = 'G';
$string['notelbl'] = 'Note/Ton';
$string['per11'] = 'reine Undezim(e)';
$string['per12'] = 'reine Duodezim(e)';
$string['per4'] = 'reine Quart(e)';
$string['per5'] = 'reine Quint(e)';
$string['per8'] = 'reine Oktav(e)';
$string['perfect'] = 'rein';
$string['pluginname'] = 'Musiktheorie';
$string['pluginname_help'] = 'Dieser Fragetyp ermöglicht die Erstellung verschiedener Arten von Musik-Theorieübungen unter Verwendung einer grafischen Benutzeroberfläche.';
$string['pluginnameadding'] = 'Musiktheorie-Frage hinzufügen';
$string['pluginnameediting'] = 'Musiktheorie-Frage bearbeiten';
$string['pluginnamesummary'] = 'Ermöglicht die Erstellung verschiedener Arten von Musiktheorie-Aufgaben.';
$string['possiblescalesinresponse'] = 'Mögliche Tonleitern als Antwort';
$string['privacy:metadata'] = 'Das Plugin "Musiktheorie-Fragetyp" speichert keine personenbezogenen Daten.';
$string['qtype_chordquality-identify'] = 'Akkordtyp benennen';
$string['qtype_chordquality-identify-random'] = 'Akkordtyp benennen (zufällig)';
$string['qtype_chordquality-write'] = 'Akkordtyp aufschreiben';
$string['qtype_chordquality-write-random'] = 'Akkordtyp aufschreiben (zufällig)';
$string['qtype_harmonicfunction-identify'] = 'Harmonische Funktion benennen';
$string['qtype_harmonicfunction-identify-random'] = 'Harmonische Funktion benennen (zufällig)';
$string['qtype_harmonicfunction-write'] = 'Harmonische Funktion aufschreiben';
$string['qtype_harmonicfunction-write-random'] = 'Harmonische Funktion aufschreiben (zufällig)';
$string['qtype_interval-identify'] = 'Intervall benennen';
$string['qtype_interval-identify-random'] = 'Intervall benennen (zufällig)';
$string['qtype_interval-write'] = 'Intervall aufschreiben';
$string['qtype_interval-write-random'] = 'Intervall aufschreiben (zufällig)';
$string['qtype_keyboard-input'] = 'Eingabe über die Klaviatur';
$string['qtype_keysignature-identify'] = 'Tonart benennen';
$string['qtype_keysignature-identify-random'] = 'Tonart benennen (zufällig)';
$string['qtype_keysignature-write'] = 'Tonart aufschreiben';
$string['qtype_keysignature-write-random'] = 'Tonart aufschreiben (zufällig)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Alles oder nichts';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Alles oder nichts';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Alles oder nichts';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Alles oder nichts';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Alles oder nichts';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Alles oder nichts';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Teilpunkte für jede korrekte Note/jeden korrekten Ton';
$string['qtype_note-identify'] = 'Note/Ton erkennen';
$string['qtype_note-identify-random'] = 'Note/Ton erkennen (zufällig)';
$string['qtype_note-write'] = 'Note/Ton aufschreiben';
$string['qtype_note-write-random'] = 'Note/Ton aufschreiben (zufällig)';
$string['qtype_scale-identify'] = 'Tonleiter benennen';
$string['qtype_scale-identify-random'] = 'Tonleiter benennen (zufällig)';
$string['qtype_scale-write'] = 'Tonleiter aufschreiben';
$string['qtype_scale-write-random'] = 'Tonleiter aufschreiben (zufällig)';
$string['quality-random'] = 'mögliche Arten';
$string['qualityaug'] = 'übermäßig';
$string['qualitydim'] = 'vermindert';
$string['qualitymaj'] = 'groß';
$string['qualitymin'] = 'klein';
$string['qualityper'] = 'rein';
$string['questionoptions'] = 'Frageoptionen';
$string['questiontext'] = 'Fragetext';
$string['questiontext_chordquality_identify'] = 'Erkennen Sie den Grundton und die Art des folgenden Akkords';
$string['questiontext_chordquality_write'] = 'Notieren Sie den folgenden Akkord';
$string['questiontext_harmonicfunction_identify'] = 'Benennen Sie die folgende harmonische Funktion';
$string['questiontext_harmonicfunction_write'] = 'Geben Sie die folgende harmonische Funktion ein';
$string['questiontext_help'] = 'Dieses Feld ist nicht erforderlich. Wenn es leer gelassen wird, wird innerhalb der Aufgabe automatisch ein Fragetext angezeigt, der für den gegebenen Musikfragetyp geeignet ist. Wenn Sie einen Text in dieses Feld eingeben, ersetzt dieser den automatisch generierten Fragetext.';
$string['questiontext_interval_identify'] = 'Benennen Sie das folgende Intervall';
$string['questiontext_interval_write_above'] = 'Geben Sie das folgende Intervall <b>über</b> der gegebenen Note ein';
$string['questiontext_interval_write_below'] = 'Geben Sie das folgende Intervall <b>unter</b> der gegebenen Note ein';
$string['questiontext_keyboard_input'] = 'Geben Sie die folgende Note über die Klaviatur ein';
$string['questiontext_keysignature_identify_major'] = 'Bestimmen Sie die Dur-Tonart anhand der Vorzeichen';
$string['questiontext_keysignature_identify_minor'] = 'Bestimmen Sie die Moll-Tonart anhand der Vorzeichen';
$string['questiontext_keysignature_write'] = 'Geben Sie die folgende Tonart ein';
$string['questiontext_note_identify'] = 'Benennen Sie die folgende Note/den folgenden Ton';
$string['questiontext_note_write'] = 'Geben Sie die folgende Note/den folgenden Ton ein';
$string['questiontext_scale_identify'] = 'Benennen Sie die folgende Tonleiter';
$string['questiontext_scale_write'] = 'Schreiben Sie die folgende Tonleiter in aufsteigender Richtung auf';
$string['questiontext_scale_write_melodic'] = 'Schreiben Sie die folgende Tonleiter in aufsteigender und absteigender Richtung auf';
$string['rootposition'] = '[Grundton]';
$string['scale_write_questionastext'] = 'Eingabe: Tonleiter';
$string['scale_write_questionastext_help'] = '<p>Geben Sie eine kommagetrennte Liste von Noten ein, einschließlich des angegebenen Grundtons, OHNE Leerzeichen. Verwenden Sie folgende Syntax:</p>
<p>[Notenname, als Großbuchstabe][Versetzungszeichen ("n" = natürlich, "#" = Kreuz, "b" = b-Vorzeichen, "x" = Doppelkreuz "bb" = Doppel-b-Vorzeichen)][Stimmlage (eine Ziffer zwischen 2 und 6, in Anlehnung an die musiktheoretische Notationsweise)], ... </p>
<p>Beispiel: <b>Tonika=An4 Antwort=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Eingabe: Tonleiter';
$string['scale_write_questionasui_help'] = '<p>Für die Noteneingabe auf das Notensystem klicken, nachdem rechts in der Toolbar ein Vorzeichen ausgewählt wurde . Um eine Note zu löschen einfach noch einmal auf die Note klicken.</p>';
$string['scaletype'] = 'Art der Tonleiter';
$string['scaletype-random'] = 'mögliche Arten von Tonleitern';
$string['scaletype_harmonic'] = 'harmonisches Moll';
$string['scaletype_major'] = 'Dur';
$string['scaletype_melodic'] = 'melodisches Moll';
$string['scaletype_natural'] = 'natürliches/reines/äolisches Moll';
$string['selectakey'] = 'Tonart auswählen';
$string['selectanoption'] = 'auswählen';
$string['selectaquality'] = 'Eigenschaft auswählen';
$string['selectasize'] = 'Größe auswählen';
$string['size-random'] = 'Mögliche Größen';
$string['size10'] = 'Dezim(e)';
$string['size11'] = 'Undezim(e)';
$string['size12'] = 'Duodezim(e)';
$string['size13'] = 'Tredezim(e)';
$string['size2'] = 'Sekund(e)';
$string['size3'] = 'Terz';
$string['size4'] = 'Quart(e)';
$string['size5'] = 'Quint(e)';
$string['size6'] = 'Sext(e)';
$string['size7'] = 'Sept(im)';
$string['size8'] = 'Oktav(e)';
$string['size9'] = 'Non(e)';
$string['tenor'] = 'Tenor';
$string['tenorclef'] = 'Tenorschlüssel';
$string['tonic'] = 'Tonika';
$string['treble'] = 'Sopran';
$string['trebleclef'] = 'Violinschlüssel';
$string['updatemusicqtype'] = 'Aktualisierungsoptionen';
$string['validation_harmonicfunctionnotsupported'] = 'Diese harmonische Funktion wird nicht unterstützt oder ist falsch.';
$string['validation_harmonicfunctiontypenotselected'] = 'Der Funktionstyp für die angegebene harmonische Funktion muss ausgewählt werden.';
$string['validation_interval_novalidcombo'] = 'Die ausgewählten möglichen Eigenschaften und Größen ergeben nicht mindestens ein gültiges Intervall.';
$string['validation_intervaloutsidestaff'] = 'Die Stimmlage der gegebenen Note erzeugt ein Intervall, das nicht in das Notensystem im gegebenen Notenschlüssel passt.';
$string['validation_invalidchordquality'] = 'Diese Art von Akkord kann nicht über den vorgegebenen Grundton aufgebaut werden.';
$string['validation_invalidinterval_above'] = 'Dieses Intervall kann nicht über die vorgegebene Note geschrieben werden.';
$string['validation_invalidinterval_below'] = 'Dieses Intervall kann nicht unter die vorgegebene Note geschrieben werden.';
$string['validation_noteoutsidekeyboard'] = 'Diese Note liegt außerhalb des Tonumfangs der Klaviatur.';
$string['validation_noteoutsidestaff'] = 'Die Stimmlage der gegebenen Note passt nicht in das Notensystem, im gegebenen Notenschlüssel.';
$string['validation_possiblescaletypenotselected'] = 'Die Art der Tonleiter muss für diese Tonleiter ausgewählt sein.';
$string['validation_possiblescaletypesnotselected_random'] = 'Die in der Frage gelisteten möglichen Tonleitern müssen auch in der Antwort als mögliche Tonleitern wählbar sein.';
$string['validation_qualitymismatch'] = 'Die Kombination aus Größe und Art des Intervalls ist ungültig.';
$string['validation_samestaticandgivennote'] = 'Die vorgegebene Note und die Beantwortung können auf der Klaviatur nicht die gleiche Taste sein.';
$string['validation_scale_invalidtonic'] = 'Ungültiger Grundton für die angegebene Tonleiter.';
$string['validation_scaleoutsidestaff'] = 'Der angegebene Grundton resultiert in einer Tonleiter, welche im Notensystem nicht mehr angezeigt werden kann.';
$string['validationerror_chordquality_identify'] = 'Unvollständige Antwort. Der Buchstabe, das Vorzeichen und der Akkordtyp müssen ausgewählt werden.';
$string['validationerror_empty'] = 'Antwort fehlt.';
$string['validationerror_harmonicfunction_identify'] = 'Unvollständige Antwort. Alle Dropdown-Menüs müssen ausgewählt werden.';
$string['validationerror_incompletechordquality'] = 'Unvollständige Antwort. Anzahl der Noten/Töne in diesem Akkord.';
$string['validationerror_incompleteharmonicfunction'] = 'Unvollständige Antwort. Anzahl der Noten/Töne in dieser harmonischen Funktion';
$string['validationerror_interval_identify'] = 'Unvollständige Antwort. Sowohl die Art als auch die Größe muss ausgewählt werden.';
$string['validationerror_invalidsyntax'] = 'Die Syntax der Antwort ist ungültig.';
$string['validationerror_note_identify'] = 'Unvollständige Antwort. Der Buchstabe, das Vorzeichen und der Oktavraum müssen ausgewählt werden.';
$string['validationerror_note_identify_ltr_acc'] = 'Unvollständige Antwort. Der Buchstabe und das Vorzeichen müssen ausgewählt werden.';
$string['validationerror_note_identify_ltr_reg'] = 'Unvollständige Antwort. Der Buchstabe und der Oktavraum müssen ausgewählt werden.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Es wurden 2 Noten/Töne eingegeben. Nur eine Note/einen Ton eingeben.';
$string['validationerror_scale_identify'] = 'Unvollständige Antwort. Alle Dropdown-Menüs müssen ausgewählt werden.';
$string['validationerror_scale_incomplete'] = 'Unvollständige Antwort. Es werden insgesamt 8 Töne benötigt, inklusive des vorgegebenen Grundtons.';
$string['validationerror_scale_incomplete_melodic'] = 'Unvollständige Antwort. Es werden insgesamt 15 Töne benötigt, inklusive des vorgegebenen Grundtons.';
$string['validationerror_whitespace'] = 'Ungültige Syntax: entfernen Sie alle Leerzeichen.';
