<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'de', version '4.1'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aktionen';
$string['activityoresourceis'] = 'Die Aktivität oder das Material ist {$a}';
$string['addacondition'] = 'Eine Bedingung hinzufügen';
$string['addarule'] = 'Eine Regel hinzufügen';
$string['addinstructions'] = 'Fügen Sie weitere Informationen hinzu';
$string['additionalresources'] = 'Weitere Ressourcen';
$string['addoninstallationerror'] = 'Beim Add-on (local_xp) wurde ein Problem festgestellt, denn es scheint nicht richtig installiert zu sein. Ein Administrator sollte die Installation abschließen.';
$string['addonnotactivated'] = 'Das Plugin ist nicht aktiv.';
$string['addrulesformhelp'] = 'Die letzte Spalte definiert die Menge an Erfahrungspunkte, wenn die Kriterien erfüllt sind.';
$string['admindefaultrulesintro'] = 'Die folgenden Regeln werden in Kursen, in denen der Block hinzugefügt wird, als Standard verwendet.';
$string['admindefaultsettingsintro'] = 'Die folgenden Einstellungen werden als Standard verwendet, wenn der Block neu in einen Kurs eingefügt wird. Einige Einstellungen können gesperrt werden, in diesem Fall wird ihr Wert in allen Instanzen des Plugins strikt durchgesetzt.';
$string['admindefaultvisualsintro'] = 'Das folgende wird als Standard genutzt, wenn der Block neu in einen Kurs eingefügt wird.';
$string['anonymity'] = 'Anonymität';
$string['anonymity_help'] = 'Diese Einstellung gibt an, ob Teilnehmer/innen die Namen und Avatare anderer Teilnehmer/innen sehen können.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> Erfahrungspunkte werden verdient wenn:';
$string['basexp'] = 'Basis des Algorithmus';
$string['blockappearance'] = 'Block-Darstellung';
$string['blockappearancemovedtopluginsettings'] = 'Der Block Darstellungseinstellungen wurde in die Plugineinstellungen verschoben.';
$string['cachedef_filters'] = 'Level Filter';
$string['cachedef_ruleevent_eventslist'] = 'Liste einiger Ereignisse';
$string['cannotshowblockconfig'] = 'Normalerweise würden hier die Einstellungen angezeigt, aber Ihr Block konnte nicht gefunden werden. Um das Aussehen des Blocks zu ändern, gehen Sie zurück [here] ({$ a}) (oder wo Sie den Block eingefügt haben), aktivieren den Bearbeitungsmodus und folgen der "Konfigurieren" -Option im Dropdown-Menü des Blocks. Wenn Sie den Block nicht finden können, fügen Sie ihn erneut zu Ihrem Kurs hinzu.';
$string['cannotshowblockconfigsys'] = 'Normalerweise würden hier die Einstellungen angezeigt, aber Ihr Block konnte nicht gefunden werden. Er fehlt möglicherweise auf der [front page] ({$ a-> fp}) und dem [default dashboard] ({$ a-> mysys}) Ihrer Benutzer oder wird auf beiden angezeigt. Um die Einstellungen von hier aus zu bearbeiten, stellen Sie sicher, dass er nur in einem von beiden erscheint.';
$string['changelevelformhelp'] = 'Wenn Sie die Anzahl der Level ändern, werden die individuellen Levelabzeichen vorübergehend deaktiviert, um Level ohne Abzeichen zu verhindern. Wenn Sie die Levelanzahl ändern,  gehen Sie zu der Seite "Visuals" , um wieder die benutzerdefinierten Abzeichen zu aktivieren, sobald Sie dieses Formular gespeichert haben.';
$string['cheatguard'] = 'Schutz gegen Betrug';
$string['clicktoselectcm'] = 'Klicken Sie, um eine Aktivität oder ein Material auszuwählen';
$string['cmselector'] = 'Kursmodul-Auswahl';
$string['coefxp'] = 'Koeffizient des Algorithmus';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = 'Beschreibung';
$string['configdescription_help'] = 'Eine Kurzbeschreibung, die im Block unterhalb des Teilnehmerlevels angezeigt wird. Die Teilnehmer/innen haben die Möglichkeit, die Meldung wegzuklicken. In diesem Fall wird sie ihnen nicht mehr angezeigt.';
$string['configheader'] = 'Einstellungen';
$string['configrecentactivity'] = 'Neue Belohnungen anzeigen';
$string['configrecentactivity_help'] = 'Wenn diese Option aktiviert wurde, zeigt der Block eine kurze Liste der letzten Aktivitäten, bei denen die Teilnehmer/innen mit Punkten belohnt wurden.';
$string['configtitle'] = 'Titel';
$string['configtitle_help'] = 'Titel des Blocks';
$string['congratulationsyouleveledup'] = 'Herzlichen Glückwunsch!';
$string['coolthanks'] = 'Cool, Danke!';
$string['courselog'] = 'Kurslog';
$string['coursereport'] = 'Kursbericht';
$string['courserules'] = 'Kursregeln';
$string['courseselectedcolon'] = 'Ausgewählter Kurs:';
$string['coursesettings'] = 'Kurseinstellungen';
$string['coursevisuals'] = 'Levelabzeichen des Kurses';
$string['customizelevels'] = 'Level anpassen';
$string['dangerzone'] = 'Gefahrenzone';
$string['defaultlevels'] = 'Standardlevel';
$string['defaultrules'] = 'Standardregeln';
$string['defaultrulesformhelp'] = 'Dies sind die voreingestellten Regeln des Plugins. Sie vergeben automatisch Erfahrungspunkte und ignorieren redundante Events. Individuell festgelegte Regeln überschreiben diese Voreinstellungen.';
$string['defaultsettings'] = 'Standardeinstellungen';
$string['defaultvisuals'] = 'Standarddarstellung';
$string['deletecondition'] = 'Bedingung löschen';
$string['deleterule'] = 'Regel löschen';
$string['description'] = 'Beschreibung';
$string['difference'] = 'Diff.';
$string['discoverlevelupplus'] = 'Level Up XP+ entdecken';
$string['dismissnotice'] = 'Nachricht schließen';
$string['displayeveryone'] = 'Alle anzeigen';
$string['displaynneighbours'] = '{$a} Nachbarn anzeigen';
$string['displayoneneigbour'] = 'Einen Nachbarn anzeigen';
$string['displayparticipantsidentity'] = 'Identität der Teilnehmer anzeigen';
$string['displayrank'] = 'Rang anzeigen';
$string['displayrelativerank'] = 'Relativen Rang anzeigen';
$string['documentation'] = 'Dokumentation';
$string['editinstructions'] = 'Informationen bearbeiten';
$string['enablecheatguard'] = 'Schummelwächter aktivieren';
$string['enablecheatguard_help'] = 'Der Schummelwächster (Cheat Guard) ist ein einfacher, unaufwändiger Mechanismus, um zu verhindern, dass Teilnehmer/innen das System mit simplen Techniken missbrauchen, z.B. indem sie dieselbe Seite endlos auffrischen oder dieselbe Aktion immer und immer wieder wiederholen.

[more info](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Infoseite aktivieren';
$string['enableinfos_help'] = 'Wenn die Einstellung \'Nein\' gewählt ist, können Teilnehmer/innen die Info-Seite nicht sehen.';
$string['enableladder'] = 'Rangliste aktivieren';
$string['enableladder_help'] = 'Wenn die Einstellung \'Nein\' gewählt wird, können Teilnehmer/innen die Rangliste  nicht sehen.';
$string['enablelevelupnotif'] = 'Mitteilung für Levelsteigerung aktivieren';
$string['enablelevelupnotif_help'] = 'Wenn die Einstellung \'Ja\' gewählt wird, wird den Teilnehmer/innen ein Pop-up-Fenster angezeigt wenn sie ein neues Level erreicht haben.';
$string['enablelogging'] = 'Logging aktivieren';
$string['enablexpgain'] = 'Punktezuwachs aktivieren';
$string['enablexpgain_help'] = 'Wenn die Einstellung \'Nein\' gewählt wird, erwirbt in diesem Kurs niemand Erfahrungspunkte. Dies kann sinnvoll sein, wenn die erreichten Erfahrungspunkte eingefroren oder erst zu einem späteren Zeitpunkt aktiviert werden sollen.
Hinweis: Mithilfe der Berechtigung \'block/xp:earnxp\' kann dies u. U. genauer gesteuert werden.';
$string['entersearchterm'] = 'Suchbegriff eingeben';
$string['errorcontextcoursemismatchforwholesite'] = 'Die URL dieser <em> Level Up XP </em> Seite stimmt nicht mit der aktuellen Plugin-Konfiguration überein. Dort wird <em> Level up XP </em> als "Für die gesamte Seite" deklariert. Auf dieser Seite wurde jedoch erwartet, dass "Pro Kurs" verwendet wird. Bitte <a href="{$a-> nexturl} "> hier klicken </a>, um zur rechten Seite zu navigieren. Suchen Sie nach der Administratoreinstellung \'block_xp_context\', wenn Sie Ihre Konfiguration ändern möchten.';
$string['errorcontextcoursemismatchpercourse'] = 'Die URL dieser <em> Level Up XP </em> Seite stimmt nicht mit der aktuellen Plugin-Konfiguration überein. Dort wird <em> Level up XP </em> als "Pro Kurs" deklariert. Auf dieser Seite wird jedoch erwartet, dass "Für die gesamte Seite" verwendet wird. Es stammt höchstwahrscheinlich aus einem <em> Block </em>, der in einer anderen Konfiguration zum Dashboard oder zur Startseite hinzugefügt wurde. Sie sollten den Block entfernen und nur innerhalb einzelner Kurse verwenden.';
$string['errorformvalues'] = 'Prüfen Sie bitte die Formulareinträge.';
$string['errorlevelsincorrect'] = 'Die minimale Anzahl der Level ist 2.';
$string['errornotalllevelsbadgesprovided'] = 'Nicht für alle Level wurden Abzeichen bereitgestellt. Fehlend: {$a}';
$string['errorunknownevent'] = 'Fehler: unbekanntes Ereignis';
$string['errorunknownmodule'] = 'Fehler: unbekanntes Modul';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Der erforderlichen Punkte sind niedriger oder gleich zum vorherigen Level.';
$string['event_user_leveledup'] = 'Nutzer/in ist eine Stufe aufgestiegen';
$string['eventis'] = 'Das Ereignis ist {$a}';
$string['eventname'] = 'Eventbezeichnung';
$string['eventproperty'] = 'Eventeigenschaft';
$string['eventsrules'] = 'Eventregeln';
$string['eventsrules_help'] = 'Dieses Plugin nutzt Ereignisse, um den von den Teilnehmer/innen ausgeführten Aktionen Punkte zuzuweisen.
Sie können über die Eingabemaske Ihre eigenen Regeln hinzufügen und die Standardregeln ändern.

Wir empfehlen, auf der _Log_-Seite des Plugins zu überprüfen, welche Ereignisse ausgelöst werden, wenn Teilnehmer/innen Aktionen im Kurs ausführen.

Zusätzliche Informationen finden Sie hier:
- [How are experience points calculated?](https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Troubleshooting rules](https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Eventzeitpunkt';
$string['filtermodules'] = 'Filter Module';
$string['for1day'] = 'Für einen Tag';
$string['for1month'] = 'Für einen Monat';
$string['for1week'] = 'Für eine Woche';
$string['for3days'] = 'Für 3 Tage';
$string['forever'] = 'Immer';
$string['forthewholesite'] = 'Für die gesamte Website';
$string['give'] = 'geben';
$string['gotofullladder'] = 'Zur kompletten Rangliste';
$string['grid'] = 'Raster';
$string['hideparticipantsidentity'] = 'Identität der Teilnehmer/innen verbergen';
$string['hiderank'] = 'Rang verbergen';
$string['incourses'] = 'In Kursen';
$string['ineffective'] = 'Ineffektiv';
$string['infos'] = 'Information';
$string['instructions'] = 'Weitere Informationen';
$string['invalidxp'] = 'Ungültiger Punkte-Wert';
$string['keeplogs'] = 'Logdaten behalten';
$string['ladder'] = 'Rangliste';
$string['ladderadditionalcols'] = 'Zusätzliche Spalten';
$string['ladderadditionalcols_help'] = 'Diese Einstellung legt fest, welche zusätzlichen Spalten in der Übersicht angezeigt werden. Drücken Sie während des Klickens die STRG- oder CMD-Taste, um mehr als eine Spalte auszuwählen, oder um eine ausgewählte Spalte abzuwählen.';
$string['ladderempty'] = 'Die Rangliste ist zurzeit leer, versuchen Sie es später wieder!';
$string['level'] = 'Level';
$string['levelbadges'] = 'Levelabzeichen';
$string['levelbadgesformhelp'] = 'Benennen Sie die Dateien [level].[file extension], z.B.: 1.png, 2.jpg, etc... Die empfohlene Bildgröße beträgt 100x100.';
$string['levelcount'] = 'Levelstufen';
$string['leveldesc'] = 'Levelbeschreibung';
$string['leveldesc_help'] = 'Neben dem Level wird eine kurze Beschreibung dessen angezeigt. Sie können das Level auch auf spielerische Weise beschreiben, um den Teilnehmenden Anweisungen zu geben, wie sie darauf hinarbeiten können, das Level freizuschalten. (z. B. Nur die tapfersten Seelen sind dafür bekannt, dieses Level zu erreichen) usw. .';
$string['levelname'] = 'Level-Name';
$string['levelname_help'] = 'Ein Kurzname, der anstelle der Standardeinstellung _Level #1_, _Level #2_, etc. an einigen Stellen angezeigt wird. Wir empfehlen bei der Vergabe von Kurznamen, dies für alle Level zu tun, nicht nur für einige!';
$string['levels'] = 'Level';
$string['levelswillbereset'] = 'Achtung! Beim Speichern dieses Formulars werden alle Level für jeden neu berechnet.';
$string['levelup'] = 'Level Up!';
$string['levelupplus'] = 'Level up XP+';
$string['levelx'] = 'Level #{$a}';
$string['likenotice'] = '<strong>Gefällt Ihnen das Plugin?</strong> Dann nehmen Sie sich bitte einen Moment Zeit, um <a href="{$a->moodleorg}" target="_blank">es zu Ihren Favoriten</a> auf Moodle.org hinzuzufügen und es <a href="{$a->github}" target="_blank">auf GitHub mit einem Stern zu versehen</a>.';
$string['limitparticipants'] = 'Teilnehmer beschränken';
$string['limitparticipants_help'] = 'Diese Einstellung steuert, wer in der Rangliste angezeigt wird. Nachbarn sind die Teilnehmer/innen, die über und unter dem aktuellen Nutzer eingestuft sind. Die Einstellung \'Zeige zwei Nachbarn\' zeigt beispielsweise nur die beiden Teilnehmer/innen direkt über und unter der aktuellen Person in der Rangliste an.';
$string['list'] = 'Liste';
$string['logging'] = 'Log-Einträge';
$string['manually'] = 'Manuell';
$string['maxactionspertime'] = 'Max. Aktionen im Zeitrahmen';
$string['maxactionspertime_help'] = 'Die maximale Anzahl von Aktionen, die während des Zeitrahmens für Punkte gegeben werden. Jede nachfolgende Aktion wird ignoriert. Dies ist ausgeschaltet, wenn dieser Wert leer oder gleich Null ist.';
$string['movecondition'] = 'Bedingung verschieben';
$string['moverule'] = 'Regel verschieben';
$string['name'] = 'Name';
$string['navinfos'] = 'Info';
$string['navladder'] = 'Rangliste';
$string['navlevels'] = 'Level';
$string['navlevelssetup'] = 'Einstellungen';
$string['navlog'] = 'Log';
$string['navpoints'] = 'Punkte';
$string['navpromo'] = 'XP+';
$string['navreport'] = 'Bericht';
$string['navrules'] = 'Regeln';
$string['navsettings'] = 'Einstellungen';
$string['navvisuals'] = 'Abzeichen';
$string['nodescription'] = 'Keine Beschreibung';
$string['nologsrecordedyet'] = 'Es wurden bisher noch keine Logdaten aufgezeichnet.';
$string['noname'] = 'Kein Name';
$string['notesomesettingslocked'] = 'Beachten Sie, dass manche Einstellungen nicht bearbeitet werden können, wenn sie von einem Administrator gesperrt wurden.';
$string['occasionally'] = 'Manchmal';
$string['participant'] = 'Teilnehmer/in';
$string['participatetolevelup'] = 'Beteiligen Sie sich am Kurs, um Erfahrungspunkte zu sammeln und Ihr Level zu verbessern!';
$string['perpagecolon'] = 'Pro Seite:';
$string['pickaconditiontype'] = 'Wählen Sie eine Bedingungsart';
$string['pluginname'] = 'Level Up XP';
$string['pluginsoutofsync'] = '__Die Plugins sind nicht synchronisiert__

Das bedeutet, dass Sie _Level Up XP_ upgegradet haben aber nicht _Level Up XP+_. Obwohl wir unser Bestes tun, um Probleme zu vermeiden, könnten einige Funktionen nicht mehr richtig funktionieren, auch in _Level Up XP_ selbst nicht. Wir empfehlen Ihnen, ein Upgrade _Level Up XP+_ auf die neueste Version zu aktualisieren. [Read more]({$a->url})';
$string['pointsintimelinker'] = 'pro';
$string['pointsrequired'] = 'Erforderliche Punkte';
$string['privacy:metadata:log'] = 'Speichert ein Ereignisprotokoll';
$string['privacy:metadata:log:eventname'] = 'Name des Ereignisses';
$string['privacy:metadata:log:time'] = 'Das Datum, an dem es stattfindet';
$string['privacy:metadata:log:userid'] = 'Person, die die Punkte gewonnen hat';
$string['privacy:metadata:log:xp'] = 'Punkte, die für das Ereignis vergeben wurden';
$string['privacy:metadata:prefintro'] = 'Speichert, ob eine Person die Kurzbeschreibung ausgeblendet hat';
$string['privacy:metadata:prefladderpagesize'] = 'Die vom Nutzer/innen bevorzugte Anzeigengröße der Rangliste';
$string['privacy:metadata:preflevelup'] = 'Speichert, ob eine Person die Level Up-Benachrichtigung sehen soll';
$string['privacy:metadata:prefnotices'] = 'Speichert, ob eine Person die Support-Meldung geschlossen hat';
$string['privacy:metadata:prefseenpromo'] = 'Speichert, wann eine Person die Promo-Seite angesehen hat';
$string['privacy:metadata:xp'] = 'Speichert Punkte und Level der Nutzer/innen';
$string['privacy:metadata:xp:lvl'] = 'Level der Person';
$string['privacy:metadata:xp:userid'] = 'Person';
$string['privacy:metadata:xp:xp'] = 'Punkte der Person';
$string['privacy:path:addon'] = 'Add-on';
$string['privacy:path:level'] = 'Level';
$string['privacy:path:logs'] = 'Logs';
$string['progress'] = 'Fortschritt';
$string['progressbar'] = 'Fortschrittsbalken';
$string['promocheatguard'] = 'Dieser Schummelwächter (Cheat Guard) ist nicht dafür ausgelegt, lange Zeiträume abzudecken. Erwägen Sie ein Upgrade auf <em>Level Up XP+</em>, um größere Zeiträume und andere Funktionen freizuschalten. <a href="{$a->url}">Erfahren Sie hier mehr</a>.';
$string['promocontactintro'] = 'Kontaktieren Sie uns für weitere Informationen. Wir beißen nicht und wir antworten schnell!';
$string['promocontactus'] = 'In Kontakt kommen';
$string['promoemailusat'] = 'Schreiben Sie uns eine E-Mail an _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Aua! Wir konnten die Nachricht nicht versenden... bitte senden Sie uns eine E-Mail direkt an: {$a}. Danke!';
$string['promoifpreferemailusat'] = 'Psst!, Wenn Sie es vorziehen, können Sie uns direkt eine E-Mail an _{$a}_ senden.';
$string['promointro'] = 'Werden Sie zum Spielleiter und entfesseln Sie das volle Potenzial von Level Up. Schalten Sie zusätzliche Funktionen mit Level Up XP+ frei!';
$string['promointroinstalled'] = 'Das Add-on _Level Up XP+_ ist auf Ihrem System installiert und alle Funktionen sind aktiviert.';
$string['promorulesdidyouknow'] = 'Wussten Sie, dass Teilnehmer/innen mit <em>Level Up XP+</em> Erfahrungspunkte für <em>Kurse abschließen</em> und <em>Aktivitäten abschließen</em> sammeln, oder sogar entsprechend ihrer <em>Bewertung</em> erhalten können? <a href="{$a->url}">Hier erfahren Sie mehr!</a>.';
$string['promoyourmessagewassent'] = 'Danke, Ihre Nachricht wurde versendet. Wir antworten Ihnen in Kürze.';
$string['property:action'] = 'Ereignis-Aktion';
$string['property:component'] = 'Ereignis-Komponente';
$string['property:crud'] = 'CRUD-Eigenschaft';
$string['property:eventname'] = 'Ereignis-Name';
$string['property:target'] = 'Ereignis-Aufgabe';
$string['rank'] = 'Rang';
$string['ranking'] = 'Einstufung';
$string['ranking_help'] = 'Der Rang ist die absolute Position des aktuellen Nutzers auf der Rangliste. Der relative Rang ist der Unterschied in Punkten zwischen dem Nutzer und seinen Nachbarn.';
$string['reallydeleteuserstate'] = 'Das Löschen von Nutzer/innen ist nur hilfreich, um sie aus der Rangliste zu entfernen. Haben Sie andere Gründe, empfehlen wir, die Punkte stattdessen auf 0 zu setzen. Beachten Sie, dass Nutzer/innen unabhängig von der Löschung zukünftig weiter in der Lage sind, Erfahrungspunkte zu sammeln.

Wenn Sie _Level Up XP_ für die gesamte Website verwenden, werden die gelöschten Nutzer/innen aus dem Bericht entfernt. In diesem Fall können Sie ihnen keine Punkte neu zuweisen. Wenn Sie jedoch _Level Up XP_ pro Kurs verwenden, werden die Teilnehmer/innen möglicherweise weiterhin im Bericht angezeigt, wenn sie für den Kurs eingeschrieben sind.

Möchten Sie die Punkte dieser Person wirklich löschen?';
$string['reallyresetallcoursestodefaults'] = 'Wirklich alle Kursregeln auf die Standardwerte zurücksetzen? Diese Aktion kann nicht rückgängig gemacht werden.';
$string['reallyresetcourserulestodefaults'] = 'Die Kursregeln wirklich auf die Standardwerte zurücksetzen? Diese Aktion kann nicht rückgängig gemacht werden.';
$string['reallyresetdata'] = 'Möchten Sie wirklich alle Level und die Punkte für alle Personen in diesem Kurs zurücksetzen?';
$string['reallyresetgroupdata'] = 'Möchten Sie wirklich alle Level und die Punkte für alle Personen in dieser Gruppe zurücksetzen?';
$string['reallyreverttopluginsdefaults'] = 'Wollen Sie die Standardregeln wirklich auf die vom Plugin vorgeschlagenen Standards zurücksetzen? Diese Aktion ist nicht umkehrbar.';
$string['recentrewards'] = 'Neue Belohnungen';
$string['releasenotes'] = 'Release Hinweise';
$string['reportisempty'] = 'Der Bericht enthält keine Daten. Die Teilnehmer/innen müssen erst Erfahrungspunkte sammeln.';
$string['reportisemptyenrolstudents'] = 'Der Bericht enthält keine Daten. Wurden in diesen Kurs bereits Teilnehmer/innen eingeschrieben?';
$string['requires'] = 'Benötigt';
$string['resetallcoursestodefaults'] = 'Alle Kurse auf Standardwerte zurücksetzen';
$string['resetallcoursestodefaultsintro'] = 'Klicken Sie auf die Schaltfläche unten, um alle Kurse auf die Standardwerte zurückzusetzen.';
$string['resetcoursedata'] = 'Kursdaten zurücksetzen';
$string['resetcourserulestodefaults'] = 'Kursregeln auf Standardwerte zurücksetzen';
$string['resetgroupdata'] = 'Gruppendaten zurücksetzen';
$string['reverttopluginsdefaults'] = 'Zurück zu den Standardeinstellungen des Plugins';
$string['reverttopluginsdefaultsintro'] = 'Benutzen Sie die Taste, wenn Sie auf die Standardeinstellungen des Plugins zurücksetzen wollen. Die Regeln in bestehenden Kursen sind davon nicht betroffen.';
$string['reward'] = 'Belohnung';
$string['rule'] = 'Regel';
$string['rule:contains'] = 'enthält';
$string['rule:eq'] = 'ist gleich';
$string['rule:eqs'] = 'ist genau gleich';
$string['rule:gt'] = 'ist größer als';
$string['rule:gte'] = 'ist größer oder gleich';
$string['rule:lt'] = 'ist kleiner als';
$string['rule:lte'] = 'ist kleiner oder gleich';
$string['rule:regex'] = 'entspricht dem Regex';
$string['rulecm'] = 'Aktivität oder Material';
$string['rulecm_help'] = 'Diese Bedingung ist erfüllt, wenn das Ereignis in der angegebenen Akktivität oder im Material auftritt.';
$string['rulecmdesc'] = 'Die Aktivität oder das Material ist \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Die Aktivität oder das Material ist: \'{$a->contextname}\' in \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Diese Bedingung erfordert, dass die Aktion in einer bestimmten Aktivität oder Ressource stattfindet.';
$string['ruleevent'] = 'Konkretes Ereignis';
$string['ruleeventdesc'] = 'Das Ereignis ist \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Wählen Sie die Aktion aus, die Nutzer/innen aus einer Liste von Ereignissen ausführen müssen.';
$string['ruleproperty'] = 'Ereignis-Eigenschaft';
$string['rulepropertydesc'] = 'Die Eigenschaft \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Diese Bedingung ist für Power-User mit einem technischen Verständnis der Ereignisse und ihrer Eigenschaften.';
$string['ruleset'] = 'Menge an Bedingungen';
$string['ruleset:all'] = 'ALLE Bedingungen sind erfüllt';
$string['ruleset:any'] = 'Mindestens EINE Bedingung ist erfüllt';
$string['ruleset:none'] = 'KEINE der Bedingungen ist erfüllt';
$string['rulesetinfo'] = 'Kombinieren Sie mehrere Bedingungen zu einer.';
$string['rulesformhelp'] = '<p>Dieses Plugin greift auf Events zurück, um den Teilnehmer/innen aufgrund ihrer Aktivitäten Erfahrungspunkte zuzuweisen. Im untenstehenden Formular sehen Sie voreingestellte Regeln und können eigene Regeln definieren. </p>
<p>Prüfen Sie die Plugin <a href="{$a->log}">Logdaten</a>, um festzustellen welche Events erfasst werden, wenn Aktivitäten für den Kurs festgelegt werden. Lesen Sie mehr über Events: <a href="{$a->list}">Liste aller Events</a>, <a href="{$a->doc}">Entwicklerdokumentation</a>.</p>
<p>Hinweis: Das Plugin ignoriert immer:
<ul>
<li>Aktionen, die Administrator/innen, Gäste oder nicht-eingeloggte Nutzer/innen ausführen.</li>
<li>Aktionen von Nutzer/innen, die nicht über die Berechtigung <em>block/xp:earnxp</em> verfügen.</li>
<li>In kurzen Zeitabständen wiederholte Aktionen, um Manipulationen zu verhindern.</li>
<li>und Events, die nicht mit aktiver Teilnahme in Verbindung stehen (the events of educational level not equal to <em>Participating</em>).</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Suchen und wählen Sie einen Kurs';
$string['searchandselectmodule'] = 'Suchen und wählen Sie eine Aktivität oder ein Material';
$string['send'] = 'Senden';
$string['setpoints'] = 'Punkte vergeben';
$string['shortcode:xpbadge'] = 'Die Auszeichnung entspricht dem aktuellen Nutzerlevel.';
$string['shortcode:xpiflevel'] = 'Inhalt anzeigen, wenn das Level der aktuellen Person passt.';
$string['shortcode:xpiflevel_help'] = 'Beziehen Sie sich auf die folgenden Beispiele, um den Shortcode zu formatieren. Wenn eine Stufe exakt definiert ist, wird der Inhalt unabhängig von den anderen Regeln angezeigt.
Damit der Inhalt angezeigt wird, müssen die Regeln _greater_ und _less than_ logisch übereinstimmen. Ansonsten kann es dazu kommen, dass der Inhalt nie angezeigt wird!
Beachten Sie, dass Trainer/innen oder andere Personen mit Bearbeitungsfunktionen immer alle Informationen einsehen können.

`` `
[xpiflevel 1 3 5]
  Anzeige, wenn die Stufe der Person genau 1, 3 oder 5 beträgt.
[/ xpiflevel]

[xpiflevel> 3]
    Anzeige, wenn die Stufe der Person größer als 3 ist.
[/ xpiflevel]

[xpiflevel> = 3]
    Anzeige, wenn die Stufe der Person größer oder gleich 3 ist.
[/ xpiflevel]

[xpiflevel> = 10 <20 30]
    Anzeige, wenn die Stufe der Person größer oder gleich 10 ist UND kleiner als 20 ODER ist genau gleich 30 ist.
[/ xpiflevel]

[xpiflevel <= 10> = 20]
    Wird nie angezeigt, da der Level der Person niemals kleiner oder gleich 10 UND mehr oder gleich 20 sein kann.
[/ xpiflevel]
`` `

Beachten Sie, dass die Shortcodes KEINE Verschachtelung erlauben.';
$string['shortcode:xpladder'] = 'Ausschnitt der Rangliste anzeigen';
$string['shortcode:xpladder_help'] = 'Laut Standardeinstellung wird dem Nutzer ein Ranglisten-Ausschnitt bezogen auf benachbarte Teilnehmer/innen angezeigt.

`` `
[xpladder]
`` `

Um die Top 10 anstelle der Ranglistennachbarn der aktuellen Person anzuzeigen, setzen Sie den Parameter `top`. Sie können optional die Anzahl der anzuzeigenden Person wie folgt festlegen: "top = 20".

`` `
[xpladder top]
[xpladder top = 15]
`` `

Ein Link zur vollständigen Rangliste wird automatisch unter der Tabelle angezeigt. Wenn Sie einen solchen Link nicht anzeigen möchten, fügen Sie das Argument "hidelink" hinzu.

`` `
[xpladder hidelink]
`` `

Standardmäßig ist der Bereich in dem der Fortschrittsbalken angezeigt wird, inaktiv. Wurde die Anzeige in den zusätzlichen Spalten in den Ranglisten-Einstellungen ausgewählt, können Sie den Balken mit dem Argument "withprogress" anzeigen.

`` `
[xpladder withprogress]
`` `

Beachten Sie, dass bei Verwendung von Gruppen in einem Kurs die Darstellung, für welche Gruppe die Rangliste angezeigt werden soll, nach dem Prinzip “best guess” programm basiert erfolgt.';
$string['shortcode:xplevelname'] = 'Levelnamen anzeigen';
$string['shortcode:xplevelname_help'] = 'In der Standardeinstellung zeigt der Tag den Namen der aktuellen Stufe einer Person.
Alternativ können Sie hier das Argument ’level’ verwenden um den Stufennamen anzuzeigen.

```
[xplevelname]
[xplevelname level=5]
```

Wenn das Argument `level` angegeben ist, ohne das die Stufe existiert, wird nichts angezeigt.';
$string['shortcode:xppoints'] = 'Anzahl von Punkten anzeigen, formatiert als Erfahrungspunkte';
$string['shortcode:xpprogressbar'] = 'Der Fortschrittsbalken der Person zeigt auf den nächsten Level.';
$string['someoneelse'] = 'Jemand anderes';
$string['somethinghappened'] = 'Etwas ist passiert';
$string['taskcollectionloggerpurge'] = 'Sammelprotokolle löschen';
$string['taskusagereport'] = 'Nutzungsbericht';
$string['thankyou'] = 'Vielen Dank!';
$string['timebetweensameactions'] = 'Erforderlicher Zeitabstand zwischen identischen Aktionen';
$string['timebetweensameactions_help'] = 'Die Mindestdauer in Sekunden, die zwischen zwei Aktionen liegen muß. Eine Aktion gilt als identisch wenn sie im gleichen Objekt und Kontext erfolgt. Beispiel: Das Lesen eines Forenbeitrags ist identisch mit dem wiederholten Lesen des gleichen Forenbeitrags. Wenn dieser Wert leer oder gleich Null ist, gilt er nicht.';
$string['timeformaxactions'] = 'Zeitrahmen für max. Aktionen';
$string['timeformaxactions_help'] = 'Zeitrahmen (in Sekunden) in den ein/e Nutzer/in eine bestimmte Anzahl von Aktionen nicht überschreiten darf';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'now';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}w';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Gesamt';
$string['unknowneventa'] = 'Unbekanntes Ereignis ({$a})';
$string['updateandpreview'] = 'Aktualisieren und Vorschau';
$string['upgradingplugins'] = 'Die Plugins aktualisieren';
$string['urlaccessdeprecated'] = 'Zugriff über diese URL ist abgelaufen, bitte aktualisieren Sie Ihre Links.';
$string['usagereport'] = 'Nutzungsbericht teilen';
$string['usagereport_desc'] = 'Geben Sie regelmäßig anonyme Nutzungsinformationen an die Plugin-Entwickler weiter. Diese Informationen helfen dabei, die Verwendung des Plugins zu verstehen, und beeinflussen seine Entwicklung. Die geteilten Informationen enthalten grundlegende Informationen über die Moodle-Website (URL, Version) und Nutzungsinformationen über das Plugin (Anzahl der Nutzer/innen, die Punkte sammeln, Übersicht der Einstellungen, verwendete Regeln, ...).';
$string['usealgo'] = 'Algorithmus benutzen';
$string['usecustomlevelbadges'] = 'Eigene Levelauszeichnungen benutzen';
$string['usecustomlevelbadges_help'] = 'Wenn \'Ja\' eingstellt wird, muß für jedes Level ein Bild hinterlegt werden.';
$string['usingalgo'] = 'Algorithmus verwenden';
$string['value'] = 'Wert';
$string['valuessaved'] = 'Die Werte wurden erfolgreich gespeichert.';
$string['viewas'] = 'Anzeigen als';
$string['viewtheladder'] = 'Rangliste anzeigen';
$string['visualsintro'] = 'Bilder hochladen, um die Darstellung der Level anzupassen.';
$string['wewillreplyat'] = 'Wir wiederholen um: _{$a}_.';
$string['when'] = 'Wann';
$string['wherearexpused'] = 'Wo werden die Punkte benutzt?';
$string['wherearexpused_desc'] = 'Bei Einstellung \'In Kursen\' gelten die gewonnenen Punkte nur für den Kurs, in dem der Block eingefügt wurde. Bei Einstellung \'Für die ganze Website\', steigt eine Person schneller im Rang auf als pro Kurs, da alle Erfahrung innerhalb der gesamten Website verwendet wird.';
$string['whoops'] = 'Hoppla!';
$string['xp'] = 'Erfahrungspunkte';
$string['xp:addinstance'] = 'Neuen Block \'XP\' hinzufügen';
$string['xp:earnxp'] = 'Punkte verdienen';
$string['xp:manage'] = 'Verwalten Sie alle Erfahrungspunkt-Aspekte';
$string['xp:myaddinstance'] = 'Block meinem Dashboard hinzufügen';
$string['xp:view'] = 'Block und seine verwandten Seiten anzeigen';
$string['xp:viewlogs'] = 'Logdaten anzeigen';
$string['xp:viewreport'] = 'Bericht anzeigen';
$string['xpgaindisabled'] = 'Punkte-Zuwachs deaktivieren';
$string['xprequired'] = 'Punkte notwendig';
$string['xptogo'] = '[[{$a}]] zum nächsten Level';
$string['youreachedlevel'] = 'Sie haben folgendes Level erreicht:';
$string['youreachedlevela'] = 'Sie haben Level {$a} erreicht!';
$string['yourmessage'] = 'Ihre Nachricht';
$string['yourownrules'] = 'Ihre eigenen Regeln';
