<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_opencast', language 'de', version '4.1'.
 *
 * @package     block_opencast
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesspolicies'] = 'Zugriffsrechte';
$string['acl_settingcontrol'] = 'Aktivieren der Sichtbarkeitskontrolle';
$string['acl_settingcontrol_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen die Sichtbarkeit einer Opencast-Episode beim Hochladen kontrollieren.';
$string['acl_settingcontrolafter'] = 'Sichtbarkeit von Episoden nach der Verarbeitung ändern';
$string['acl_settingcontrolafter_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Sichtbarkeit einer Opencast Episode nach der Verarbeitung der Episode ändern';
$string['acl_settingcontrolgroup'] = 'Beschränkung der Sichtbarkeit auf Gruppen erlauben';
$string['acl_settingcontrolgroup_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen nicht nur die Sichtbarkeit einer Opencast Episode für alle Teilnehmer/innen ändern, sondern die Sichtbarkeit auch auf Gruppen einschränken.';
$string['acl_settingcontrolwaitingtime'] = 'Wartezeit für geplante Sichtbarkeitsänderungen (in Minuten)';
$string['acl_settingcontrolwaitingtime_desc'] = 'Definiert eine Mindestwartezeit (in Minuten), die geplante Prozesse zur Sichtbarkeitsänderung warten. Diese Zeitspanne wird zur aktuellen Zeit für das geplante Videoänderungsdatum, das im Formular „Video hinzufügen“ hinterlegt ist, hinzuaddiert und wird auch verwendet, um dieses Feld zu validieren. Basierend darauf, wie schnell die Opencast-Instanz die Videos verarbeitet, kann diese Wartezeit konfiguriert werden. <br />HINWEIS: Wenn leer oder (Null) "0", wird der Standardwert verwendet.';
$string['acl_settingheader'] = 'Sichtbarkeit von Episoden ändern';
$string['aclgroupdeleted'] = 'Zugriff für das Video \'{$a->title}\' wurde eingeschränkt';
$string['aclnothingtobesaved'] = 'Es wurden keine Änderungen an der Sichtbarkeit vorgenommen.';
$string['aclownerrole'] = 'ACL Eigentümerrolle';
$string['aclownerrole_desc'] = 'Name der Rolle, die den Eigentümer eines Videos/einer Serie identifiziert. Die Rolle muss auch in der Rollentabelle angegeben werden. Die Rolle muss dauerhaft sein und einen benutzerbezogenen Platzhalter enthalten, z.B. ROLE_OWNER_[USER_EMAIL]. Es sollte keine kursbezogenen Platzhalter enthalten. Wenn leer, sind Eigentümer-bezogene Plugin-Funktionalitäten deaktiviert.';
$string['aclrolesadded'] = 'Die Sichtbarkeit wurde geändert, so dass Teilnehmer/innen dieses Kurses Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclrolesaddedgroup'] = 'Die Sichtbarkeit wurde geändert, so dass Teilnehmer/innen der gewählten Gruppe Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclroleschangeerror'] = 'Es ist ein Fehler während der Sichtbarkeitsänderung für folgendes Video aufgetreten: {$a->title}<br />Einige Änderungen wurden möglicherweise nicht gespeichert. Sollte das Problem wiederholt auftreten, wenden Sie an Ihren Support.';
$string['aclrolesdeleted'] = 'Die Sichtbarkeit wurde geändert, so dass keine Teilnehmer/innen mehr Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclrolesname'] = 'Rollen';
$string['aclrolesnamedesc'] = 'Der Platzhalter [COURSEID] kann im Rollennamen verwendet werden und wird automatisch ersetzt.';
$string['actions'] = 'kommagetrennte Liste von Aktionen';
$string['addactivity_addbuttonexplanation'] = 'Die Videos, die zu diesem Kurs hinzugefügt werden und in diesem Kurs verfügbar sind, werden Ihren Teilnehmer/innen nicht automatisch zur Verfügung gestellt.<br />Mit den Schaltflächen "Bereitstellen" können Sie Ihrem Kurs Aktivitäten hinzufügen, die Ihren Teilnehmer/innen entweder alle Videos in einer Serie oder einzelne Videos zur Verfügung stellen.';
$string['addactivity_addbuttontitle'] = 'Aktivität "Opencast Video Provider" zum Kurs hinzufügen';
$string['addactivity_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addactivity_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addactivity_defaulttitle'] = 'Opencast Videos';
$string['addactivity_formactivityavailability'] = 'Voraussetzungen der Opencast-Serien-Aktivität';
$string['addactivity_formactivityintro'] = 'Beschreibung der Opencast-Serien-Aktivität';
$string['addactivity_formactivitysection'] = 'Kursabschnitt der Opencast-Serien-Aktivität';
$string['addactivity_formactivitytitle'] = 'Titel der Opencast-Serien-Aktivität';
$string['addactivity_header'] = 'Videos zur Verfügung stellen (Aktivität)';
$string['addactivity_modulecreated'] = 'Die Serien-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addactivity_moduleexists'] = 'Es gibt bereits eine Opencast-Serien-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addactivity_modulenotcreated'] = 'Die Serien-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addactivity_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Serien-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addactivity_settingavailability'] = 'Voraussetzungen zur Serien-Aktivität';
$string['addactivity_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addactivity_settingavailability_note'] = 'Bitte beachten Sie: Diese Funktion steht nur zur Verfügung, wenn Voraussetzungen in Moodle auf der {$a} Einstellungsseite aktiviert sind.';
$string['addactivity_settingdefaulttitle'] = 'Standard-Titel der Serien-Aktivität.';
$string['addactivity_settingdefaulttitle_desc'] = 'Der standardmäßige Titel der Aktivität wird verwendet, wenn eine neue Opencast Serien-Aktivität angelegt wird.';
$string['addactivity_settingenabled'] = '"Serien-Aktivität hinzufügen" aktivieren';
$string['addactivity_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast Serien-Aktivität zum Kurs hinzufügen. Diese Serien-Aktivität wird die Opencast-Serie des Kurses anzeigen.';
$string['addactivity_settingheader'] = 'Opencast Serien-Aktivität zum Kurs hinzufügen';
$string['addactivity_settingintro'] = 'Beschreibung zur Serien-Aktivität';
$string['addactivity_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast Serien-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addactivity_settingsection'] = 'Kursabschnitt der Serien-Aktivität';
$string['addactivity_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast Serien-Aktivität hinzugefügt wird.';
$string['addactivity_viewbuttonexplanation'] = 'Eine Opencast-Serien-Aktivität, die alle verfügbaren Videos im Kurs anzeigt, wurde bereits hinzugefügt.';
$string['addactivity_viewbuttontitle'] = 'Opencast-Serien-Aktivität im Kurs anzeigen';
$string['addactivityepisode_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addactivityepisode_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addactivityepisode_addicontitle'] = 'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addactivityepisode_defaulttitle'] = 'Opencast Einzelvideo';
$string['addactivityepisode_explanation'] = 'Zusätzlich können Sie in der obenstehenden Tabelle Aktivitäten für Opencast Einzelvideos zu Ihrem Kurs hinzufügen um Ihren Teilnehmer/innen ein einzelnes Video bereitzustellen.';
$string['addactivityepisode_formactivityavailability'] = 'Voraussetzungen der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_formactivityintro'] = 'Beschreibung der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_formactivitysection'] = 'Kursabschnitt der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_formactivitytitle'] = 'Titel der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_modulecreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addactivityepisode_moduleexists'] = 'Es gibt bereits eine Opencast-Einzelvideo-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addactivityepisode_modulenotcreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addactivityepisode_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Einzelvideo-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addactivityepisode_settingavailability'] = 'Voraussetzungen zur Einzelvideo-Aktivität';
$string['addactivityepisode_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addactivityepisode_settingenabled'] = '"Einzelvideo-Aktivität hinzufügen" aktivieren';
$string['addactivityepisode_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast Einzelvideo-Aktivität zum Kurs hinzufügen. Diese Einzelvideo-Aktivität wird eine einzelne Opencast Episode anzeigen.';
$string['addactivityepisode_settingintro'] = 'Beschreibung zur Einzelvideo-Aktivität';
$string['addactivityepisode_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast Einzelvideo-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addactivityepisode_settingsection'] = 'Kursabschnitt der Einzelvideo-Aktivität';
$string['addactivityepisode_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast Einzelvideo-Aktivität hinzugefügt wird.';
$string['addactivityepisode_viewicontitle'] = 'Opencast-Einzelvideo-Aktivität im Kurs anzeigen';
$string['addcatalog'] = 'Neues Metadatum hinzufügen';
$string['additional_settings'] = 'Zusätzliche Funktionen';
$string['addlti_addbuttonexplanation'] = 'Die Videos, die zu diesem Kurs hinzugefügt werden bzw. in diesem verfügbar sind, werden den Teilnehmer/innen nicht automatisch angezeigt.</br>Hier können Sie eine Opencast-Serien-Aktivität zum Kurs hinzufügen, welche den Teilnehmer/innen alle sichtbaren Videos anbietet.';
$string['addlti_addbuttontitle'] = 'Opencast-LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['addlti_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addlti_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addlti_defaulttitle'] = 'Opencast Videos';
$string['addlti_errornotenabledorworking'] = 'Die \'Opencast-Serien-Aktivität zum Kurs hinzufügen\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['addlti_formltiavailability'] = 'Voraussetzungen der Opencast-Serien-Aktivität';
$string['addlti_formltiintro'] = 'Beschreibung der Opencast-Serien-Aktivität';
$string['addlti_formltisection'] = 'Kursabschnitt der Opencast-Serien-Aktivität';
$string['addlti_formltititle'] = 'Titel der Opencast-Serien-Aktivität';
$string['addlti_header'] = 'Videos zur Verfügung stellen (LTI)';
$string['addlti_modulecreated'] = 'Die Serien-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addlti_moduleexists'] = 'Es gibt bereits eine Opencast-Serien-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addlti_modulenotcreated'] = 'Die Serien-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addlti_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Serien-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addlti_settingavailability'] = 'Voraussetzungen zur LTI-Serien-Aktivität';
$string['addlti_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast LTI-Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addlti_settingavailability_note'] = 'Bitte beachten Sie: Diese Funktion steht nur zur Verfügung, wenn Voraussetzungen in Moodle auf der {$a} Einstellungsseite aktiviert sind.';
$string['addlti_settingdefaulttitle'] = 'Standard-Titel der LTI-Serien-Aktivität.';
$string['addlti_settingdefaulttitle_desc'] = 'Der standardmäßige Titel der LTI-Aktivität wird verwendet, wenn eine neue Opencast LTI-Serien-Aktivität angelegt wird.';
$string['addlti_settingenabled'] = '"LTI-Serien-Aktivität hinzufügen" aktivieren';
$string['addlti_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast LTI-Serien-Aktivität zum Kurs hinzufügen. Diese LTI-Serien-Aktivität wird die Opencast-Serie des Kurses anzeigen.';
$string['addlti_settingheader'] = 'Opencast LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['addlti_settingintro'] = 'Beschreibung zur LTI-Serien-Aktivität';
$string['addlti_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast LTI-Serien-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addlti_settingpreconfiguredtool'] = 'Vorkonfiguriertes LTI-Serien-Tool';
$string['addlti_settingpreconfiguredtool_desc'] = 'Das vorkonfiguriertes LTI-Serien-Tool wird verwendet, wenn eine neue Opencast LTI-Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addlti_settingpreconfiguredtool_notools'] = 'Kein vorkonfiguriertes LTI-Tool gefunden. Legen Sie zuerst ein Opencast LTI-Serien-Tool über die Einstellungsseite unter {$a} an.';
$string['addlti_settingsection'] = 'Kursabschnitt der LTI-Serien-Aktivität';
$string['addlti_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast LTI-Serien-Aktivität hinzugefügt wird.';
$string['addlti_viewbuttonexplanation'] = 'Eine Opencast-Serien-Aktivität, die alle verfügbaren Videos im Kurs anzeigt, wurde bereits hinzugefügt.';
$string['addlti_viewbuttontitle'] = 'Opencast-Serien-Aktivität im Kurs anzeigen';
$string['addltiepisode_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addltiepisode_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addltiepisode_addicontitle'] = 'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addltiepisode_defaulttitle'] = 'Opencast Einzelvideo';
$string['addltiepisode_errorepisodeuuidnotvalid'] = 'Die vorliegende UUID des Einzelvideos ist nicht gültig';
$string['addltiepisode_errornotenabledorworking'] = 'Die \'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['addltiepisode_explanation'] = 'Zusätzlich können Sie in der obenstehenden Tabelle Aktivitäten für Opencast Einzelvideos zu Ihrem Kurs hinzufügen um Ihren Teilnehmer/innen ein einzelnes Video bereitzustellen.';
$string['addltiepisode_formltiavailability'] = 'Voraussetzungen der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltiintro'] = 'Beschreibung der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltisection'] = 'Kursabschnitt der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltititle'] = 'Titel der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_modulecreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addltiepisode_moduleexists'] = 'Es gibt bereits eine Opencast-Einzelvideo-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addltiepisode_modulenotcreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addltiepisode_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Einzelvideo-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addltiepisode_settingavailability'] = 'Voraussetzungen zur LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addltiepisode_settingenabled'] = '"LTI-Einzelvideo-Aktivität hinzufügen" aktivieren';
$string['addltiepisode_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen. Diese LTI-Einzelvideo-Aktivität wird eine einzelne Opencast Episode anzeigen.';
$string['addltiepisode_settingheader'] = 'Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addltiepisode_settingintro'] = 'Beschreibung zur LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast LTI-Einzelvideo-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addltiepisode_settingpreconfiguredtool'] = 'Vorkonfiguriertes LTI-Einzelvideo-Tool';
$string['addltiepisode_settingpreconfiguredtool_desc'] = 'Das vorkonfiguriertes LTI-Einzelvideo-Tool wird verwendet, wenn eine neue Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addltiepisode_settingpreconfiguredtool_notools'] = 'Kein vorkonfiguriertes LTI-Tool gefunden. Legen Sie zuerst ein Opencast LTI-Einzelvideo-Tool über die Einstellungsseite unter {$a} an.';
$string['addltiepisode_settingsection'] = 'Kursabschnitt der LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast LTI-Einzelvideo-Aktivität hinzugefügt wird.';
$string['addltiepisode_viewicontitle'] = 'Opencast-Einzelvideo-Aktivität im Kurs anzeigen';
$string['addnewcatalogfield'] = 'Ein neues Feld wurde zu den möglichen Metadaten hinzugefügt.';
$string['addrole'] = 'Neue Rolle hinzufügen';
$string['addvideo'] = 'Video hinzufügen';
$string['addvideonotallowed'] = 'Sie dürfen kein Video zu dieser Serie hochladen.';
$string['adhocfiledeletion'] = 'Videodatei in Moodle löschen';
$string['adhocfiledeletiondesc'] = 'Wenn die Option aktiviert ist, versucht das Plugin, die Videodatei aus dem Dateisystem von Moodle zu löschen, sobald es auf den Opencast-Server hochgeladen wurde.
    Beachten Sie bitte, dass die Datei weiterhin im Dateisystem verbleibt, wenn sie an anderen Stellen in Moodle verwendet wird.';
$string['adminchoice_noconnection'] = '– Workflows konnten nicht ermittelt werden –';
$string['adminchoice_noworkflow'] = '-- kein Workflow --';
$string['allowunassign'] = 'Erlauben, die Zuordnung zum Kurs aufzuheben';
$string['allowunassigndesc'] = 'Die Zuordnung einer Serie löschen, um die Sichtbarkeit in Datei-Browser und Kurs-Listen zu kontrollieren. Dieses Feature steht nur zur Verfügung, wenn Episoden unabhängig von einer Serie in Opencast möglich sind. Bitte fragen Sie vor der Aktivierung den Administrator Ihres Opencast-Systems.';
$string['appearance_overview_settingheader'] = 'Überblicksseite';
$string['appearance_overview_settingshowenddate'] = 'Enddatum anzeigen';
$string['appearance_overview_settingshowenddate_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche das Enddatum der Opencast Episoden ausgibt.';
$string['appearance_overview_settingshowlocation'] = 'Raum anzeigen';
$string['appearance_overview_settingshowlocation_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche den Raum der Opencast Episoden ausgibt.';
$string['appearance_overview_settingshowpublicationchannels'] = 'Publikationskanäle anzeigen';
$string['appearance_overview_settingshowpublicationchannels_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche die Publikationskanäle der Opencast Episoden ausgibt. Dieselbe Information wird auch auf der Seite, auf der Opencast Episoden gelöscht werden, ausgegeben werden.';
$string['appearance_settings'] = 'Erscheinungsbild';
$string['backupopencastvideos'] = 'Opencast Videos in diesem Kurs einbeziehen';
$string['blocksettings'] = 'Einstellungen für einen Opencast-Block';
$string['cachedef_videodata'] = 'Speichert die Ergebnisse der Opencast API vom Opencast Block im Cache';
$string['cachevalidtime'] = 'Gültige Cache Zeit';
$string['cachevalidtime_desc'] = 'Zeit in Sekunden bevor die gecachten Videodaten pro Kurs erneuert werden';
$string['cantdeletedefaultseries'] = 'Sie können die Standard-Serie nicht löschen. Wählen Sie bitte eine andere Standard-Serie, bevor Sie diese Serie löschen.';
$string['catalog_params_noarray'] = 'Die Parameter müssen entweder leer sein oder im JSON Format (Array oder Objekt) angegeben werden.';
$string['catalog_static_params_empty'] = 'Schreibgeschützte Felder müssen einen Text im Parameter-Feld definieren';
$string['catalogparam'] = 'Parameter im JSON-Format';
$string['changeowner'] = 'Besitzer/in wechseln';
$string['changeowner_explanation'] = 'Derzeit sind Sie der Eigentümer des Videos {$a}.<br>Sie können die Eigentümerschaft auf eine andere Person übertragen.<br><b>Hinweis:</b> Möglicherweise verlieren Sie das Recht, auf das Video zuzugreifen.';
$string['changeownerseries_explanation'] = 'Derzeit sind Sie der Eigentümer der Serie {$a}.<br>Sie können die Eigentümerschaft auf eine andere Person übertragen.<br><b>Hinweis:</b> Sie verlieren möglicherweise das Recht, auf die Serie zuzugreifen.';
$string['changevisibility'] = 'Sichtbarkeit ändern';
$string['changevisibility_group'] = 'Das Video ist für alle Teilnehmer/innen ausgewählter Gruppen sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changevisibility_header'] = 'Sichtbarkeit für {$a->title} ändern';
$string['changevisibility_hidden'] = 'Das Video ist für Teilnehmer/innen nicht sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changevisibility_mixed'] = 'Der Sichtbarkeitsstatus des Videos ist ungültig. Bitte klicken, um die richtige Sichtbarkeit auszuwählen.';
$string['changevisibility_visible'] = 'Das Video ist für alle Teilnehmer/innen des Kurses sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changingownerfailed'] = 'Ein Fehler ist aufgetreten. Die Eigentümerschaft konnten nicht übertragen werden.';
$string['changingownersuccess'] = 'Die Eigentümerschaft wurden erfolgreich übertragen.';
$string['claimowner_explanation'] = 'Derzeit ist niemand Eigentümer des Videos {$a}.<br>Sie können die Eigentümerschaft beanspruchen oder eine andere Person als Eigentümer festlegen.<br><b>Hinweis:</b> Möglicherweise verlieren Sie  das Recht, auf das Video zuzugreifen, wenn Sie die Eigentümerschaft nicht selbst beanspruchen.';
$string['claimownerseries_explanation'] = 'Derzeit ist niemand Eigentümer der Serie {$a}.<br>Sie können die Eigentümerschaft beanspruchen oder eine andere Person als Eigentümer festlegen.<br><b>Hinweis:</b> Möglicherweise verlieren Sie  das Recht, auf die Serie zuzugreifen, wenn Sie die Eigentümerschaft nicht selbst beanspruchen.';
$string['connection_failure'] = 'Der Opencast Server kann nicht erreicht werden.';
$string['contributor'] = 'Mitwirkende';
$string['coursefullnameunknown'] = 'Unbekannter Kursname';
$string['created'] = 'Erstellt am';
$string['createdby'] = 'Hochgeladen von';
$string['createseriesforcourse'] = 'Neue Serie anlegen';
$string['creator'] = 'Vortragende(r)';
$string['cronsettings'] = 'Einstellungen für das Hochladen';
$string['date'] = 'Startdatum';
$string['dcmitermsnotice'] = '<strong>WICHTIG</strong>: Opencast unterstützt standardisierte Dublin Core-Metadatensätze, daher sollten alle Metadatenfelder den DCMI-Begriffen entsprechen,
     Andernfalls führt der Versuch, ein unbekanntes Metadatenfeld hinzuzufügen, zu einem Fehler.<br />
     Sie können die Liste aller verfügbaren Begriffe zur Verwendung unter <a target="_blank" href="https://www.dublincore.org/specifications/dublin-core/dcmi-terms/">DCMI-Metadatenbedingungen</a einsehen >.';
$string['default'] = 'Standard';
$string['defaultssaved'] = 'Standardwerte wurden gespeichert.';
$string['delete_confirm_metadata'] = 'Sind Sie sich sicher, dass Sie dieses Metadaten-Feld löschen möchten?';
$string['delete_confirm_role'] = 'Möchten Sie diese Rolle wirklich löschen?';
$string['delete_confirm_series'] = 'Möchten Sie diese Serie wirklich löschen? <br/><b>Hinweis:</b> Für die Serie wird nur die Verlinkung für diesen Kurs entfernt. Sie wird aber nicht in Opencast gelöscht.';
$string['delete_metadata'] = 'Metadaten-Feld löschen';
$string['delete_role'] = 'Rolle löschen';
$string['delete_series'] = 'Serie löschen';
$string['delete_series_failed'] = 'Das Löschen der Serie ist fehlgeschlagen. Versuchen Sie es bitte später erneut oder kontaktieren Sie den Administrator.';
$string['deleteaclgroup'] = 'Video aus dieser Liste löschen.';
$string['deletedraft'] = 'Ein Video vor der Übertragung nach Opencast löschen';
$string['deletedraftdesc'] = 'Sie sind im Begriff, dieses Video vor der Übertragung nach Opencast zu löschen.<br />Es wird aus der Warteschlange entfernt und nicht verarbeitet werden. Bitte fahren Sie nicht fort, es sei denn, Sie sind sich absolut sicher.';
$string['deleteevent'] = 'Eine Episode in Opencast löschen';
$string['deleteeventdesc'] = 'Sie sind im Begriff, dieses Video dauerhaft und irreversibel aus Opencast zu löschen.<br />Alle eingebetteten Links zu diesem Video werden ungültig. Bitte fahren Sie nicht fort, es sei denn, Sie sind sich absolut sicher.';
$string['deletegroupacldesc'] = 'Sie sind im Begriff, den Zugang zu diesem Video aus diesem Kurs zu löschen.<br />Wenn der Zugang gelöscht ist, wird das Video nicht im Datei-Browser und in der Übersicht der verfügbaren Videos angezeigt. Bereits eingebettete Videos sind davon nicht betroffen.<br />Das Video wird in Opencast nicht gelöscht.';
$string['deleteworkflow'] = 'Bevor eine Episode gelöscht wird, Workflow starten';
$string['deleteworkflowdesc'] = 'Bevor ein Video gelöscht wird, kann ein Workflow definiert werden, der die Verbindungen der Episode zu den verschiedenen Publikationskanälen kappt.';
$string['deleting'] = 'Wird gelöscht';
$string['description'] = 'Beschreibung';
$string['descriptionmdfn'] = 'Feldname';
$string['dodeleteaclgroup'] = 'Videozugriff aus diesem Kurs löschen';
$string['dodeletedraft'] = 'Video vor der Übertragung nach Opencast löschen';
$string['dodeleteevent'] = 'Video endgültig löschen';
$string['download_setting'] = 'Download Kanal';
$string['download_settingdesc'] = 'Opencast Publikationskanal, aus dem die Videos für den Download zur Verfügung gestellt werden';
$string['download_settingheader'] = 'Videos herunterladen';
$string['downloadvideo'] = 'Video herunterladen';
$string['duplicateworkflow'] = 'Workflow zum Duplizieren von Opencast Videos';
$string['duplicateworkflowdesc'] = 'Dieser Workflow wird benötigt um Opencast Videos von einem Kurs in einen anderen zu importieren. Solange kein Workflow gesetzt ist, ist es nicht möglich Opencast Videos zu importieren.';
$string['duration'] = 'Dauer';
$string['editseries'] = 'Serie bearbeiten';
$string['embeddedasactivity'] = 'Eingebettet als Aktivität';
$string['embeddedasactivitywolink'] = 'Eingebettet als Aktivität ohne verknüpfte Serie';
$string['empty_catalogname'] = 'Das Feld darf nicht leer sein';
$string['emptyvideouploaderror'] = 'Sie müssen entweder ein Präsentator-Video oder ein Präsentations-Video hochladen.';
$string['enablechunkupload'] = 'Chunkupload aktivieren';
$string['enableopencaststudiolink'] = 'Link zu Opencast Studio anzeigen';
$string['enableopencaststudiolink_desc'] = 'Wenn diese Option aktiv ist, wird im Block sowie auf der Überblicksseite ein Button für die Aufnahme mit Opencast Studio angezeigt werden.
Opencast Studio muss auf Ihrem Opencast Admin Node laufen und die folgenden LTI Einstellungen müssen ausgefüllt sein.';
$string['enableschedulingchangevisibility'] = 'Planen der Sichtbarkeitsänderung';
$string['enableschedulingchangevisibilitydesc'] = 'Legen Sie ein Datum und einen Sichtbarkeitsstatus für das Video fest, damit eine geplante Task ausgeführt wird.';
$string['erroremailbody'] = '{$a->errorstr} Details: {$a->message}.';
$string['errorgetblockvideos'] = 'Liste kann nicht geladen werden (Error: {$a})';
$string['errorrestorefailedeventsaclchange_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestorefailedseriesaclchange_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestorefailedseriesmapping_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingevents_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingimportmode_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingseries_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingseriesid_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingsourcecourseid_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['eventdeleted'] = 'Das Video wurde gelöscht.';
$string['eventdeletedfailed'] = 'Löschen der Episode fehlgeschlagen';
$string['eventdeletionstarted'] = 'Das Video wird in Kürze gelöscht.';
$string['eventuploadfailed'] = 'Hochladen fehlgeschlagen';
$string['eventuploadsucceeded'] = 'Hochladen erfolgreich';
$string['exists_catalogname'] = 'Das Feld existiert bereits.';
$string['expirydate'] = 'Ablaufdatum';
$string['failedtransferattempts'] = 'Fehlgeschlagene Übertragungsversuche: {$a}';
$string['filetypes'] = 'Akzeptierte Dateitypen';
$string['form_seriesid'] = 'Serien-ID';
$string['form_seriestitle'] = 'Serientitel';
$string['functionalitydisabled'] = 'Diese Funktion ist deaktiviert.';
$string['general_settings'] = 'Allgemeine Einstellungen';
$string['gotooverview'] = 'Zum Überblick...';
$string['group_name_empty'] = 'Das Feld für den Gruppennamen darf nicht leer sein, wenn eine Gruppe angelegt werden soll.';
$string['groupcreation'] = 'Gruppe anlegen';
$string['groupcreationdesc'] = 'Falls ausgewählt, wird eine Gruppe während des Uploads angelegt.';
$string['groupname'] = 'Gruppenname';
$string['groupnamedesc'] = 'Gruppe, zu der das Video hinzugefügt wird. Wichtig: Die Länge des Gruppennamens ist auf 128 Bytes beschränkt. Sie können die Platzhalter [COURSEID] und [COURSENAME] nutzen, die automatisch ersetzt werden.';
$string['groupseries_header'] = 'Gruppe und Serien';
$string['haction'] = 'Aktionen';
$string['heading_actions'] = 'Aktionen';
$string['heading_datatype'] = 'Feldtyp';
$string['heading_delete'] = 'Löschen';
$string['heading_lti'] = 'Einstellung für LTI Konfiguration';
$string['heading_name'] = 'Feldname';
$string['heading_params'] = 'Parameter (JSON)';
$string['heading_permanent'] = 'Endgültig';
$string['heading_position'] = 'Position';
$string['heading_role'] = 'Rolle';
$string['hend_date'] = 'Enddatum';
$string['hlocation'] = 'Ort';
$string['hprovide'] = 'Bereitstellen';
$string['hpublished'] = 'Veröffentlicht';
$string['hstart_date'] = 'Start Datum';
$string['htitle'] = 'Titel';
$string['hvisibility'] = 'Sichtbarkeit';
$string['hworkflow_state'] = 'Status';
$string['importfailed'] = 'Die Serie konnte nicht importiert werden.';
$string['importmode'] = 'Import-Modus';
$string['importseries'] = 'Serie importieren';
$string['importvideos_aclprocessingexplanation'] = 'Die SerienID des ausgewählten Kurses wird in diesem Kurs verwendet und die Zugriffsechte der Serie sowie die Zugriffsrechte ihrer Videos werden entsprechend geändert.';
$string['importvideos_errornotenabledorworking'] = 'Die \'Videos importieren\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['importvideos_importbuttontitle'] = 'Videos importieren';
$string['importvideos_importepisodecleanupfailed'] = 'Mindestens eine der bestehenden Opencast-Einzelvideo-Aktivitäten in diesem Kurs konnte nicht angepasst werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_importheading'] = 'Videos aus einem anderen Kurs importieren';
$string['importvideos_importjobaclchangedone'] = 'Der Import der ausgewählten Serie mit ihren Videos in diesen Kurs war erfolgreich. Sie können nun auf die Videos dieser Liste zugreifen.';
$string['importvideos_importjobaclchangeseriesmappingfailed'] = 'Der Import ist fehlgeschlagen, weil die Zuordnung der Serie zum Kurs fehlgeschlagen ist.';
$string['importvideos_importjobcreated'] = 'Der Import der ausgewählten Videos in diesen Kurs wurde in die Warteschlange gestellt. Der Import wird im Hintergrund durchgeführt werden. Sie müssen nicht auf dieser Seite warten bis der Import abgeschlossen ist. Sobald der Import angestoßen ist, werden die Videos im Abschnitt <em>Videos, die in diesem Kurs verfügbar sind</em> erscheinen.';
$string['importvideos_importjobcreationfailed'] = 'Mindestens eines der Videos konnte nicht in diesen Kurs importiert werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_importseriescleanupfailed'] = 'Mindestens eine der bestehenden Opencast-Einzelvideo-Aktivitäten in diesem Kurs konnte nicht angepasst werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_processingexplanation'] = 'Diese Videos werden in Opencast dupliziert und dann in diesem Kurs verfügbar gemacht werden.';
$string['importvideos_progressbarstep'] = 'Schritt {$a->current} von {$a->last}';
$string['importvideos_sectionexplanation'] = 'In diesem Abschnitt können Sie existierende Videos von anderen Moodle Kursen in diesen Moodle Kurs importieren.';
$string['importvideos_settingcoreenabled'] = 'Video Import innerhalb des Moodle Core Kursimports ermöglichen';
$string['importvideos_settingcoreenabled_desc'] = 'Wenn aktiviert können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse mit Hilfe des Moodle Core Kursimports importieren. Innerhalb des Kursimports gibt es dann eine zusätzliche Option mit der die Videos die innerhalb des Opencast Blocks hochgeladen wurden importiert werden können. Mit dieser Funktionalität können die Trainer/innen alle Videos von einem anderen Kursen per Stapelverarbeitung importieren, aber sie können kein einzelnen Videos davon auswählen.<br />Die Videos werden von einem Moodle Ad-hoc task in Opencast dupliziert und tauchen auf der Opencast Videos Übersichtsseite nach kurzer Verzögerung auf.';
$string['importvideos_settingenabled'] = 'Video-Import ermöglichen';
$string['importvideos_settingenabled_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse importieren. Sie müssen über diese Einstellung hinaus noch einen Workflow festlegen mit welchem die Videos dupliziert werden und eine oder beide der folgenden Einstellungen zum manuellen Import oder zum Import innerhalb des Moodle Core Kursimports aktivieren. Falls Sie keine dieser folgenden Einstellungen aktivieren wird auch diese Einstellung hier keine Auswirkung haben.<br />Im Modus "Ereignisse duplizieren" müssen Sie einen Duplizierungsworkflow weiter festlegen.';
$string['importvideos_settinghandleepisodeenabled'] = 'Opencast-Einzelvideo-Aktivitäten während des Video Imports anpassen';
$string['importvideos_settinghandleepisodeenabled_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen Opencast-Einzelvideo-Aktivitäten, welche von der "Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen" Funktion erzeugt wurden und sich auf zu importierenden Videos beziehen, anpassen. Dies ist insbesondere hilfreich um Aktivitäten, welche aus einem anderen Kurs importiert wurden aber welche weiterhin auf die Videos im anderen Kurs verweisen, anzupassen. Die Einzelvideo-Aktivitäten werden von einem Moodle Ad-hoc task behandelt und sind nach kurzer Verzögerung angepasst.<br />Bitte beachten Sie dass dieser Mechanismus darauf angewiesen ist, dass der Opencast Duplizier Workflow ein Workflow Instance Configuration Field namens \'duplicate_media_package_1_id\' setzt, welches die Einzelvideo-ID des duplizierten Videos enthält. Falls der Workflow dieses Konfigurationsfeld nicht setzt, wird diese Funktion stets fehlschlagen.';
$string['importvideos_settinghandleseriesenabled'] = 'Opencast-Serien-Aktivitäten während des Video Imports anpassen';
$string['importvideos_settinghandleseriesenabled_desc'] = 'Wenn aktiviert können Trainer/innen Opencast-Serien-Aktivitäten, welche von der "Opencast LTI-Serien-Aktivität zum Kurs hinzufügen" Funktion erzeugt wurden und sich auf zu importierenden Videos beziehen, anpassen lassen. Dies ist insbesondere hilfreich um Aktivitäten, welche aus einem anderen Kurs importiert wurden aber welche weiterhin auf die Serie des anderen Kurs verweisen, anzupassen. Die Serien-Aktivitäten werden direkt nach dem Abschluss des Importassistenten angepasst sein.';
$string['importvideos_settingheader'] = 'Videos aus einem anderen Kurs importieren';
$string['importvideos_settingmanualenabled'] = 'Manuellen Video-Import ermöglichen';
$string['importvideos_settingmanualenabled_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse mit Hilfe eines eigenen Opencast Importassistenten importieren. Diese Funktionalität wird auf der Opencast Übersichts-Seite angeboten. Mit dieser Funktionalität können die Trainer/innen alle Videos oder eine Teilmenge der Videos von einem anderen Kurs per Stapelverarbeitung importieren.<br />Die Videos welche im Importassistenten ausgewählt wurden, werden von einem Moodle Ad-hoc task in Opencast dupliziert und tauchen auf der Opencast Videos Übersichtsseite nach kurzer Verzögerung auf.<br />Im Importmodus Änderung der Zugriffsrechte wird die Serien-ID des ausgewählten Kurses im neuen Kurs verwendet. Darüber hinaus werden die Zugriffsrechte der Serie selbst und alle ihre Videos geändert, um den Zugriff auf sie innerhalb des neuen Kurses zu gewähren.<br />Anders als im Modus "Events duplizieren" ist im bereitgestellten Assistenten keine manuelle Auswahl von Videos verfügbar.<br />Bitte beachten Sie, dass es hierzu zwei Rechte block/opencast:manualimporttarget und block/opencast:manualimportsource gibt, mit welchem gesteuert wird welche Rollen aus welchen Kursen in welche Kurse Videos importieren dürfen. Standardmäßig sind diese Rechte der Rolle Manager und Trainer zugewiesen, welche die Funktion dann nutzen können, sobald sie hier aktiviert ist.';
$string['importvideos_settingmodeacl'] = 'Änderung der Zugriffsrechte';
$string['importvideos_settingmodeduplication'] = 'Duplizieren von Events';
$string['importvideos_settings'] = 'Funktionen zum Import von Videos';
$string['importvideos_wizard_availableseries'] = 'Verfügbare Serien in {$a}';
$string['importvideos_wizard_seriesimported'] = 'Zu importierende Serien';
$string['importvideos_wizardstep1coursevideos'] = 'Zu importierende Videos';
$string['importvideos_wizardstep1heading'] = 'Quellkurs auswählen';
$string['importvideos_wizardstep1intro'] = 'Wählen Sie den Quellkurs, von dem die Videos importiert werden sollen, aus der folgenden Kursliste aus.<br />Es stehen Ihnen alle Kurse, aus denen Sie Videos importieren dürfen, zur Auswahl.';
$string['importvideos_wizardstep1series'] = 'Standardserie dieses Kurses';
$string['importvideos_wizardstep1seriesnotfound'] = 'Der Quellkurs hat keine gültige Serien-ID, bitte stellen Sie sicher, dass der von Ihnen ausgewählte Kurs eine Standardreihe hat.';
$string['importvideos_wizardstep1sourcecourse'] = 'Videos von diesem Kurs importieren';
$string['importvideos_wizardstep1sourcecoursenone'] = 'Es gibt keinen Kurs außer diesem Kurs von dem Sie Videos importieren dürfen.';
$string['importvideos_wizardstep2aclheading'] = 'Serie auswählen';
$string['importvideos_wizardstep2aclintro'] = 'Wählen Sie die Serie aus, die Sie aus dem Quellkurs importieren möchten.<br/>
Alle Videos aus dieser Serie werden importiert.';
$string['importvideos_wizardstep2coursevideos'] = 'Diese Videos importieren';
$string['importvideos_wizardstep2coursevideosnone'] = 'Im ausgewählten Kurs gibt es keine Videos';
$string['importvideos_wizardstep2coursevideosnoneselected'] = 'Sie müssen mindestens ein Video zum Import auswählen';
$string['importvideos_wizardstep2heading'] = 'Videos auswählen';
$string['importvideos_wizardstep2intro'] = 'Wählen Sie die Videos aus, die Sie aus dem Quellkurs importieren möchten.<br />Sie können alle Videos auswählen, welche im Quellkurs fertig verarbeitet wurden.';
$string['importvideos_wizardstep3aclheading'] = 'Zusammenfassung';
$string['importvideos_wizardstep3aclintro'] = 'Bitte überprüfen Sie, ob die Zusammenfassung des Videoimports Ihren Erwartungen entspricht, bevor Sie den Import ausführen.';
$string['importvideos_wizardstep3episodemoduleexplanation'] = 'In diesem Kurs existiert mindestens eine Opencast-Einzelvideo-Aktivität, welche sich auf ein Video aus dem Sie die Videos nun importieren, bezieht. Nach dem Import wird diese angepasst werden so dass sie auf das Video in diesem Kurs zeigt.';
$string['importvideos_wizardstep3episodemodulelabel'] = 'Ja, existierende Opencast-Einzelvideo-Aktivitäten für die importierten Videos anpassen';
$string['importvideos_wizardstep3episodemodulesubheading'] = 'Existierende Opencast-Einzelvideo-Aktivität(en) anpassen';
$string['importvideos_wizardstep3heading'] = 'Opencast-Aktivitäten in diesem Kurs anpassen';
$string['importvideos_wizardstep3intro'] = 'In diesem Kurs existieren Opencast-Aktivitäten welche sich auf die zu importierenden Videos beziehen. Diese Aktivitäten werden nach dem Video Import angepasst werden.<br /><strong>Falls Sie sich unsicher sind ob Sie diese Anpassung benötigen, akzeptieren Sie bitte die Voreinstellungen.</strong>';
$string['importvideos_wizardstep3seriesmoduleexplanation'] = 'In diesem Kurs existiert mindestens eine Opencast-Serien-Aktivität, welche sich auf die Serie des Kurses aus dem Sie die Videos nun importieren, bezieht. Nach dem Import wird dies angepasst werden so dass nur noch die Opencast-Serien-Aktivität, welche alle (schon existierenden wie auch jetzt importierten) Videos in diesem Kurs anzeigt, verbleibt.';
$string['importvideos_wizardstep3seriesmodulelabel'] = 'Ja, existierende Opencast-Serien-Aktivitäten für die importierten Videos anpassen';
$string['importvideos_wizardstep3seriesmodulesubheading'] = 'Existierende Opencast-Serien-Aktivität(en) anpassen';
$string['importvideos_wizardstep3skipintro'] = 'In diesem Kurs existieren keine Opencast-Aktivitäten welche sich auf die zu importierenden Videos beziehen.<br />Es muss nichts angepasst werden, bitte gehen Sie zum nächsten Schritt weiter.';
$string['importvideos_wizardstep4coursevideosnone'] = 'Es wurde kein Video zum Import ausgewählt';
$string['importvideos_wizardstep4heading'] = 'Zusammenfassung';
$string['importvideos_wizardstep4intro'] = 'Bitte überprüfen Sie, ob die Zusammenfassung des Videoimports Ihren Erwartungen entspricht, bevor Sie den Import ausführen.<br/>Die Videos werden in die Standardserie importiert.';
$string['importvideos_wizardstep4sourcecoursenone'] = 'Es wurde kein Quellkurs zum Import ausgewählt';
$string['importvideos_wizardstepbuttontitlecontinue'] = 'Weiter';
$string['importvideos_wizardstepbuttontitlerunimport'] = 'Videos importieren und zurück zur Übersicht';
$string['initialvisibilitystatus'] = 'Anfängliche Sichtbarkeit des Videos';
$string['invalidacldata'] = 'Ungültige ACL-Daten';
$string['language'] = 'Sprache';
$string['legendalt'] = 'Weitere Details zu allen möglichen Werten dieser Spalte.';
$string['legenddeletingdesc'] = 'Das Video wird gelöscht und in Kürze entfernt.';
$string['legendocstatecapturingdesc'] = 'Live-Aufnahme in Bearbeitung.';
$string['legendocstatefaileddesc'] = 'Bei der Verarbeitung dieses Videos ist etwas schief gelaufen, und es ist fehlgeschlagen. Wenden Sie sich an den Support/Administrator, um dieses Problem zu beheben.';
$string['legendocstateneedscuttingdesc'] = 'Das Video erfordert weitere Aufmerksamkeit, um die Verarbeitungsphase abzuschließen.';
$string['legendocstateprocessingdesc'] = 'Das Video wird hochgeladen und von Opencast verarbeitet.';
$string['legendocstatesucceededdesc'] = 'Das Video wurde verarbeitet und ist fertig.';
$string['legendplanneddesc'] = 'Das Video wurde für die Verarbeitung eingeplant.';
$string['legendtitle'] = 'Detailtabelle';
$string['legendvisibility_group'] = 'Gruppen-Sichtbarkeit';
$string['legendvisibility_groupdesc'] = 'Das Video ist für alle Teilnehmer/innen sichtbar, die zu ausgewählten Gruppen gehören.';
$string['legendvisibility_hidden'] = 'Verborgen';
$string['legendvisibility_hiddendesc'] = 'Das Video ist für keine/n Teilnehmer/in sichtbar.';
$string['legendvisibility_mixed'] = 'Ungültig';
$string['legendvisibility_mixeddesc'] = 'Die Sichtbarkeit des Videos befindet sich in einem ungültigen Zustand.';
$string['legendvisibility_visible'] = 'Sichtbar';
$string['legendvisibility_visibledesc'] = 'Das Video ist für alle Kursteilnehmer/innen sichtbar.';
$string['license'] = 'Lizenz';
$string['limituploadjobs'] = 'Uploads durch den Cron-Job begrenzen';
$string['limituploadjobsdesc'] = 'Anzahl der Uploads begrenzen, die von einem Cron-Job vorgenommen werden können. Der Cron-Job kann hier eingestellt werden: {$a}';
$string['limitvideos'] = 'Anzahl von Videos';
$string['limitvideosdesc'] = 'Maximale Anzahl von Videos, die in diesem Block angezeigt werden';
$string['linkedinblock'] = 'Verlinkt im Block';
$string['loading'] = 'Loading...';
$string['location'] = 'Raum';
$string['ltimodule_settings'] = 'Funktionen zum Anlegen von Opencast Aktivitäten';
$string['managedefaultredirectlinkwithexp'] = 'Sie können Standardwerte für diese Metadatenfelder hinzufügen, indem Sie:';
$string['managedefaultsforuser'] = 'Standardwerte verwalten';
$string['managedefaultsforuser_desc'] = 'Hier können Sie Standardwerte für Metadatenfelder verwalten, die zum Hinzufügen von Videos und zum Erstellen neuer Serien verwendet werden.
    Wenn Sie hier einen Standardwert für ein Feld hinzufügen, wird dieser automatisch als vordefinierter Wert (Standard) in das Feld auf den genannten Seiten eingefügt.<br />
    HINWEIS: Falls diese Seite leer ist oder Sie nach einem Feld suchen, das hier nicht vorhanden ist, wenden Sie sich bitte an Ihren Systemadministrator und bitten Sie ihn, die Metadatenfelder als Standardfelder zu konfigurieren.';
$string['manageseriesforcourse'] = 'Serien verwalten';
$string['maxseries'] = 'Maximale Anzahl von Serien';
$string['maxseriesdesc'] = 'Gibt an, wie viele Serien einem Kurs zugewiesen werden können. Trainer können keine weiteren Serien hinzufügen/importieren, wenn die maximale Anzahl erreicht ist.';
$string['maxseriesreached'] = 'Sie können diesem Kurs keine weitere Serie hinzufügen, da der Kurs bereits die maximale Anzahl von Serien enthält.';
$string['maxseriesreachedimport'] = 'Derzeit können Sie keine weitere Serie importieren, da der Kurs bereits die maximale Anzahl von Serien enthält.';
$string['mediatype'] = 'Medienquelle';
$string['messageprovider:error'] = 'Fehlerbenachrichtigung bei der Verarbeitung';
$string['messageprovider:opencasteventstatus_notification'] = 'Benachrichtigung über den Status eines Opencast-Ereignisses';
$string['messageprovider:reportproblem_confirmation'] = 'Kopie der gemeldeten Probleme für Opencast Videos';
$string['metadata'] = 'Event Metadaten';
$string['metadata_autocomplete_noselectionstring'] = 'Kein {$a} angegeben!';
$string['metadata_autocomplete_placeholder'] = '{$a} eingeben';
$string['metadatadesc'] = 'Hier können Sie festlegen, welche Metadatenfelder beim Hochladen von Videos nach Opencast gesetzt werden können oder müssen. Sie können Zeilen per Drag & Drop neu anordnen und die Position der Felder im Formular definieren.';
$string['metadataexplanation'] = 'Beim Hochladen existierender Videodateien nach Opencast können Sie mehrere Metadaten Felder befüllen. Diese werden zusammen mit dem Video gespeichert werden.';
$string['metadataseries'] = 'Serien-Metadaten';
$string['metadataseriesdesc'] = 'Hier können Sie festlegen, welche Metadatenfelder für Opencast-Serien beim Hochladen von Videos gesetzt werden können oder müssen. Sie können Zeilen per Drag & Drop neu anordnen und die Position der Felder im Formular definieren.';
$string['metadataseriesupdatefailed'] = 'Fehler beim Aktualisieren der Serienmetadaten.';
$string['missingevent'] = 'Anlegen des Termins fehlgeschlagen';
$string['missinggroup'] = 'Fehlende Gruppe in Opencast';
$string['missingseries'] = 'Fehlende Serie in Opencast';
$string['missingseriesassignment'] = 'Fehlende Serienzuweisung';
$string['morevideos'] = 'Weitere Videos...';
$string['mstatecreatingevent'] = 'Hochladen...';
$string['mstatecreatinggroup'] = 'Opencast-Gruppe anlegen...';
$string['mstatecreatingseries'] = 'Opencast-Serie anlegen...';
$string['mstatereadytoupload'] = 'Bereit zur Übertragung';
$string['mstatetransferred'] = 'Übertragen';
$string['mstateunknown'] = 'Status unbekannt';
$string['mstateuploaded'] = 'Es werden Post-Upload-Aufgaben verarbeitet...';
$string['noconnectedseries'] = 'Es ist noch keine Serie definiert.';
$string['noseriesid'] = 'Die Serien-ID ist bisher nicht festgelegt.';
$string['nothingtodisplay'] = 'In diesem Abschnitt sehen Sie die Videos, welche in diesem Kurs hochgeladen wurden.<br />Aktuell wurden in diesem Kurs noch keine Videos hochgeladen.';
$string['notificationeventstatus'] = 'Benachrichtigung über den Status von Ereignissen zulassen';
$string['notificationeventstatus_body'] = 'Der Verarbeitungsstatus des hochgeladenen Videos: {$a->videotitle} (ID: {$a->videoidentifier}) im Kurs {$a->coursefullname} (ID: {$a->courseid}) wurde geändert auf: {$a->statusmessage}';
$string['notificationeventstatus_subj'] = 'Benachrichtigung über den Status von Opencast-Ereignis';
$string['notifications_settings_header'] = 'Benachrichtigungen';
$string['notpublished'] = 'Nicht veröffentlicht';
$string['novideosavailable'] = 'Keine Videos';
$string['ocstatecapturing'] = 'Aufzeichnen';
$string['ocstatefailed'] = 'Fehlgeschlagen';
$string['ocstateneedscutting'] = 'Schnitt erforderlich';
$string['ocstateprocessing'] = 'Wird verarbeitet';
$string['ocstatesucceeded'] = 'Erfolgreich';
$string['offerchunkuploadalternative'] = 'Standard Dateiauswahl als Alternative anbieten';
$string['offerchunkuploadalternative_desc'] = 'Wenn diese Einstellung aktiviert ist, wird eine Checkbox mit der Beschriftung \'{$a}\' unterhalb des Chunk-Upload Formularelements angezeigt werden. Sobald die Checkbox aktiviert wird, wird das Chunk-Upload Formularelement verborgen und die standardmäßige Moodle Dateiauswahl wird angezeigt werden, welches den Zugriff auf alle Moodle Repositories ermöglicht.';
$string['opencast:addinstance'] = 'Neuen Block \'Opencast Videos\' hinzufügen';
$string['opencast:addlti'] = 'Opencast LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['opencast:addltiepisode'] = 'Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['opencast:addvideo'] = 'Neues Video zum Block \'Opencast Videos\' hinzufügen';
$string['opencast:createseriesforcourse'] = 'In Opencast eine neue Serie für einen Moodle-Kurs anlegen';
$string['opencast:defineseriesforcourse'] = 'Existierende Opencast-Serie mit einem Moodle-Kurs verbinden';
$string['opencast:deleteevent'] = 'Video (Episode) endgültig in Opencast löschen';
$string['opencast:manualimportsource'] = 'Videos manuell von diesem Kurs importieren';
$string['opencast:manualimporttarget'] = 'Videos manuell von anderen Kursen importieren';
$string['opencast:myaddinstance'] = 'Neuen Block \'Opencast Videos\' im Dashboard hinzufügen';
$string['opencast:startworkflow'] = 'Manuelles Starten der Workflows für Videos';
$string['opencast:unassignevent'] = 'Zuweisung eines Videos im Kurs aufheben, in dem es hochgeladen wurde.';
$string['opencast:viewunpublishedvideos'] = 'Alle Videos auf dem Opencast-Server ansehen, auch wenn sie noch nicht veröffentlicht sind.';
$string['opencasteditorintegration'] = 'Opencast Editor Integration';
$string['opencaststudiointegration'] = 'Opencast Studio Integration';
$string['overview'] = 'Überblick';
$string['ownedvideosoverview'] = 'Ihre Videos';
$string['ownedvideosoverview_explanation'] = 'Hier können Sie alle Videos sehen, die Ihnen gehören, auf deren Serien Sie aber keinen Zugriff haben.';
$string['owner'] = 'Besitzer/in';
$string['planned'] = 'Geplant';
$string['pluginname'] = 'Opencast Videos';
$string['presentation'] = 'Präsentations-Video';
$string['presentationdesc'] = 'Nutzen Sie das Präsentations-Video falls Sie eine Video Datei mit der Aufzeichnung einer Folienpräsentation or einem Screencast vorliegen haben.';
$string['presentationfile'] = 'Präsentations Datei';
$string['presenter'] = 'Präsentator-Video';
$string['presenterdesc'] = 'Nutzen Sie das Präsentator-Video falls Sie eine Video Datei mit der Aufzeichnung eines Redners oder einen Film vorliegen haben.';
$string['presenterfile'] = 'Präsentator Datei';
$string['privacy:metadata:block_opencast_uploadjob'] = 'Information zu Video-Uploads';
$string['privacy:metadata:block_opencast_uploadjob:courseid'] = 'ID des Kurses, in dem das Video hochgeladen wird';
$string['privacy:metadata:block_opencast_uploadjob:fileid'] = 'ID der Datei/des Videos, das hochgeladen wird';
$string['privacy:metadata:block_opencast_uploadjob:opencasteventid'] = 'ID der Opencast-Episode, die durch den Upload angelegt wird';
$string['privacy:metadata:block_opencast_uploadjob:status'] = 'Status des Upload-Prozesses';
$string['privacy:metadata:block_opencast_uploadjob:timecreated'] = 'Datum des Uploads';
$string['privacy:metadata:block_opencast_uploadjob:timemodified'] = 'Datum der letzten Modifizierung des Uploads';
$string['privacy:metadata:block_opencast_uploadjob:userid'] = 'ID der Person, die das Video hochgeladen hat';
$string['privacy:metadata:core_files'] = 'Der Block \'Opencast Videos\' speichert Dateien (Videos), die von einer Person hochgeladen werden.';
$string['privacy:metadata:opencast'] = 'Der Block \'Opencast Videos\' interagiert mit einer Opencast-Instanz, mit der Daten ausgetauscht werden.';
$string['privacy:metadata:opencast:file'] = 'Die ausgewählte Datei wird nach Opencast hochgeladen.';
$string['processdelete'] = 'Löschen verarbeiten';
$string['processdeletenotification'] = 'Systemnachricht zur Verarbeitung von Löschaufträgen';
$string['processepisodecleanup'] = 'Opencast LTI-Einzelvideos nach Kursimport bereinigen';
$string['processnotification'] = 'Systemnachricht zum Status der Auftragsverarbeitung nach dem Hochladen von Videos';
$string['processupload'] = 'Upload verarbeiten';
$string['publisher'] = 'Herausgeber/in';
$string['publishtoengage'] = 'Zum Engage Player veröffentlichen';
$string['publishtoengagedesc'] = 'Diese Option wählen, um das Video nach dem Upload zum Engage Player zu veröffentlichen. Der eingestellte Workflow muss dies unterstützen.';
$string['recordvideo'] = 'Video aufnehmen';
$string['reportproblem_email'] = 'Dies ist eine automatische Benachrichtigung des Moodle Opencast Plugins.<br>Jemand hat ein Problem mit einem Video gemeldet.<br><br><b>Nutzer/in: </b>{$a->username}<br><b>E-Mail-Adresse: </b>{$a->useremail}<br><b>Moodlekurs: </b><a href="{$a->courselink}">{$a->course}</a><br><b>Opencast Serie: </b>{$a->series} (Id: {$a->seriesid})<br><b>Opencast-Event-ID: </b>{$a->event} (Id: {$a->eventid})<br><b>Nachricht:</b><br><hr>{$a->message}<hr>';
$string['reportproblem_failure'] = 'Die E-Mail konnte nicht gesendet werden. Bitte wenden Sie sich direkt an das Support-Team.';
$string['reportproblem_modal_body'] = 'Wenn Sie ein Problem mit einem Video haben, können Sie es dem Support-Team melden.';
$string['reportproblem_modal_placeholder'] = 'Bitte erläutern Sie das Problem.';
$string['reportproblem_modal_required'] = 'Bitte geben Sie eine Nachricht ein.';
$string['reportproblem_modal_submit'] = 'Problem melden';
$string['reportproblem_modal_title'] = 'Ein Problem melden';
$string['reportproblem_notification'] = '#### Dies ist eine Kopie der E-Mail, die an das Support-Team gesendet wurde. ####<br>';
$string['reportproblem_subject'] = 'Moodle Opencast Plugin: Problem gemeldet';
$string['reportproblem_success'] = 'Die E-Mail wurde erfolgreich an das Support-Team gesendet.';
$string['restoreopencastvideos'] = 'Videos wiederherstellen von Opencast-Instanz {$a}';
$string['reuseexistingupload'] = 'Bereits existierende Uploads nutzen';
$string['reuseexistinguploaddesc'] = 'Falls aktiviert, werden Videos mit demselben content hash nur einmal nach Opencast hochgeladen. Dies spart Speicherplatz und Rechenleistung, aber es könnte Probleme verursachen, wenn Sie mit spezifischen Zugangsrichtlinien zu Opencast-Serien arbeiten.';
$string['rightsHolder'] = 'Rechte';
$string['rolename'] = 'Rollenname';
$string['savedefaults'] = 'Standardeinstellungen speichern';
$string['scheduledvisibilitystatus'] = 'Ändern der Videosichtbarkeit auf';
$string['scheduledvisibilitytime'] = 'Ändern der Videosichtbarkeit';
$string['scheduledvisibilitytimeerror'] = 'Der geplante Zeitpunkt zum Ändern der Sichtbarkeit muss mindestens 20 Minuten nach dem aktuellen Datum und der aktuellen Uhrzeit liegen.';
$string['scheduledvisibilitytimehi'] = 'Geplanter Zeitpunkt';
$string['scheduledvisibilitytimehi_help'] = 'Dieser Zeitpunkt muss in der Zukunft und wie empfohlen mindestens 20 Minuten nach der aktuellen Datumszeit eingestellt werden. Je schneller Ihr Opencast-Server das Video verarbeitet, desto näher kann dieser Zeitpunkt eingestellt werden.';
$string['series'] = 'Serie';
$string['series_already_exists'] = 'Dieser Kurs wurde bereits einer Serie zugewiesen.';
$string['series_does_not_exist'] = 'Die diesem Kurs zugewiesene Serie ist nicht gültig. Bitte kontaktieren Sie den Administrator.';
$string['series_does_not_exist_admin'] = 'Die Serie mit dem Identifier \'{$a}\' konnte nicht von Opencast abgerufen werden.';
$string['series_name_empty'] = 'Serienname darf nicht leer sein.';
$string['series_not_found'] = 'Die Serie {$a} konnte in Opencast nicht gefunden werden.';
$string['series_used'] = 'Wird in {$a} Kursen verwendet';
$string['seriescreated'] = 'Die Serie wurde angelegt.';
$string['seriesidnotvalid'] = 'Die Serie existiert nicht.';
$string['seriesidsaved'] = 'Die Serien-ID wurde gespeichert.';
$string['seriesidunset'] = 'Die Serien-ID wurde entfernt.';
$string['serieslinkedinblock'] = 'Im Block verlinkte Serien';
$string['seriesname'] = 'Serienname';
$string['seriesnamedesc'] = 'Serie, zu der das Video hinzugefügt wird. Sie können Platzhalter nutzen, welche automatisch ersetzt werden (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders"> Liste der Platzhalter </a>).';
$string['seriesnotcreated'] = 'Die Serie konnte nicht angelegt werden.';
$string['seriesonedefault'] = 'Es darf nur eine Standard-Serie existieren.';
$string['seriesoverview'] = 'Serienübersicht';
$string['seriesoverviewexplanation'] = 'Hier sehen Sie alle Serien, die in einem Kurs verwendet werden, für den Sie die Berechtigung haben, Videos zu verwalten.<br>Serien können vom Block im Kurs verwaltet werden und/oder werden als Aktivität für die Studierenden bereitgestellt.';
$string['seriesoverviewof'] = 'Serienübersicht der Instanz {$a}';
$string['setdefaultseries'] = 'Möchten Sie diese Serie wirklich als neue Standard-Serie verwenden?';
$string['setdefaultseries_heading'] = 'Als Standard-Serie festlegen';
$string['setdefaultseriesfailed'] = 'Die Änderung der Standard-Serie ist fehlgeschlagen. Versuchen Sie es bitte später erneut oder kontaktieren Sie einen Administrator.';
$string['setting_permanent'] = 'Ist permanent';
$string['settings'] = 'Opencast Videos';
$string['shared_settings'] = 'Geteilte Einstellungen';
$string['showvideos'] = 'Videos anzeigen';
$string['source'] = 'Quelle';
$string['space_catalogname'] = 'Das Feld darf keine Leerzeichen enthalten';
$string['startDate'] = 'Datum';
$string['startTime'] = 'Zeit';
$string['startworkflow'] = 'Starte Workflow';
$string['startworkflow_modal_body'] = 'Wählen Sie den Workflow aus, den Sie starten möchten.';
$string['subjects'] = 'Betreff';
$string['submit'] = 'Änderungen speichern';
$string['support_setting'] = 'Support E-Mail-Adresse';
$string['support_setting_notset'] = 'Die Support E-Mail-Adresse wurde nicht definiert. Kontaktieren Sie bitte den Administrator und senden Sie den Bericht erneut.';
$string['support_settingdesc'] = 'E-Mailadresse, an die Berichte gesendet werden, wenn User Probleme mit Videos melden.';
$string['termsofuse'] = 'Nutzungsbedingungen';
$string['termsofuse_accept'] = 'Ich habe die {$a} gelesen und stimme diesen zu.';
$string['termsofuse_accept_toggle'] = 'Nutzungsbedingungen';
$string['termsofuse_desc'] = 'Wenn Sie einen Text eingeben, wird auf der Seite "Video-Upload" ein Kontrollkästchen mit den Nutzungsbedingungen angezeigt.
Die Nutzer müssen die eingegebenen Nutzungsbedingungen akzeptieren, bevor sie das Video hochladen können.';
$string['title'] = 'Titel';
$string['tool_requirement_not_fulfilled'] = 'Die erforderliche Version von tool_opencast ist nicht installiert.';
$string['type'] = 'Medientyp';
$string['unexpected_api_response'] = 'Unerwartete API-Antwort.';
$string['updatemetadata'] = 'Metadaten für dieses Video aktualisieren';
$string['updatemetadata_short'] = 'Metadaten aktualisieren';
$string['updatemetadatafailed'] = 'Die Metadaten konnten nicht gespeichert werden.';
$string['updatemetadatasaved'] = 'Metadaten wurden aktualisiert.';
$string['upload'] = 'Datei hochladen';
$string['uploadexplanation'] = 'Sie haben die Möglichkeit eine "Präsentator" Videodatei und / oder eine "Präsentation" Videodatei hochzuladen.<br />In den meisten Fällen werden Sie nur eine Datei hochladen, Opencast wäre aber auch in der Lage zwei Videodateien gleichzeitig anzunehmen und in einem Medienpaket zu verarbeiten.';
$string['uploadfileextensions'] = 'Akzeptierte Dateitypen';
$string['uploadfileextensionsdesc'] = 'Kommaseparierte Liste der akzeptierten Dateitypen (die Dateitypen müssen in der <a href="{$a}">Liste der Dateitypen</a> existieren). Falls die Einstellung leer gelassen wird, werden alle Dateitypen der Dateitypgruppe \'Video\' zugelassen (Details siehe wieder in der <a href="{$a}">Liste der Dateitypen</a>).';
$string['uploadfilelimit'] = 'Begrenzung der Videogröße';
$string['uploadfilelimitdesc'] = 'Begrenzen Sie die Dateigröße hochgeladener Videos durch den Chunkupload.';
$string['uploadingeventfailed'] = 'Anlegen einer Episode fehlgeschlagen';
$string['uploadjobssaved'] = 'Das Video wurde erfolgreich hochgeladen.<br />Das Video ist nun zur Übertragung nach Opencast bereit. Sie müssen nicht auf dieser Seite warten bis diese Übertragung abgeschlossen ist.';
$string['uploadprocessingexplanation'] = 'Diese Videos werden in Opencast verarbeitet und dann im Kurs verfügbar sein.';
$string['uploadqueuetoopencast'] = 'Warteschlange zur Übertragung nach Opencast';
$string['uploadqueuetoopencastexplanation'] = 'In diesem Abschnitt sehen Sie die Videos, welche von Ihnen oder jemand anderes in diesen Moodle Kurs hochgeladen wurde. Diese Videos stehen nun in der Warteschlage zur Übertragung nach Opencast.<br />Die Übertragung geschieht automatisiert im Hintergrund auf dem Moodle Server. Sie müssen nicht auf dieser Seite warten bis diese Übertragung abgeschlossen ist.';
$string['uploadrecordvideos'] = 'Videos hochladen oder aufnehmen';
$string['uploadrecordvideosexplanation'] = 'In diesem Abschnitt können Sie existierende Videodateien nach Moodle hochladen. Darüber hinaus können Sie Videos direkt mit Opencast Studio aufzeichnen.';
$string['uploadsettings'] = 'Einstellungen für den Chunkuploader';
$string['uploadvideos'] = 'Videos hochladen';
$string['uploadvideosexplanation'] = 'In diesem Abschnitt können Sie existierende Videodateien nach Moodle hochladen.';
$string['uploadworkflow'] = 'Nach Upload Workflow starten';
$string['uploadworkflowdesc'] = 'Den eindeutigen Kurznamen des Workflows einrichten, der nach dem erfolgreichen Hochladen eines Videos nach Opencast gestartet werden soll.
Wenn leer gelassen, wird der Standard-Workflow (ng-schedule-and-upload) genutzt. Fragen Sie nach weiteren Workflows, die eventuell vom Opencast-Administrator angelegt wurden.';
$string['usedefaultfilepicker'] = 'Standardmäßige Dateiauswahl nutzen um auf alle Repositories zuzugreifen';
$string['userisntowner'] = 'Nur Eigentümer/innen des Videos kann die Eigentumsrechte ändern.';
$string['video'] = 'Video';
$string['video_already_uploaded'] = 'Video wurde bereits hochgeladen';
$string['video_not_downloadable'] = 'Dieses Video wurde nicht im Download-Kanal veröffentlicht.';
$string['video_notallowed'] = 'Das Video ist nicht Teil der Kurs-Serie.';
$string['video_retrieval_failed'] = 'Das Video konnte nicht abgerufen werden. Bitte überprüfen Sie die Verbindung zum Opencast-Server.';
$string['videodraftdeletionsucceeded'] = 'Das Video wurde erfolgreich gelöscht';
$string['videodraftnotdeletable'] = 'Das Video kann vor der Übertragung nach Opencast nicht mehr gelöscht werden, da sein Verarbeitungsstatus bereits "{$a}" ist';
$string['videodraftnotfound'] = 'Das Video, welches vor der Übertragung nach Opencast gelöscht werden sollte, wurde nicht gefunden.';
$string['videoeditor_short'] = 'Video Editor';
$string['videoeditorinvalidconfig'] = 'Derzeit ist es nicht möglich, den Opencast Editor zu verwenden, um das Ereignis zu bearbeiten.';
$string['videonotfound'] = 'Video nicht gefunden';
$string['videosavailable'] = 'Videos, die in diesem Kurs verfügbar sind';
$string['videosoverviewexplanation'] = 'Hier können Sie sehen, in welchen Kursen die Videos als Aktivität für die Teilnehmer/innen bereitgestellt werden.<br>Die zweite Spalte zeigt die Aktivitäten der Kurse, in denen die Serie vom Opencast-Block verwaltet wird. Die dritte Spalte zeigt Kurse, in denen das Video eingebettet ist, ohne dass die Serie durch den Block verwaltet wird.';
$string['videostoupload'] = 'Videos, die nach Opencast hochgeladen werden können';
$string['viewviedeosnotallowed'] = 'Sie sind nicht berechtigt, die Videos dieser Serie anzusehen.';
$string['visibility'] = 'Sichtbarkeit des Videos';
$string['visibility_group'] = 'Allen Kursteilnehmer/innen ausgewählter Gruppen Zugang zum Video erlauben';
$string['visibility_hide'] = 'Alle Teilnehmer/innen am Zugang zum Video hindern';
$string['visibility_show'] = 'Allen Teilnehmer/innen den Zugang zum Video erlauben';
$string['visibilityheader'] = 'Sichtbarkeit des Videos';
$string['visibilityheaderexplanation'] = 'Sie können den anfänglichen Sichtbarkeitsstatus des Videos beim Hochladen festlegen und eine geplante Sichtbarkeitsänderung konfigurieren.';
$string['workflow_invalid'] = 'Dieser Workflow existiert nicht oder ist nicht aktiv.';
$string['workflow_not_existing'] = 'Dieser Workflow existiert nicht in Opencast.';
$string['workflow_opencast_invalid'] = 'Dieser Workflow existiert nicht in Opencast oder ist eingeschränkt. Bitte kontaktieren Sie den Administrator.';
$string['workflow_settings_opencast'] = 'Workflow-Einstellungen';
$string['workflow_started_failure'] = 'Start des Workflows ist fehlgeschlagen.';
$string['workflow_started_success'] = 'Der Workflow wurde erfolgreich gestartet.';
$string['workflownotdefined'] = 'Der Workflow für das Aktualisieren von Metadaten ist nicht definiert.';
$string['workflowrolesdesc'] = 'Dieser Workflow wird in Gang gesetzt, wenn temporäre ACL-Regeln gelöscht oder hinzugefügt werden. Falls nicht gesetzt, ist es nicht möglich, die Sichtbarkeit von hochgeladenen Videos über den Block \'Opencast Videos\' zu ändern.';
$string['workflowrolesname'] = 'Workflow zur Aktualisierung der Metadaten';
$string['workflowtag_setting'] = 'Workflow Tag';
$string['workflowtag_settingdesc'] = 'Tag für Opencast-Workflows, die vom Administrator konfiguriert und von Lehrenden manuell gestartet werden können.';
$string['worklowisrunning'] = 'Es läuft zur Zeit ein Workflow ab. Sie können die Sichtbarkeit momentan nicht ändern.';
$string['wrongmimetypedetected'] = 'Ein ungültiger MIME-Type wurde beim Upload von Video {$a->filename} aus Kurs {$a->coursename} genutzt.
Nur Video-Dateien sind erlaubt!';
